CWS MARCH 2002  !!!SPECIAL VERSION FOR SPATIALLY VARIABLE  
CWS START VALUES TAKEN FROM GROPUP 16 !!!
csd   ****************************************************************
csd   *             nit0 reads biochemical parameters                *
csd   ****************************************************************
c
      subroutine nit0(dt)
c
      include 'tbc.prm'
      character*80 com
      logical k_biochem
cdgear
      common /dgearsolv/ cu(maxnn*maxsp)
      common /meth/ hdt,hdtmax,tol,meth,miter,index,ier
cdgear
cNAG
c      common /nagd02/ cu,rtol,atol,fhmin,fhmax,petzld,
c     &                itrace,maxstp,method
c      double precision cu(maxnn*maxsp),rtol(1),atol(1)
c      logical petzld
c      integer itrace,maxstp
c      character*1 method
cNAG
      common /contr3/ cic,ctemp,twc,twratioc,courtol,pectol,icc
      integer*4 icc(maxnnc)
      double precision cic(maxnnc*maxsp),ctemp(maxnnc)
c                                                                       
      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)

      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

      common /chemextern/ rconst0,dh0,t0,chemc,compcomp,bspeccomp,
     &                    conversion,
     &                    areac,disspec,compchem,cname,kname
      double precision rconst0(maxcequa),dh0(maxcequa),t0(maxcequa),
     &                 chemc(maxnn*maxcspec),compcomp(maxckomp,maxsp),
     &                 bspeccomp(maxsp,maxcspec),conversion
      integer*4 areac(maxcequa,maxcspec),disspec(maxcequa)
      character*20  cname(maxcspec),kname(maxckomp)
      logical compchem

c *****************************************************************************
c *  Group 21: read kinetic parameters                                        *
c *****************************************************************************
      iinp=55
      io=66

  600 format(a40)

      read (iinp,*) conversion
      write(io,4356) conversion
 4356 format(/,' Conversion factor concentrations transport -> ',
     &         'biology/chemistry : ',g10.4)

c     convert old unit of max saturation conc. to mol/l
      do 9385 i=1,nsp
         csatmax(i)=csatmax(i)*conversion
         csat(i)=csat(i)*conversion
 9385 continue

      read(55,*) k_biochem
      if(k_biochem) then

      do 115 j=1,maxsp
        bactspec(j)=.false.
        do 116 i=1,maxreac
          dmonod(i,j)=0.d0
          yield(i,j)=0.d0
          dinhibit(i,j)=0.d0
 116    continue
 115  continue

      read (iinp,*) dmaxkap
      if (dmaxkap.gt.1.d-40) then
        calckap=.true.
        write(io,*) ' Considering a maximum bacterium capacity of',
     &               dmaxkap
      else
        calckap=.false.
        write(io,*) ' The bacterial capacity is unlimited'
      endif

      read (iinp,*) nreac

      write(io,1000) nreac
 1000 format(/,' Program models ',i2,' reactions of type dX/dt = ..')
      
      if (nreac.gt.maxreac) then
         write(io,*) ' Maximum number of reactions exceeded', maxreac
         write(io,*) ' Increase maxreac and recompile the program'
         write(*,*) ' Maximum number of reactions exceeded'
         write(*,*) ' Demanded number:',nreac,'  Available (maxreac):',
     $        maxreac 
         write(*,*) ' Increase maxreac and recompile the program'
         stop
      endif 

      do 112 i=1,nreac
        read (iinp,*) bacterium(i),growth(i),vmax(i),nrmonod,nrinhi

        write(io,'(/,a,i2)')    ' Reaction ',i
        write(io,'(a,i2,a,a20)')' Species of bacteria       : ',
     &            bacterium(i),' ',spname(bacterium(i))
        if (growth(i)) then
          write(io,'(a)')       ' Bacteria grow'
        else
          write(io,'(a)')       ' Bacteria dont grow'
        endif
        write(io,'(a,g10.4,a)') ' Maximum growth velocity   : ',
     &            vmax(i),' [1/T]'

        if ((bacterium(i).lt.1).or.(bacterium(i).gt.maxsp)) then
          write(*,*) ' !!! invalid Bacterium number !!!'
        else
          bactspec(bacterium(i))=.true.
        endif

        if (nrmonod.gt.0) then
          write(io,'(2a)')       ' Monod-constant   Yield-factor',
     &                  '   Species   Name of Species'

          do 113 j=1,nrmonod
            read (iinp,*) ispec,ddmonod,dyield
            if ((ispec.lt.1).or.(ispec.gt.nsp)) then
               write(*,*) 'ERROR: Species nr ',ispec,
     $              ' demanded in biochemical reaction ', i
               write(io,*) 'ERROR: Species nr ',ispec,
     $              ' demanded in biochemical reaction ', i
               stop 'Illegal input, execution aborted'
            end if
            dmonod(i,ispec)=ddmonod
            write(io,1002) ddmonod,dyield,ispec,spname(ispec)
c  conversion, if phase of species <> biophase
            yield(i,ispec)=dyield*volume(phase(bacterium(i)))
     $           /volume(phase(ispec))
 113      continue
        else
          write(io,'(a)') ' There are no Monod-controlling species'
        endif
 1002   format(2g15.5,i10,3x,a20)

        if (nrinhi.gt.0) then
          write(io,'(2a)')       ' Inhibition-constant',
     &                  '   Species   Name of Species'
          do 114 j=1,nrinhi
            read(iinp,*) ispec,ddinhibit
            dinhibit(i,ispec)=ddinhibit
            write(io,1003) ddinhibit,ispec,spname(ispec)
 114      continue
        else
          write(io,'(a)') ' There are no inhibition-terms'
        endif
 1003   format(g15.5,i10,3x,a20)

  112 continue

cdsds

c *****************************************************************************
c *  Group 21a: read NAG- or DGEAR-solver input                                          *
c *****************************************************************************

cNAG
c      read(iinp,600) com
c      read(iinp,*) rtol(1),atol(1)
c      read(iinp,*) fhmin,fhmax
c      read(iinp,*) itrace,maxstp
c      read(iinp,*) method,petzld
cc
c      write(io,1035) rtol(1),atol(1),fhmin,fhmax,itrace,maxstp
c1035  format(/,/,42('*'),/,'Settings for NAG D02 stiff equation ',
c     &   'solver',/,42('*'),/,
c     & /,' Relative local error tolerance            : ',d10.4,
c     & /,' Absolute local error tolerance            : ',d10.4,
c     & /,' Fraction of dt for min iteration-timestep : ',d10.4,
c     & /,' Fraction of dt for max iteration-timestep : ',d10.4,
c     & /,' Level of output information               : ',i10,
c     & /,' Maximum number of iteration-steps         : ',i10)
c      if (method.eq.'f'.or.method.eq.'F') then
c        method='F'
c        write(io,'(a)') ' Functional iteration is used.'
c      else if (method.eq.'n'.or.method.eq.'N'.or.method.eq.'d'
c     &                      .or.method.eq.'D') then
c        method='N'
c        write(io,'(a)') ' Modified Newton iteration is used.'
c      else
c        method='N'
c        write(io,'(a)') ' WARNING ! Method (Char*1) has wrong ',
c     &                  'value !'
c        write(io,'(a)') ' Modified Newton iteration is used.'
c      endif
c      if (petzld) then
c        write(io,'(a)') ' Petzold local error test is used.'
c      else
c        write(io,'(a)') ' Petzold local error test is not used.'
c      endif
cNAG

cdgear
      read(iinp,600) com
      read(iinp,*) meth,miter,tol,hdt,hdtmax

      hdt=dmin1(hdt,dt/1.d3)
 605  format(/'Parameters for the gear subroutine:'/
     1     '  Initial time step, hdt:',t45,g12.6/
     2     '  Max. init. time step, hdtmax:' ,t45,g12.6/
     3         '  Solution method:',t51,i6/
     4         '  Iteration method, miter:',t51,i6,//)
cdgear


       else
         write(66,4598)
 4598    format(/'No biochemical reactions are computed.',/
     $        ,'Using dgear default settings for exchange.')
         nreac=0
         calckap=.false.
         meth=2
         miter=1
         tol=1.d-5
         hdt=dt/1.d4
         hdtmax=hdt
         write(io,605) hdt,hdtmax,meth,miter
       endif


      return
      end

c
csd   ****************************************************************
csd   *        readkinet reads input for kinetical chemistry         *
csd   ****************************************************************
c
      subroutine readkinet
c
      include 'tbc.prm'

      parameter(maxinvol=4)
      double precision help(maxcspec),dhelp(2*maxinvol)
      character*80 grtitle
      logical compkinet
c
      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)

      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

      common /chemextern/ rconst0,dh0,t0,chemc,compcomp,bspeccomp,
     &                    conversion,
     &                    areac,disspec,compchem,cname,kname
      double precision rconst0(maxcequa),dh0(maxcequa),t0(maxcequa),
     &                 chemc(maxnn*maxcspec),compcomp(maxckomp,maxsp),
     &                 bspeccomp(maxsp,maxcspec),conversion
      integer*4 areac(maxcequa,maxcspec),disspec(maxcequa)
      character*20  cname(maxcspec),kname(maxckomp)
      logical compchem

      common /chemintern/ ckomp,akomp,temprconst,tolf,tolx,
     &                    activity,gwtemp,tempareac,icharge,
     &                    maxits,activ
      double precision ckomp(maxckomp),akomp(maxckomp,maxcspec),
     &                 temprconst(maxcequa),activity(maxcspec),
     &                 tolf,tolx,gwtemp
      integer*4 icharge(maxcspec),
     &          tempareac(maxcequa,maxcspec),
     &          maxits
      logical activ

      common /kinetchem/ rckin0,rckin,stoech,cxalt,dt,reack,
     &                   kinetspec,kkomp,idepend
      double precision rckin0(maxkspec,maxkreac),
     &                  rckin(maxkspec,maxkreac),dt,
     &     stoech(maxkspec,maxckomp),cxalt(maxkspec),
     &     reack(maxkspec,maxcspec,maxkreac)
      integer kinetspec(maxkspec),
     &        kkomp(maxkspec),idepend(maxkspec)

      common /chemanz/ ncspec,nckomp,ncequa,nkspec
      integer*4        ncspec,nckomp,ncequa,nkspec


c *****************************************************************************
c *  Group 23: read kinetic parameters                                        *
c *****************************************************************************
      iinp=55
      io=66

10    format(a80)

      read (iinp,*) compkinet
      if (compkinet) then


      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 23'
         stop
      endif
      read (iinp,*) nkspec

      if (nkspec.gt.maxkspec) then
        write(*,*) ' Too many kinetic species !'
        write(*,*) ' Increase MAXKSPEC and recompile the program'
        stop
      endif

      if ((nckomp+ncequa+nkspec).lt.ncspec) then
         write(66,*) ' Insufficient number of kinetic species defined'
         
         stop
      endif

      write(io,1000) nkspec
 1000 format(//,37('*'),/,' Parameters of kinetical chemical reactions',
     &        /,37('*'),/,/,
     &     ' Program models ',i2
     $     ,' species with 2 reactions of type dC/dt = ... each')


      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 23'
         stop
      endif

      do 220 i=1,nkspec
        do 220 j=1,ncspec
          do 220 k=1,maxkreac
          reack(i,j,k)=0.
220   continue
      do 290 i=1,nkspec
        do 290 k=1,nckomp
290   stoech(i,k)=0.d0


      do 200 i=1, nkspec

         write(66,'(/,4(1x,a20))')  'Species Nr. (bio)   ',
     $                              'Species Name (bio)  ',
     $                              'Species Nr. (chem)  ', 
     $                              'Species Name (chem.)'


        read(55,*) kkomp(i),kinetspec(i)
        write(66,'(2(1x,i10,11x,a20))') kkomp(i), spname(kkomp(i)), 
     &      kinetspec(i),cname(kinetspec(i))

        read(55,*) idepend(i)
        if (idepend(i).gt.0) then
          write(66,*)
     $       'This dissolution/precipitation reaction requires species'
     $       ,idepend(i),cname(idepend(i))
        else
           write(66,*)
     $          'This is no dissolution/precipitation reaction or ',
     $          'the mineral is always available'
        endif

        write(66,'(99(1x,a12))') 'React.const.',(cname(j),j=1,ncspec)

        do 578 k=1,maxkreac

          read(55,*) rckin0(i,k),(dhelp(j),j=1,2*maxinvol)
 
          do 210 j=1,2*maxinvol,2
            if(int(dhelp(j)).gt.0) then
              reack(i,int(dhelp(j)),k)=dhelp(j+1)
            endif
210       continue
          write(66,'(1x,e12.5,99(1x,g12.4))')
     &          rckin0(i,k),(reack(i,j,k),j=1,ncspec)

578     continue

        write(66,'(a)') ' Usage of komponents'
        write(66,'(99(1x,a12))') (kname(j),j=1,nckomp)

        read(55,*) (help(j),j=1,ncspec)

        do 310 j=1,ncspec
          do 320 k=1,nckomp
            stoech(i,k)=stoech(i,k)+help(j)*akomp(k,j)
320       continue
310     continue
        write(66,'(99(1x,g12.4))') (stoech(i,j),j=1,nckomp)


200   continue

      else      ! compkinet = false

        write(66,6456)
 6456 format(//,40('*'),/,
     &    '* Input data for kinetic chemistry *',/,40('*'),//,
     &    '  No kinetic chemistry computed !',/)

        nkspec=0

      endif

      return
      end

c                                                                       
cws   ****************************************************************
cws   *     nit1 initializes values for solution with gear method    *
cws   ****************************************************************
c
      subroutine nit1(cexch,nn,t,dt)
c                                                                       
      include 'tbc.prm'
cdgear
      parameter (nwk=11*nglmax+nglmax*nglmax)
      dimension iwk(nglmax),wk(nwk),y(nglmax)
      common /flags/ kfdm,klump,kgrid,kpmsh,kplane,kphead,kpvel,
     +               krestar,kwrith,kpmasb,
     +               inactnode,inactelem
      logical inactnode(maxnn), inactelem(maxne)
c
      common /dgearsolv/ cu
      double precision cu(maxnn*maxsp)
      external fcn,fcnj
      common /meth/ hdt,hdtmax,tol,meth,miter,index,ier
      common /dband/ nlc,nuc
cdgear
cNAG
c      parameter (nwk     = 50+4*nglmax,
c     &           nwkjac  = nglmax*(nglmax+1),
c     &           maxord  = 5,
c     &           ny2dim  = maxord+1)
cc
c      common /nagd02/ cu,rtol,atol,fhmin,fhmax,petzld,
c     &                itrace,maxstp,method
c      character*1 method
c      double precision cu(maxnn*maxsp),y(nglmax),
c     &                 rtol(1),atol(1)
c      integer itrace,maxstp,inform(23)
c      logical petzld
c      double precision wk(nwk),dy(nglmax),algequ(nglmax)
c     &                ,ysave(nglmax,ny2dim),wkjac(nwkjac),rconst(6)
c      external fcn,jac,d02nbf,d02nvf,d02nsf,d02nyf,d02nby
cNAG

      dimension cexch(maxnn*maxsp)
      common /contr3/ cic,ctemp,twc,twratioc,courtol,pectol,icc
      integer*4 icc(maxnnc)
      double precision cic(maxnnc*maxsp),ctemp(maxnnc)

      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)

      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

c      common /kinetchem/ rckin0,rckin,stoech,nkinet,kinetspec,kreac
c      double precision rckin0(maxkinet),rckin(maxkinet),
c     &      stoech(maxkinet,maxsp)
c      integer kinetspec(maxkinet),kreac(maxkinet,maxsp)



csd      write(90,*) ' Starting chemical loop'
      hdt=dmin1(hdt*1.5,hdtmax)
cws   loop over all nodes
      do 10 i=1,nn
cws    leave out inactive and frist-type nodes
cws       if(.not.inactnode(i)) then
cws        if(icc(i).eq.0) then
       if(.not.inactnode(i).and.icc(i).eq.0) then
c                                                                       
c
          index=1
          h=hdt
          t0=t-dt
c

          do 2540 j=1,nsp
            if (indexy(j).gt.0) then
              y(indexy(j)) = cic((j-1)*nn+i)
            endif
            if (phase(j).eq.1) then
              cexch_dt(j)=cexch((j-1)*nn+i)/dt
            else
              cexch_dt(j)=0.d0
            endif
 2540    continue

         if (napl_interaction) then
            sumc=0
            do 555 j=1,nsp
               if(phase(j).eq.4) then
                  sumc=sumc+cic((j-1)*nn+i)*cmolfac(j)
               endif
 555        continue
            do 666 j=1,nsp
               if(phase(j).eq.4) then
                  csat(j)=csatmax(j)*cic((j-1)*nn+i)*cmolfac(j)/sumc
               endif
 666        continue
         endif


c
c  ...solution of the system of ordinary diffrential equations
c     the differential equations are formed in function fcn
c     the partial derivatives (hesse-matrix) are formed in fcnj
c
cdgear
          call dgear(ngl,fcn,fcnj,t0,h,y,t,tol,meth,miter,
     &      index,iwk,wk,ier)
          if(ier.gt.128) then
            write(*,*) 'Stop ier = ',ier,' node:',i,' time:',t
            stop ' Error in DGEAR'
          endif
cdgear

cNAG
c           do 1294 im=1,6
c1294      rconst(im)=0.d0
cc
c          tanf = t-dt
c          tend = t
c          hmin = fhmin * dt
c          hmax = fhmax * dt
c          h0   = hmin
c          tcrit= t + hmin*.9
c          itol=1
c          itask=4
c          ifail=0
cc
cc          sumt=0.d0
c          talt=tanfa
cc          node=i
cc
c          call d02nvf (nglmax,ny2dim,maxord,method,petzld,
c     &                 rconst,tcrit,hmin,hmax,h0,
c     &                 maxstp,0,'M',wk,ifail)
cc
c          call d02nsf (ngl,nglmax,'A',nwkjac,wk,ifail)
c          if (ifail.ne.0) then
c            write(*,*) ' *** ERROR IN NAG-ROUTINE d02nvf/d02nsf !'
c            write(*,*) '     IFAIL = ',ifail,' NODE = ',i
c            write(*,*)
c          endif
cc
c          ifail = 1
c          call d02nbf (ngl,nglmax,tanf,tend,y,dy,wk,
c     &                 rtol,atol,itol,inform,fcn,
c     &                 ysave,ny2dim,jac,wkjac,nwkjac,
c     &                 d02nby,itask,itrace,ifail)
cc
c          if (ifail.eq.5) then
c            write(*,*) ' *** Integration successful, but ',
c     &                 'problems in node ',i
c          else if (ifail.ne.0) then
c            write(*,*) ' *** ERROR IN NAG-ROUTINE d02nbf !'
c            write(*,*) '     IFAIL = ',ifail,' NODE = ',i
c          endif
cc
cc          call d02nyf(ngl,nglmax,hu,h,tcur,tolsf,wk,nst,
cc     &        nre,nje,nqu,nq,niter,imxer,algequ,inform,ifail)
cNAG


          do 2550 j=1,nsp
            if (indexy(j).gt.0) then
              cu((j-1)*nn+i) = y(indexy(j))
            endif
 2550     continue
c
        endif
  10  continue
c
      return
      end                                                               
c                                                                       
c   ****************************************************************
c   * formulation of the system of ordinary differential equations *
c   ****************************************************************
c
cdgear
      subroutine fcn(n,x,y,yprime)
cdgear
cNAG
c      subroutine fcn(n,t,y,yprime,ires)
cNAG
      include 'tbc.prm'

      dimension y(n),yprime(n)
c
      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)

      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

c      common /kinetchem/ rckin0,rckin,stoech,nkinet,kinetspec,kreac
c      double precision rckin0(maxkinet),rckin(maxkinet),
c     &      stoech(maxkinet,maxsp)
c      integer kinetspec(maxkinet),kreac(maxkinet,maxsp)



      do 10 i=1,n
 10   yprime(i)=0.d0

c
c ... calculate present bacteria capacity
c
      if (calckap) then
        sumx=0.d0
        do 9324 i=1, nsp
          if (bactspec(i)) then
            sumx=sumx+y(indexy(i))
          endif
9324    continue
      endif

c
c ... loop over reactions dX/dt= nymax * X * monodterms * inhibitionterms
c

      do 100 i=1,nreac
         indexy_bac=indexy(bacterium(i))
         if(y(indexy_bac).gt.1.d-50) then
c
c  ... growth of bacteria X caused by reaction i
c
        call bacgrowth(yprimebac,sumx,i,0,n,y)
c
c  ... usage of species
c
        do 120, j=1,nsp
          if (dabs(yield(i,j)).gt.1.0d-40) then
            indexy_spec=indexy(j)
            usage=yield(i,j)*yprimebac
c dS/dt=
            yprime(indexy_spec)=yprime(indexy_spec)+usage
          endif
 120    continue
c
c  ... total growth of bacterium
c
        if (growth(i)) then
          ibac=bacterium(i)
          indexy_bac=indexy(ibac)
          yprime(indexy_bac)=yprime(indexy_bac)+yprimebac
        endif

        endif
 100  continue


c
c  ... loop over species for exchange
c
      do 200 i=1,nsp
        if (phase(i).eq.1) then
c  ... mobil phase, add terms of advective/diffusive transport
          indexy_mob  = indexy(i)
          yprime(indexy_mob)=yprime(indexy_mob)+cexch_dt(i)
c  ... exchange with biophase or matrix
          if (exspec(i).gt.0) then
            indexy_mob   = indexy(i)
            indexy_other = indexy(exspec(i))
            vmob   = volume(phase(i))
            vother = volume(phase(exspec(i)))
            exchange=exchc(i)*(y(indexy_other)-y(indexy_mob))
            yprime(indexy_mob)  = yprime(indexy_mob)+
     &                            exchange/vmob
            yprime(indexy_other)= yprime(indexy_other)-
     &                            exchange/vother
          endif
        elseif (phase(i).eq.2) then
c  ... biophase, exchange with porewater or matrix
          if (exspec(i).gt.0) then
            indexy_bio   = indexy(i)
            indexy_other = indexy(exspec(i))
            vbio   = volume(phase(i))
            vother = volume(phase(exspec(i)))
            exchange=exchc(i)*(y(indexy_other)-y(indexy_bio))
            yprime(indexy_bio)  = yprime(indexy_bio)+
     &                            exchange/vbio
            yprime(indexy_other)= yprime(indexy_other)-
     &                            exchange/vother
          endif
        elseif (phase(i).eq.3) then
c  ... matrix, exchange with porewater or biophase
          if (exspec(i).gt.0) then
            indexy_mat   = indexy(i)
            indexy_other = indexy(exspec(i))
            vmat   = volume(phase(i))
            vother = volume(phase(exspec(i)))
            exchange=exchc(i)*(y(indexy_other)-y(indexy_mat)
     $           /dblkd(i))
            yprime(indexy_mat)  = yprime(indexy_mat)+
     &                            exchange/vmat
            yprime(indexy_other)= yprime(indexy_other)-
     &                            exchange/vother
          endif
        elseif (phase(i).eq.4) then
c  ... NAPL, exchange with mob if available
          indexy_napl  = indexy(i)
          if ((exspec(i).gt.0).and.(y(indexy_napl).gt.0.d0)) then
            indexy_other = indexy(exspec(i))
            exchange=exchc(i)*(y(indexy_other)-csat(i))
c  ... no rebuilding of NAPL
            if (exchange.lt.-1.d-40) then
              vmat   = volume(phase(i))
              vother = volume(phase(exspec(i)))
              yprime(indexy_napl) = yprime(indexy_napl)+
     &                              exchange/vmat
              yprime(indexy_other)= yprime(indexy_other)-
     &                              exchange/vother
            endif
          endif
        endif
 200  continue
c
      return
      end
c
c                                                                     
cws   *************************************************************
cws   *  formulation of partial differentiations (jacobi matrix)  *
cws   *************************************************************
c
cdgear
      subroutine fcnj(n,x,y,pd)
cdgear
cNAG
c      subroutine jac(n,t,y,h,d,pd)
cNAG
c
      include 'tbc.prm'

      dimension y(n),pd(n,n),d2X_dtdS(nglmax)
c
      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)
      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

c      common /kinetchem/ rckin0,rckin,stoech,nkinet,kinetspec,kreac
c      double precision rckin0(maxkinet),rckin(maxkinet),
c     &      stoech(maxkinet,maxsp)
c      integer kinetspec(maxkinet),kreac(maxkinet,maxsp)

c
      do 10 i=1,n
        do 10 j=1,n
          pd(i,j)=0.d0
 10   continue


      if (calckap) then
c
c ... calculate including  bacteria capacity
c
        sumx=0.d0
        do 9324 i=1, nsp
          if (bactspec(i)) then
            sumx=sumx+y(indexy(i))
          endif
9324    continue

c  ... loop over reactions dX/dt= nymax * X * monodterms * inhibitionterms

        do 107 i=1,nreac

          indexy_bac=indexy(bacterium(i))
          if (y(indexy_bac).gt.1.d-50) then

          do 17 j=1,n
 17       d2X_dtdS(j)=0.d0

          call bacgrowth(yprimebac,sumx,i,0,n,y)
c
c  ...  compute partial derivatives of dX
c

c  ...  d2Xi / dt*dXi = XR *(sumx+maxkap-Xi) / (Xi*(sumx+maxkap))
c       only for growth !
c  ...  Xi is NEVER ZERO !
c

          if (vmax(i).gt.0.d0) then
            d2X_dtdS(indexy_bac) = yprimebac
     &                        * (sumx+dmaxkap-y(indexy_bac))
     &                        / (y(indexy_bac)*(sumx+dmaxkap))

c
c  ...  d2Xi / dt*dXj = XR / -(sumx+maxkap)
c
            do 9327 j=1, nsp
              if (bactspec(j).and.(j.ne.indexy_bac)) then
                indexy_bac2=indexy(j)
                d2X_dtdS(indexy_bac2) = yprimebac
     &                        / (sumx+dmaxkap)
              endif
9327        continue
          else
            d2X_dtdS(indexy_bac) = yprimebac / y(indexy_bac)
c
c  ...  d2Xi / dt*dXj = 0 for decay
c
          endif


          do 227 j=1,nsp

            if (dmonod(i,j).gt.1.d-30) then
c
c  ...  d2X / dt*dS_j =      S_j = monod-species
c
c  ...  S_j may be ZERO or below !
c
              indexy_specj=indexy(j)

              if (y(indexy_specj).gt.1.d-40) then

c  ...  S_j .gt. 0, normal Monod Term used
c       divide yprimebac through Monod-Term of spec. j
c       and multiplicate with partial derivate of Monod-Term

                d2X_dtdS(indexy_specj)=yprimebac*dmonod(i,j)/
     &           y(indexy_specj)/(dmonod(i,j)+y(indexy_specj))

              elseif (y(indexy_specj).lt.-1.d-40) then

c  ...  S_j .lt. 0, linear Monod Term used
c
                d2X_dtdS(indexy_specj)=yprimebac/y(indexy_specj)

              else

c  ... S_j near 0, numerical Problems
c  ...  recompute yprimebac without S_j
c       (hope, that will only sometimes occur)

                call bacgrowth(ypb2,1.d0,i,j,n,y)
                d2X_dtdS(indexy_specj) = ypb2/dmonod(i,j)

              endif
            endif


            if (dinhibit(i,j).gt.1.d-40) then

c  ...  d2X / dt*dS_j =      S_j = inhibition-species
c       S_j may be Zero without any problem

              indexy_specj=indexy(j)
              if (y(indexy_specj).ge.0.d0) then
                d2X_dtdS(indexy_specj)= - yprimebac/
     &                    (dinhibit(i,j)+y(indexy_specj))
              else
                d2X_dtdS(indexy_specj)= - yprimebac/
     &                    (dinhibit(i,j)-y(indexy_specj))
              endif
            endif

 227      continue

          if (growth(i)) then
c ...  transfer drivates of X to jacobi matrix
            do 4593 k=1,n
              indexy_speck=indexy(k)
              pd(indexy_bac,indexy_speck)=
     &        pd(indexy_bac,indexy_speck)+d2X_dtdS(k)
 4593       continue
          endif

c
c  ...  d2S_j / dt*dS_k = yield(i,j) * d2X/dt*dS_k
c
          do 320 j=1,nsp
            if (dabs(yield(i,j)).gt.1.0d-40) then
              indexy_specj=indexy(j)
              do 7830 k=1,n
                if (d2X_dtdS(k).ne.0.d0) then
                  pd(indexy_specj,k)=
     &            pd(indexy_specj,k) + yield(i,j)*d2X_dtdS(k)
                endif
 7830         continue
            endif
 320      continue
          
          endif
c  ... end main loop over reactions
 107    continue
        
      else

c
c ... calculate without bacteria capacity
c

c  ... loop over reactions dX/dt= nymax * X * monodterms * inhibitionterms

        do 100 i=1,nreac

          indexy_bac=indexy(bacterium(i))
          if (y(indexy_bac).gt.1.d-50) then

          do 11 j=1,n
 11       d2X_dtdS(j)=0.d0

          call bacgrowth(yprimebac,1.d0,i,0,n,y)

c
c  ...  compute partial derivatives of dX
c

c  ...  d2X / dt*dX = XR / X
c
c  ...  X is NEVER ZERO !
c
          d2X_dtdS(indexy_bac) = yprimebac / y(indexy_bac)
c
c  ...  d2Xi / dt*dXj = 0.
c


          do 220 j=1,nsp

            if (dmonod(i,j).gt.1.d-40) then
c
c  ...  d2X / dt*dS_j =      S_j = monod-species
c
c  ...  S_j may be ZERO or below !
c
              indexy_specj=indexy(j)

              if (y(indexy_specj).gt.1.d-40) then

c  ...  S_j .gt. 0, normal Monod Term used
c       divide yprimebac through Monod-Term of spec. j
c       and multiplicate with partial derivate of Monod-Term

                d2X_dtdS(indexy_specj)=yprimebac*dmonod(i,j)/
     &           y(indexy_specj)/(dmonod(i,j)+y(indexy_specj))

              elseif (y(indexy_specj).lt.-1.d-40) then

c  ...  S_j .lt. 0, linear Monod Term used
c
                d2X_dtdS(indexy_specj)=yprimebac/y(indexy_specj)

              else

c  ... S_j near 0, numerical Problems
c  ...  recompute yprimebac without S_j
c       (hope, that will only sometimes occur)

                call bacgrowth(ypb2,1.d0,i,j,n,y)
                d2X_dtdS(indexy_specj) = ypb2/dmonod(i,j)

              endif
            endif


            if (dinhibit(i,j).gt.1.d-40) then

c  ...  d2X / dt*dS_j =      S_j = inhibition-species
c       S_j may be Zero without any problem

              indexy_specj=indexy(j)
              if (y(indexy_specj).ge.0.d0) then
                d2X_dtdS(indexy_specj)= - yprimebac/
     &                    (dinhibit(i,j)+y(indexy_specj))
              else
                d2X_dtdS(indexy_specj)= - yprimebac/
     &                    (dinhibit(i,j)-y(indexy_specj))
              endif
            endif

 220      continue

          if (growth(i)) then
c ...  transfer drivates of X to jacobi matrix
            do 4597 k=1,n
              if (d2X_dtdS(k).ne.0.d0) then
                pd(indexy_bac,k)=pd(indexy_bac,k)+d2X_dtdS(k)
              endif
 4597       continue
          endif

c
c  ...  d2S_j / dt*dS_k = yield(i,j) * d2X/dt*dS_k
c
          do 327 j=1,nsp
            if (dabs(yield(i,j)).gt.1.0d-40) then
              indexy_specj=indexy(j)
              do 7837 k=1,n
                if (d2X_dtdS(k).ne.0.d0) then
                  pd(indexy_specj,k)=
     &            pd(indexy_specj,k) + yield(i,j)*d2X_dtdS(k)
                endif
 7837         continue
            endif
 327      continue

          endif
c  ... end main loop over reactions
 100    continue

c  ... endif calckap
      endif

c
c  ... loop over species for exchange
c
      do 200 i=1,nsp
        if (exspec(i).gt.0) then

        if (phase(i).eq.1) then

c  ... mobil phase, exchange with biophase, no kd

          indexy_mob   = indexy(i)
          indexy_other = indexy(exspec(i))
          vmob   = volume(phase(i))
          vother = volume(phase(exspec(i)))

          pd(indexy_mob,indexy_mob)=
     &    pd(indexy_mob,indexy_mob)    -exchc(i)/vmob
          pd(indexy_mob,indexy_other)=
     &    pd(indexy_mob,indexy_other)  +exchc(i)/vmob
          pd(indexy_other,indexy_mob)=
     &    pd(indexy_other,indexy_mob)  +exchc(i)/vother
          pd(indexy_other,indexy_other)=
     &    pd(indexy_other,indexy_other)-exchc(i)/vother

        elseif (phase(i).eq.2) then

c  ... biophase, exchange with porewater, no kd

          indexy_bio   = indexy(i)
          indexy_other = indexy(exspec(i))
          vbio   = volume(phase(i))
          vother = volume(phase(exspec(i)))

          pd(indexy_bio,indexy_bio)=
     &    pd(indexy_bio,indexy_bio)    -exchc(i)/vbio
          pd(indexy_bio,indexy_other)=
     &    pd(indexy_bio,indexy_other)  +exchc(i)/vbio
          pd(indexy_other,indexy_bio)=
     &    pd(indexy_other,indexy_bio)  +exchc(i)/vother
          pd(indexy_other,indexy_other)=
     &    pd(indexy_other,indexy_other)-exchc(i)/vother

        elseif (phase(i).eq.3) then

c  ... matrix, exchange with porewater, with kd

          indexy_mat   = indexy(i)
          indexy_other = indexy(exspec(i))
          vmat = volume(phase(i))
          vother   = volume(phase(exspec(i)))

          pd(indexy_mat,indexy_mat)=
     &         pd(indexy_mat,indexy_mat)        -exchc(i)/vmat
     $         /dblkd(i)
          pd(indexy_mat,indexy_other  )=
     &    pd(indexy_mat,indexy_other  )    +exchc(i)/vmat
          pd(indexy_other  ,indexy_mat)=
     &         pd(indexy_other  ,indexy_mat)    +exchc(i)/vother
     $         /dblkd(i)
          pd(indexy_other  ,indexy_other  )=
     &    pd(indexy_other  ,indexy_other  )-exchc(i)/vother
        elseif (phase(i).eq.4) then
c  ... NAPL, exchange with mob if available
          indexy_napl  = indexy(i)
          if (y(indexy_napl).gt.0.d0) then
            indexy_other = indexy(exspec(i))
            exchange=exchc(i)*(y(indexy_other)-csat(i))
c  ... no rebuilding of NAPL
            if (exchange.lt.-1.d-40) then
              vmat   = volume(phase(i))
              vother = volume(phase(exspec(i)))
              pd(indexy_napl,indexy_other)=
     &        pd(indexy_napl,indexy_other) +exchc(i)/vmat
              pd(indexy_other,indexy_other)=
     &        pd(indexy_other,indexy_other)-exchc(i)/vother
c     ... part. derivations for cnapl = 0
           else
              pd(indexy_napl,indexy_other)=
     &             pd(indexy_napl,indexy_other) + 1.d-20
              pd(indexy_other,indexy_other)=
     &             pd(indexy_other,indexy_other)- 1.d-20
            endif
          endif
        endif
        endif
 200  continue

cdgear
c -
cdgear

cNAG
c      do 1254 i=1,ngl
c         do 1255 j=1,ngl
c           pd(i,j)=-h*d*pd(i,j)
c1255     continue
c         pd(i,i)=1+pd(i,i)
c1254   continue
cNAG
      return
      end

c ************************************************************
c ** subroutine to compute growth of bacteria               **
c ************************************************************
      subroutine bacgrowth(yprimebac,sumx,i,jexclude,n,y)

      include 'tbc.prm'
      dimension y(n)
c
      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)

      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

c  ... compute growth of bacteria as input for partial derivates
c  ... growth of bacteria X caused by reaction i = yprimebac

      indexy_bac=indexy(bacterium(i))
      yprimebac=vmax(i)*y(indexy_bac)

      if (calckap.and.(vmax(i).gt.0.d0)) then
        yprimebac = yprimebac * dmaxkap/(sumx+dmaxkap)
      endif

c  ... loop over species

      do 110 j=1,nsp

c  ... monod-terms, exclude species j  (used for partial derivatives)

        if(j.ne.jexclude) then

          if (dmonod(i,j).gt.1.d-30) then
            indexy_specj = indexy(j)
            if (y(indexy_specj).ge. 1.d-40) then
              termmonod = y(indexy_specj)/(dmonod(i,j)+
     &                                     y(indexy_specj))
            else
              termmonod = y(indexy_specj)/dmonod(i,j)

            endif

            yprimebac=yprimebac*termmonod

          endif

c  ... dinhibition-terms

          if (dinhibit(i,j).gt.1.d-30) then
            indexy_specj=indexy(j)
            if (y(indexy_specj).ge. 1.d-30) then
              terminhi=dinhibit(i,j)/(dinhibit(i,j)+
     &                               y(indexy_specj))
            else
              terminhi=-y(indexy_specj)/dinhibit(i,j)+1
            endif

            yprimebac=yprimebac*terminhi

          endif

        endif
 110  continue

      return
      end


csd   ***********************************************************
csd   *** subroutine to read equilibrium chemistry parameters ***
csd   ***********************************************************

      subroutine readchem (nn,krestarc)

      include 'tbc.prm'

      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)

      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

      common /chemintern/ ckomp,akomp,rconst,tolf,tolx,
     &                    activity,gwtemp,tempareac,icharge,
     &                    maxits,activ
      double precision ckomp(maxckomp),akomp(maxckomp,maxcspec),
     &                 rconst(maxcequa),activity(maxcspec),
     &                 tolf,tolx,gwtemp
      integer*4 icharge(maxcspec),
     &          tempareac(maxcequa,maxcspec),
     &          maxits
     &          ipoint
      logical activ

      common /chemanz/ ncspec,nckomp,ncequa,nkspec
      integer*4        ncspec,nckomp,ncequa,nkspec

      common /chemextern/ rconst0,dh0,t0,chemc,compcomp,bspeccomp,
     &                    conversion,
     &                    areac,disspec,compchem,cname,kname
      double precision rconst0(maxcequa),dh0(maxcequa),t0(maxcequa),
     &                 chemc(maxnn*maxcspec),compcomp(maxckomp,maxsp),
     &                 bspeccomp(maxsp,maxcspec),conversion
cws
      common /contr3/ cic,ctemp,twc,twratioc,courtol,pectol,icc
      integer*4 icc(maxnnc)
      double precision cic(maxnnc*maxsp),ctemp(maxnnc)
cws
      common /outcontrol/ ioutspec
      integer*4 ioutspec(maxsp+maxcspec)

      integer*4 areac(maxcequa,maxcspec),disspec(maxcequa)
      character*20  cname(maxcspec),kname(maxckomp)
      logical compchem

      parameter(maxinvol=4)
      integer*4 ihelp(2*maxinvol)

      character*80 grtitle

c *****************************************************************************
c     *  Group 22: read chemical equilibrium parameters
c *****************************************************************************

      write(*,*) ' Reading GROUP 22'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 22'
         stop
      endif
      read(55,*) compchem

      if (compchem) then

      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif
10    format(a80)

      read(55,*) ncspec,nckomp,ncequa
      write(66,6000) ncspec,nckomp,ncequa
 6000 format(//,40('*'),/,
     &    '* Input data for chemistry *',/,40('*'),//,
     &    '  Number of chemical species      : ',i3,/,
     &    '  Number of chemical komponents   : ',i3,/,
     &    '  Number of equilibrium reactions : ',i3,/)
      if ((nckomp+ncequa).ne.ncspec) then
        write(66,*) ' Number of komponents + reactions ',
     &        'inconsistent with number of unknown species'
        write(66,*) ' There MUST be',ncspec-nckomp-ncequa,
     $       ' kinetic species defined' 
c        stop
      endif
      if (ncspec.gt.maxcspec-1) then
        write(*,*) ' Number of species is greater than maxcspec'
        stop
      endif
      if (nckomp.gt.maxckomp) then
        write(*,*) ' Number of komponents is greater than maxcspec'
        stop
      endif
      if (ncequa.gt.maxcequa) then
        write(*,*) ' Number of reactions is greater than maxcequa'
        stop
      endif



      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif
      read(55,*) (cname(i),i=1,ncspec)
      read(55,*) (ioutspec(i),i=nsp+1,ncspec+nsp)

      write(66,'(a)') ' *** Ionic charge ***'
      write(66,'(/,3x,99(1x,a12))') (cname(i),i=1,ncspec)

      read(55,*) (icharge(i),i=1,ncspec)
      write(66,'(3x,99(i6,7x))') (icharge(i),i=1,ncspec)

      if (krestarc.eq.0) then
         write(66,'(/,a)') ' *** Start values for chemical species ***'
         write(66,'(/,3x,99(1x,a12))') (cname(i),i=1,ncspec)

         read(55,*) (chemc((k-1)*nn+1), k=1,ncspec)
         write(66,'(99(2x,e11.3))') (chemc((k-1)*nn+1), k=1,ncspec)
cws   27.03.2002: special input procedure for the start values of minerals
cws               for Netwon-Raphson calculations. Now presence or absence of
cws               minerals can change from node to node
cws        
cws       minerals are assigned icharge -99
cws
cws       start values for minerals are used as pointers 
cws       for the nr. of the resp. transport species in group 16
cws
         do 5501 i=1,ncspec
         if (icharge(i).eq.-99) then
             ipoint=int(chemc((i-1)*nn+1))
             write(66,'(/,a,a12,a,i4)') ' *** Start values for ',
     & cname(i),'are taken from initial concentrations
     & of transport species nr',ipoint
         endif
 5501    continue
cws    standard procedure for all chemical species
         do 5632 i=2,nn
            do 5632 k=1,ncspec
               chemc((k-1)*nn+i)=chemc((k-1)*nn+1)
 5632    continue
cws     overwrite start values for minerals
        do 5502 i=1,ncspec
	  if (icharge(i).eq.-99) then
           do 5503 k=1,nn
              chemc((i-1)*nn+k)=cic((ipoint-1)*nn+k)
 5503      continue
cws   reset icharge for minerals for further computations
            icharge(i) = 0
        endif
 5502   continue
cws   27.03.2002: end of change of special procedure for minerals
cws   no special input needed for restarts:         
      else

         write(66,'(/,2a)') ' *** Reading start values for chemical ',
     $        'species from old data file ***'
c     read dummy
         read(55,*) (chemc((k-1)*nn+1), k=1,ncspec)
         
c     read *.cin-file
         do 5633 k=1,ncspec
            read(16) (chemc(j),j=(k-1)*nn+1,k*nn)
 5633    continue
         close(16)
         
      endif

      do 9756 i=1, nckomp
        do 5385 j=1, nsp
          compcomp(i,j)=0.d0
5385    continue
9756  continue

      do 5645 i=1, nsp
        do 3494 j=1, ncspec
          bspeccomp(i,j)=0.d0
3494    continue
5645  continue


      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif
      read(55,*) (kname(i),i=1,nckomp)


      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif
      write(66,'(/,2a)') ' *** Composition of components by ',
     &                  'biological species ***'
      write(66,'(/,1x,a12,3x,99(1x,a12))') 'Component   ',
     &                         (spname(i),i=1,nsp)

      do 5756 i=1, nckomp
        read(55,*) ianz
        do 3569 j=1,ianz
           read(55,*) isp, fact
           if ((isp.lt.1).or.(isp.gt.nsp)) then
              write(*,*) 'WARNING reading Composition of components by '
     $             ,'biological species: Bio species NR',isp
     $             ,'demanded !'
           endif
          compcomp(i,isp)=fact
3569    continue



        write(66,'(1x,a12,99(2x,e11.3))')
     &           kname(i),(compcomp(i,j),j=1,nsp)

5756  continue



      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif

      write(66,'(/,2a)') ' *** Composition of Bio-species by ',
     &                  'chemical species ***'
      write(66,'(/,1x,a12,3x,99(1x,a12))') 'Bio-species ',
     &                         (cname(i),i=1,ncspec)

      read(55,*) ianz
      do 4694 i=1,ianz

        read(55,*) nr
        if ((nr.lt.1).or.(nr.gt.nsp)) then
           write(*,*)
     $          'WARNING reading Composition of Bio-species by '
     $          ,'chemical species: Bio species NR',nr
     $          ,'demanded !'
        endif

        read(55,*) (bspeccomp(nr,j),j=1,ncspec)

        write(66,'(1x,a12,99(2x,e11.3))')
     &           spname(nr),(bspeccomp(nr,j),j=1,ncspec)


4694  continue


c     calculate link array between chemical species and komponents

      do 4570 ickomp=1, nckomp
         do 4570 icspec=1,ncspec
            akomp(ickomp,icspec)=0.d0
 4570 continue

      write(66,'(/,2a)') ' *** Composition of components by ', 
     $     'chemical species ***'  
      write(66,'(/,1x,a12,3x,99(1x,a12))') 'Component   ', 
     $     (cname(i),i=1,ncspec)  

      do 4566 ickomp=1, nckomp
         do 4567 icspec=1,ncspec
            do 4568 i=1,nsp
               akomp(ickomp,icspec)=akomp(ickomp,icspec)+compcomp(ickomp
     $              ,i)*bspeccomp(i,icspec)
 4568       continue
 4567    continue
         write(66,'(1x,a12,99(2x,e11.3))') 
     $        kname(ickomp),(akomp(ickomp,j),j=1,ncspec) 
 4566 continue
              

c     convert compcomp and bspeccomp, if species is not in mobile phase

      do 3458 i=1,nckomp 
         do 3457 j=1,nsp 
            if (dabs(compcomp(i,j)).gt.1.d-40) 
     &           compcomp(i,j)=compcomp(i,j)*volume(phase(j))/volume(1) 
 3457    continue 
 3458 continue 

      do 3499 i=1,nsp 
         do 3495 j=1,ncspec 
            if (dabs(bspeccomp(i,j)).gt.1.d-40) 
     $           bspeccomp(i,j)=bspeccomp(i,j)*volume(1)
     $           /volume(phase(i)) 
 3495    continue
 3499 continue


      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif
      write(66,'(/,a)') ' *** Reactions ***'
      write(66,'(/,24(1x,a12))') 'Nr.         ','React.const.',
     &          'dH0         ','T [C]       ',
     &          (cname(i),i=1,ncspec)

      do 220 i=1,ncequa
        disspec(i)=0
        do 230 j=1,ncspec
          areac(i,j)=0
230     continue
220   continue

      do 200 i=1, ncequa
        read(55,*) rconst0(i),dh0(i),t0(i),
     &             (ihelp(j),j=1,2*maxinvol)
        do 210 j=1,2*maxinvol,2
           if (ihelp(j).gt.0) then
              if (ihelp(j).gt.ncspec) then
                 write(*,*)
     $                'WARNING reading Reactions chemical species NR'
     $                ,ihelp(j),'demanded !'
              endif
            if (ihelp(j+1).ne.0) then
              areac(i,ihelp(j))=ihelp(j+1)
            else
              disspec(i)=ihelp(j)
            endif
          endif
210     continue
        write(66,'(i7,6x,3g12.4,20(5x,i3,5x))') i,rconst0(i),
     &             dh0(i),t0(i),(areac(i,j),j=1,ncspec)
c        rconst(i)=10**rconst(i)
         t0(i)=t0(i)+273.15d0
200   continue

      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif
      read(55,*) gwtemp
      write(66,8567) gwtemp
 8567 format(/,' Temperature of the aquifer for correction ',
     &     'of reaction constants  ', f10.2, ' C')
      if (gwtemp.gt.0.d0) gwtemp=gwtemp+273.15d0

      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading comment in group 22'
         stop
      endif
      read(55,*) maxits,tolf,tolx
      write(66,3459) maxits,tolf,tolx
3459  format(/,' NEWT-iterationparameters :',/,
     &   '  Maximum number of iterations             : ',i5,/,
     &   '  Convergence criterion on zeroed function : ',d12.4,/,
     &   '  Convergence criterion on species conc.   : ',d14.4)

      else
        write(66,6456)
 6456 format(//,40('*'),/,
     &    '* Input data for chemistry *',/,40('*'),//,
     &    '  No chemistry computed !',/)
      ncspec=0
      nckomp=0
      ncequa=0

      endif

      return
      end

csd   *****************************************************
c     *** subroutine to calculate equilibrium + kinetic chemistry ***
csd   *****************************************************

      subroutine chemistry (nn,cu)

      include 'tbc.prm'

      double precision cx(maxcspec),cu(maxnn*maxsp)
      double precision rconst(maxcequa),
     &                 solid(maxcequa)
      logical check,change,again,equaon(maxcequa)
      common /flags/ kfdm,klump,kgrid,kpmsh,kplane,kphead,kpvel,
     +               krestar,kwrith,kpmasb,
     +               inactnode,inactelem 
      logical inactnode(maxnn), inactelem(maxne)
      dimension cexch(maxnn*maxsp)
      common /contr3/ cic,ctemp,twc,twratioc,courtol,pectol,icc
      integer*4 icc(maxnnc)
      double precision cic(maxnnc*maxsp),ctemp(maxnnc)


      common /chemintern/ ckomp,akomp,temprconst,tolf,tolx,
     &                    activity,gwtemp,tempareac,icharge,
     &                    maxits,activ
      double precision ckomp(maxckomp),akomp(maxckomp,maxcspec),
     &                 temprconst(maxcequa),activity(maxcspec),
     &                 tolf,tolx,gwtemp
      integer*4 icharge(maxcspec),
     &          tempareac(maxcequa,maxcspec),
     &          maxits
      logical activ

      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)
      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

      common /chemextern/ rconst0,dh0,t0,chemc,compcomp,bspeccomp,
     &                    conversion,
     &                    areac,disspec,compchem,cname,kname
      double precision rconst0(maxcequa),dh0(maxcequa),t0(maxcequa),
     &                 chemc(maxnn*maxcspec),compcomp(maxckomp,maxsp),
     &                 bspeccomp(maxsp,maxcspec),conversion
      integer*4 areac(maxcequa,maxcspec),disspec(maxcequa)
      character*20  cname(maxcspec),kname(maxckomp)
      logical compchem

      common /kinetchem/ rckin0,rckin,stoech,cxalt,dt,reack,
     &                   kinetspec,kkomp,idepend
      double precision rckin0(maxkspec,maxkreac),
     &     rckin(maxkspec,maxkreac),
     &     stoech(maxkspec,maxckomp),cxalt(maxkspec),
     &     reack(maxkspec,maxcspec,maxkreac),dt
      integer kinetspec(maxkspec),
     &        kkomp(maxkspec),idepend(maxkspec)

      common /chemanz/ ncspec,nckomp,ncequa,nkspec
      integer*4        ncspec,nckomp,ncequa,nkspec

      common /logconstants/ dln10,dln1em60m1
      double precision dln10,dln1em60m1


      activ=.true.
      miterats=10

      dln10=dlog(10.d0)
      dln1em60m1=60.d0*dlog(10.d0)-1.d0


c     calculate reaction constants at given T (T const. in timestep)
c     store in rconst()

      if (gwtemp.gt.0.d0) then
        do 400 k=1,ncequa
          rc=rconst0(k)-dh0(k)/4.5821d0*(1.d0/gwtemp-1.d0/t0(k))
          rconst(k)=dln10*rc
400     continue
      else
        do 401 k=1,ncequa
          rconst(k)=dln10*rconst0(k)
401     continue
      endif

c     kinetic reactionconstants

      do 7834 j=1,nkspec
        do 7834 k=1,maxkreac
        rckin(j,k)=rckin0(j,k)
7834  continue



c     loop over all nodes

      do 9999 i=1,nn
cws    leave out inactive and first-type nodes:
cws         if (icc(i).eq.0) then
      if(.not.inactnode(i).and.icc(i).eq.0) then
c
c       start values for concentrations of species = c of last step
c
        do 200 k=1, ncspec
          cx(k)= chemc((k-1)*nn+i)
cthu           if (dabs(cx(k)).lt.1e-40) cx(k)=1e-40
200     continue
c
c       store startconcentration for kinetic chemistry
c
        do 4390 k=1, nkspec
          nadress=(kkomp(k) -1)*nn+i
          cxalt(k)=cu(nadress)*volume(phase(kkomp(k)))/
     &                         volume(1)
4390    continue

c
c       compose concentrations of komponents from bio-species
c
        do 100 k=1, nckomp
          ckomp(k)=0.d0
          do 110 l=1, nsp
            nadress=(l-1)*nn+i
            ckomp(k)=ckomp(k)+cu(nadress)*compcomp(k,l)
110       continue
100     continue
c
c copy unchangeable ln(rconst) and areac to changeable temprconst and tempareac
c temprconst and tempareac may be changed, if reactions are deactivated
c
        do 4509 k=1,ncequa
          temprconst(k)=rconst(k)
          do 5456 l=1,ncspec
            tempareac(k,l)=areac(k,l)
5456      continue
4509    continue

c
c        test if dissolution is possible or if precipitation
c        -> restore solution/prec. conditions of last timestep (cx=cxold)
c
        call calcactivity (ncspec,cx,dion)
        dionalt=dion
c
c       test for precipitation
c
        do 5466 k=1, ncequa
          if (disspec(k).le.1.d-40) then
c           reaction does not depend on mineral
            solid(k)=1.d0
          else

            if (cx(disspec(k)).gt.1.d-30) then
c             mineral present, normal equation system
              solid(k)=1.d0
            else
c             no mineral present, but perhaps precipitation
              solid(k)=cx(disspec(k))
              fh=0.d0
              do 210 l=1,ncspec
                if (areac(k,l).ne.0) then
                  if (cx(l).gt.1.d-60) then
                    dln=dlog(cx(l))
                  else
                    write(*,*) ' WARNING concentration of ',
     &                  cname(l),' = ',cx(l),
     &                  ' in chemistry NEWTcall 1'
                    dln=1.d60*cx(l)+dln1em60m1
                  endif
                  fh =fh+dble(areac(k,l))*(dln+activity(l))
                endif
210           continue

              if (fh.le.rconst(k)) then

c               no mineral available and dissolution,
c     disable dissolution reaction by using a dummy mass conservation equation

                equaon(k)=.false.

c               temprconst=ln(cx) , cx<0 -> linearisation
                temprconst(k)=1.d60*cx(disspec(k))+dln1em60m1
                do 5784 l=1,ncspec
                  tempareac(k,l)=0
5784            continue
                tempareac(k,disspec(k))=1
              else
c               no mineral available, but precipitation
                equaon(k)=.true.
              endif

            endif
          endif

5466    continue


        its=0

        do 1879 k=1, ncspec
          cx(k)= cx(k)*0.8d0
 1879   continue
        
c
c     temprconst and tempareac is set for current dissolution/precipitation
c     conditions, activitycoefficients (ln) are constant in Newton solver
c
c     equation solver numerical recipes, p 379
c
1111    continue


        call newt(cx,ncspec,check,maxits,
     &            tolf,tolx,iterations)

        if (iterations.ge.maxits) then
          write(90,*) ' No convergence in NEWT 1. after ',iterations,
     &                ' iterations -- NODE ',i
          write(*,*) ' No convergence in NEWT 1. after ',iterations,
     &                ' iterations -- NODE ',i
        endif
        if (check) then
          write(90,*) ' Convergence to a LOCAL minimum in NEWT',
     &                ', cell : ',i
          write(*,*)  ' Convergence to a LOCAL minimum in NEWT',
     &                ', cell : ',i
        endif
c
c      if activity is computed, check new ionic strength
c
        if (activ.and.(dIonalt.gt.0.d0)) then
           call calcactivity (ncspec,cx,dion)
           if(dabs(1.d0-dIon/dIonalt).gt.1.d-3) then
              its=its+1
              if (its.lt.miterats) then
c
c      new ionstrength differs from old value, recompute equilibrium with
c      new ionic str. and new (constant) activities
c
                 dionalt=dion
                 goto 1111
              else
                 write(*,*) ' No convergence in activity loop 1',
     &                ' Activity old =',dionalt,
     &                ' new =',dion
              endif
           endif
        endif

c        write(*,*) its,' iterations for ionic strength (1)'

c     concentrations of chem. species (cx) now with influence of last
c     transport & bio- step, test again for dissolution/precipitation
c     and check, if equation system changes

        again=.false.

c       test for precipitation with new concentrations

        do 5467 k=1, ncequa

          if (solid(k).le.0.d0) then
c           mineral was not present in last timestep

            if (equaon(k)) then
c             no mineral available, but precipitation was set in last timestep
c             test, if precipitation has really occurt

              if (solid(k).gt.cx(disspec(k))) then
c               mineral has dissolved ! (do it again Sam)
c               switch off reaction

                again=.true.
c               temprconst=ln(cx) , cx<0 -> linearisation
                temprconst(k)=1.d60*solid(k)+dln1em60m1
                do 5785 l=1,ncspec
                  tempareac(k,l)=0
5785            continue
                tempareac(k,disspec(k))=1

                write(*,*) '      Switching off reaction ',k,
     $               ' in node ', i

              endif

            else

c             no mineral available and solution was set in last timestep
c             test, if precipitation with new conc.
              fh=0.d0
              do 211 l=1,ncspec
                if (areac(k,l).ne.0) then
                  if (cx(l).gt.1.d-60) then
                    dln=dlog(cx(l))
                  else
                    write(*,*) ' WARNING concentration of ',
     &                  cname(l),' = ',cx(l),
     &                  ' in chemistry NEWTcall 2'
                    dln=1.d60*cx(l)+dln1em60m1
                  endif
                  fh = fh +dble(areac(k,l))*(activity(l)+dln)
                endif
211           continue

              if (fh.gt.rconst(k)) then
c               mineral precipitates ! (do it again)
c               switch on reaction

                again=.true.
                temprconst(k)=rconst(k)
                do 5786 l=1,ncspec
                  tempareac(k,l)=areac(k,l)
5786            continue

                write(*,*) '      Switching on reaction ',k, ' in node '
     $               , i

              endif

            endif
          endif

5467    continue


c     equation solver numerical recipes, p 379

        if (again) then
          write(*,*) '      Recalculating Equilibrium'
          its=0
1112      continue

          call newt(cx,ncspec,check,maxits,
     &              tolf,tolx,iterations)

          if (iterations.ge.maxits) then
            write(90,*) ' No convergence in NEWT 2. after ',iterations,
     &                  ' iterations -- NODE ',i
            write(*,*) ' No convergence in NEWT 2. after ',iterations,
     &                 ' iterations -- NODE ',i
          endif
          if (check) then
            write(90,*) ' Convergence to a LOCAL minimum in NEWT',
     &                  ', cell : ',i
            write(*,*)  ' Convergence to a LOCAL minimum in NEWT',
     &                  ', cell : ',i
          endif

          if (activ.and.(dionalt.gt.0.d0)) then
             call calcactivity (ncspec,cx,dion)
             if(dabs(1.d0-dion/dionalt).gt.1.d-2) then
                its=its+1
                if (its.lt.miterats) then
                   dionalt=dion
                   goto 1112
                else
                   write(*,*) ' No convergence in activity loop 2',
     &                  ' Activity old =',dionalt,
     &                  ' new =',dion
                endif
             endif
          endif
c        write(*,*) its,' iterations for ionic strength (2)'

       endif

c      save computed concentrations of cell as start value for next timestep

        do 300 k=1,ncspec
          chemc((k-1)*nn+i)=cx(k)
300     continue

c      recompose bio-species from computed concentrations (back-coupling)

        do 500 k=1, nsp
          change=.false.
          ctemp2=0.d0
          do 550 l=1, ncspec
            if (dabs(bspeccomp(k,l)).gt.1.d-60) then
              change=.true.
              ctemp2=ctemp2+bspeccomp(k,l)*cx(l)
            endif
550       continue
          if (change) then
            nadress=(k-1)*nn+i
            cu(nadress)=ctemp2
          endif
500     continue

        chemc(ncspec*nn+i)=dion
cws     endif form inactive and first-type nodes
        endif

9999  continue

      return
      end





csd   **************************************************
csd   *  Subroutine to calculate activity coefficients *
csd   **************************************************

      subroutine calcactivity (ncspec,cx,dion)

      include 'tbc.prm'

      common /chemintern/ ckomp,akomp,temprconst,tolf,tolx,
     &                    activity,gwtemp,tempareac,icharge,
     &                    maxits,activ
      double precision ckomp(maxckomp),akomp(maxckomp,maxcspec),
     &                 temprconst(maxcequa),activity(maxcspec),
     &                 tolf,tolx,gwtemp
      integer*4 icharge(maxcspec),
     &          tempareac(maxcequa,maxcspec),
     &          maxits
      logical activ

      common /logconstants/ dln10,dln1em60m1
      double precision dln10,dln1em60m1

      double precision cx(maxcspec)

c
c        activity of species after Davies (-> Stumm & Morgan p.135)
c
c        WARNING minerals c<0 MUST have charge=0
c     

c     wlc    missing parameter values corrected at 12/12/97
      dln10=dlog(10.d0)
      dln1em60m1=60.d0*dlog(10.d0)-1.d0

      if (activ) then
         dIon=0.d0
         do 9487 j=1,ncspec
            dIon=dIon+dble(icharge(j)*icharge(j))*dabs(cx(j))
 9487    continue
         if (dIon.gt.0.d0) then
            dIon=dIon/2.d0
c     
            rootion=dsqrt(dIon)
            fact=-0.5115d0*(rootion/(1.d0+rootion)-.2d0*dIon)
            do 4566 j=1,ncspec
c     activity is ln(activity)  ln(10**(icharge**2*fact))
               activity(j)=dln10*dble(icharge(j)*icharge(j))*fact
 4566       continue
         else
c     no ions
            dIon=-1.d0
            do 7567 j=1, ncspec
               activity(j)=0.d0
 7567       continue
         endif      
      else
c     no calculation of activity
         do 7566 j=1, ncspec
            activity(j)=0.d0
 7566    continue
      endif
      
      return
      end
      

c *************************************************************
c ** subroutine to compute kinetical change of concentration **
c *************************************************************

      subroutine dCkin(yprimekin,i,k,n,cx,activity)

      include 'tbc.prm'
      dimension cx(n),activity(maxcspec)

      common /kinetchem/ rckin0,rckin,stoech,cxalt,dt,reack,
     &                   kinetspec,kkomp,idepend
      double precision rckin0(maxkspec,maxkreac),
     &     rckin(maxkspec,maxkreac),
     &     reack(maxkspec,maxcspec,maxkreac),dt,
     &                 stoech(maxkspec,maxckomp),cxalt(maxkspec)
      integer kinetspec(maxkspec),
     &        kkomp(maxkspec),idepend(maxkspec)

      yprimekin=rckin(i,k)

      do 310 j=1,n
        if (dabs(reack(i,j,k)).gt.1.d-60) then

c activity() is ln (activity) (->SUB calcactivity)

          yprimekin=yprimekin*
     &          ( (dexp(activity(j))*cx(j))**reack(i,j,k) )
        endif
 310  continue

      return
      end




csd   ****************************************************
csd   *** subroutine for newt, compute funktion values ***
csd   ****************************************************

      subroutine funcv(n,cx,f)

      include 'tbc.prm'

      integer*4 n
      double precision fh,cx(n), f(n), yprimekin(maxkreac)
      logical normal

      common /chemintern/ ckomp,akomp,temprconst,tolf,tolx,
     &                    activity,gwtemp,tempareac,icharge,
     &                    maxits,activ
      double precision ckomp(maxckomp),akomp(maxckomp,maxcspec),
     &                 temprconst(maxcequa),activity(maxcspec),
     &                 tolf,tolx,gwtemp
      integer*4 icharge(maxcspec),
     &          tempareac(maxcequa,maxcspec),
     &          maxits
      logical activ

      common /kinetchem/ rckin0,rckin,stoech,cxalt,dt,reack,
     &                   kinetspec,kkomp,idepend
      double precision rckin0(maxkspec,maxkreac),
     &                  rckin(maxkspec,maxkreac),dt,
     &     stoech(maxkspec,maxckomp),cxalt(maxkspec),
     &     reack(maxkspec,maxcspec,maxkreac)
      integer kinetspec(maxkspec),
     &        kkomp(maxkspec),idepend(maxkspec)

      common /chemanz/ ncspec,nckomp,ncequa,nkspec
      integer*4        ncspec,nckomp,ncequa,nkspec

      common /logconstants/ dln10,dln1em60m1
      double precision dln10,dln1em60m1

c
c     calculate present function values F(X)==0
c
c     komponent - equations
c
      do 100 k=1, nckomp
        fh= -ckomp(k)
        do 110 i=1,n
          fh = fh + akomp(k,i)*cx(i)
110     continue
        f(k)=fh
100   continue


c
c     chemical equilibrium reactions
c
      j=nckomp
      do 200 k=1, ncequa
        j=j+1
        fh=-temprconst(k)
        do 210 i=1,n
          if (tempareac(k,i).ne.0) then
            if (cx(i).gt.1.d-60) then
              dln=dlog(cx(i))
            else
              dln=1.d60*cx(i)+dln1em60m1
            endif
            fh = fh + dble(tempareac(k,i))*(dln+activity(i))
          endif
210     continue
        f(j)= fh
200   continue


c
c ... loop over reactions dC/dt=   (kinetic chem)
c
      j=nckomp+ncequa

      if (dt.gt.1.d-40) then

        do 300 i=1,nkspec
 
          index=kinetspec(i)
          j=j+1

          fh=0.d0
          do 333 k=1,maxkreac
            call dCkin(yprimekin(k),i,k,n,cx,activity)
            fh=fh+yprimekin(k)
 333      continue

          normal=.true.
          if (idepend(i).gt.0) then
c look, if cx(idepend) is available
            if (cx(idepend(i)).lt.1.d-30) then
c cx not available, test for solution
              if (fh.le.0.d0) then
c solution and cx not available
c disable equation
                normal=.false.
                f(j)=cx(index)-cxalt(i)               
              endif
            endif
          endif

c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Boehringer Anfang !!!!!!!!!!!!!!!!!!!!!
c
c          if (idepend(i).eq.12.and.cx(1).lt.1e-15) then
c             normal=.false.
c             f(j)=cx(index)-cxalt(i)
c          endif             
c
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Boehringer Ende !!!!!!!!!!!!!!!!!!!!!!    



          if (normal) then
c normal equation system
            f(j)= (cx(index)-cxalt(i))/dt - fh
              do 320 l=1,nckomp
                if (dabs(stoech(i,l)).gt.1.0d-60) then
                  f(l)= f(l)-stoech(i,l) * dt * fh
                endif
 320          continue
          endif

 300    continue

      else

c first call of chemistry, calculate equilibrium, no kinetic chemistry
c use a dummy mass conservation equation for kinetic chem

        do 301 i=1,nkspec

          index=kinetspec(i)
          j=j+1

          f(j)=cx(index)-cxalt(i)

 301    continue

      endif

      return
      end


csd   **************************************************
csd   *** subroutine for newt, compute jacobi-matrix ***
csd   **************************************************

      subroutine fdjac(n,cx,fvec,np,df)

      include 'tbc.prm'

      integer*4 n,np
      double precision df(np,np),fvec(n),cx(n),yprimekin(maxkreac)
      logical normal

      common /chemintern/ ckomp,akomp,temprconst,tolf,tolx,
     &                    activity,gwtemp,tempareac,icharge,
     &                    maxits,activ
      double precision ckomp(maxckomp),akomp(maxckomp,maxcspec),
     &                 temprconst(maxcequa),activity(maxcspec),
     &                 tolf,tolx,gwtemp
      integer*4 icharge(maxcspec),
     &          tempareac(maxcequa,maxcspec),
     &          maxits
      logical activ

      common /kinetchem/ rckin0,rckin,stoech,cxalt,dt,reack,
     &                   kinetspec,kkomp,idepend
      double precision rckin0(maxkspec,maxkreac),
     &                  rckin(maxkspec,maxkreac),dt,
     &     stoech(maxkspec,maxckomp),cxalt(maxkspec),
     &     reack(maxkspec,maxcspec,maxkreac)
      integer kinetspec(maxkspec),
     &        kkomp(maxkspec),idepend(maxkspec)

      common /chemanz/ ncspec,nckomp,ncequa,nkspec
      integer*4        ncspec,nckomp,ncequa,nkspec


c     derzeitige partiellen Ableitungen dF(X)/dxi berechnen
      
      do 99 i=1,n
        do 99 j=1,n
 99   df(i,j)=0.d0

c     komponenten - gleichungen
      do 100 i=1, nckomp
        do 110 j=1, n
c         ableitung komponentengleichung i nach species j
          df(i,j)= akomp(i,j)
110     continue
100   continue

c     chemische gleichgewichts-gleichungen

      j=nckomp
      do 200 k=1, ncequa

        j=j+1
        do 220 i=1,n
          if (tempareac(k,i).ne.0) then
c           ableitung gleichgewichtsgleichung j nach species i
            if (cx(i).gt.1.d-60) then
              df(j,i) = dble(tempareac(k,i))/cx(i)
            else
              df(j,i) = dble(tempareac(k,i))*1.d60
            endif
          endif
220     continue

200   continue

c
c ... loop over reactions dC/dt=   (kinetic chem)
c
      j=nckomp+ncequa

      if (dt.gt.1.d-40) then

        do 300 i=1,nkspec
 
          j=j+1
          index=kinetspec(i)

          fh=0.d0
          do 333 k=1,maxkreac
            call dCkin(yprimekin(k),i,k,n,cx,activity)
            fh=fh+yprimekin(k)
 333      continue

          normal=.true.
          if (idepend(i).gt.0) then
c look, if cx(idepend) is available
            if (cx(idepend(i)).lt.1.d-15) then
c cx not available, test for solution
              if (fh.le.0.d0) then
c solution and cx not available
c disable equation
                normal=.false.
                df(j,index)=1.d0
              endif
            endif
          endif

c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Boehringer Anfang !!!!!!!!!!!!!!!!!!!!!
c
c          if (idepend(i).eq.12.and.cx(1).lt.1e-15) then
c             normal=.false.
c             df(j,index)=1.d0
c          endif             
c
c     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Boehringer Ende !!!!!!!!!!!!!!!!!!!!!!    


          if (normal) then
c normal equation system
            do 330 k=1,maxkreac
              do 310 l=1,n
                 if ((dabs(reack(i,l,k)).gt.1.d-60).and.(dabs(cx(i)).gt
     $                .1.d-60))then 
                  dfh=yprimekin(k)*reack(i,l,k)/cx(l)
                  df(j,l)= df(j,l)-dfh
c if dC_j/dC_l exists, there are terms in komponents
                  do 320 m=1,nckomp
                    if (dabs(stoech(i,m)).gt.1.0d-60) then
                      ablei=stoech(i,m) * dt * dfh
                      df(m,l)= df(m,l) - ablei
                    endif
 320              continue
                endif
 310          continue
 330        continue

            df(j,index)= df(j,index) + 1.d0/dt

          endif

 300    continue


      else

        do 301 i=1,nkspec
          j=j+1
          index=kinetspec(i)
          df(j,index)=1.d0
 301    continue

      endif

      return
      end


c
c     *****************************************************************
c     *  subroutine comp_index calculates array index() with the      *
c     *        coupling-table between global c() and dgear y()        *
c     *****************************************************************
c
      subroutine comp_index
c
      include 'tbc.prm'
c
      common /bioreac/ dmonod,yield,dinhibit,vmax,exchc,volume,
     &                 cexch_dt,dblkd,csat,csatmax,dmaxkap,cmolfac,
     &                 bacterium,indexy,phase,exspec,
     &                 ngl,nsp,nreac,growth,bactspec,calckap,
     &                 napl_interaction,spname
      double precision dmonod(maxreac,maxsp),yield(maxreac,maxsp),
     &                 dinhibit(maxreac,maxsp),vmax(maxreac),
     &                 exchc(maxsp),volume(4),cexch_dt(maxsp),
     &     dblkd(maxsp),csat(maxsp),csatmax(maxsp),
     &     dmaxkap,cmolfac(maxsp)

      integer bacterium(maxreac),indexy(maxsp),phase(maxsp),
     &        exspec(maxsp),ngl,nsp,nreac
      logical growth(maxreac),bactspec(maxsp),calckap,napl_interaction
      character*20 spname(maxsp)

c

      j=0
      do 100 i=1,nsp

cdsds  hier auch schnellen austausch etc beruecksichtigen

        if (phase(i).gt.0) then
c reactive equation in dgear
          j=j+1
          indexy(i)=j
        else
          indexy(i)=-1
        endif
 100  continue
      ngl=j
      return
      end















































