*     LU-decomposition of Matrix, according to Numerical Recipes
**************************************
      SUBROUTINE ludcmp(a,n,NP,indx,d)
**************************************

      implicit double precision (a-h,o-z)
      implicit integer*4 (i-n)

      INTEGER*4 n,np,indx(n),NMAX
      double precision d,a(np,np),TINY
      PARAMETER (NMAX=100,TINY=1.0d-80)       ! NMAX >= n
      INTEGER*4 I,IMAX,J,K
      double precision aamax,dum,sum,vv(NMAX)

      D=1.d0
      DO 12 I=1,N
        AAMAX=0.d0
        DO 11 J=1,N
          AAMAX=dmax1(AAMAX,dABS(A(I,J)) )
11      CONTINUE
        IF (AAMAX.EQ.0.d0) then
          write(*,*) 'Singular matrix in ludcmp.'
          write(*,*) 'Row ',i
          stop
        endif
        VV(I)=1.d0/AAMAX
12    CONTINUE
      DO 19 J=1,N
            DO 14 I=1,J-1
            SUM=A(I,J)
                DO 13 K=1,I-1
                    SUM=SUM-A(I,K)*A(K,J)
13              CONTINUE
                A(I,J)=SUM
14           CONTINUE
             AAMAX=0.d0
        DO 16 I=J,N
          SUM=A(I,J)
              DO 15 K=1,J-1
               SUM=SUM-A(I,K)*A(K,J)
15            CONTINUE
            A(I,J)=SUM
            DUM=VV(I)*dABS(SUM)
          IF (DUM.GE.AAMAX) THEN
            IMAX=I
            AAMAX=DUM
          ENDIF
16      CONTINUE
        IF (J.NE.IMAX)THEN
          DO 17 K=1,N
            DUM=A(IMAX,K)
            A(IMAX,K)=A(J,K)
            A(J,K)=DUM
17        CONTINUE
          D=-D
          VV(IMAX)=VV(J)
        ENDIF
        INDX(J)=IMAX
        IF(A(J,J).EQ.0.d0) A(J,J)=TINY
        IF(J.NE.N)THEN
          DUM=1.d0/A(J,J)
          DO 18 I=J+1,N
            A(I,J)=A(I,J)*DUM
18        CONTINUE
        ENDIF
19    CONTINUE

      RETURN
      END

**************************************
      SUBROUTINE lubksb(a,n,NP,indx,b)
**************************************

      implicit double precision (a-h,o-z)
      implicit integer*4 (i-n)

      INTEGER*4 n,np,indx(n)
      double precision a(np,np),b(n)
      INTEGER*4 I,II,J,LL
      double precision sum

      II=0
      DO 12 I=1,N
        LL=INDX(I)
        SUM=B(LL)
        B(LL)=B(I)
        IF (II.NE.0)THEN
          DO 11 J=II,I-1
            SUM=SUM-A(I,J)*B(J)
11        CONTINUE
        ELSE IF (SUM.NE.0.d0) THEN
          II=I
        ENDIF
        B(I)=SUM
12    CONTINUE

      DO 14 I=N,1,-1
        SUM=B(I)
            DO 13 J=I+1,N
            SUM=SUM-A(I,J)*B(J)
13        CONTINUE
          B(I)=SUM/A(I,I)
14    CONTINUE

      RETURN
      END

**********************
      FUNCTION fmin(x)
**********************

      implicit double precision (a-h,o-z)
      implicit integer*4 (i-n)

      INTEGER*4 n,NP
      double precision fmin,x(2),fvec
      PARAMETER (NP=40)
      COMMON /newtv/ fvec(NP),n
      SAVE /newtv/
      INTEGER*4 i
      double precision sum

      CALL funcv(n,x,fvec)

      sum=0.d0
      DO 11 i=1,n
          sum=sum+fvec(i)*fvec(i)
11    CONTINUE
      fmin=0.5d0*sum

      RETURN
      END


*     line-search subroutine according to Numerical Recipes, chapter 9
**************************************************************
      SUBROUTINE lnsrch(n,xold,fold,g,p,x,f,stpmax,check,tolx,
     &                  func)
**************************************************************

      implicit double precision (a-h,o-z)
      implicit integer*4 (i-n)

      INTEGER*4 n
      LOGICAL check
      double precision f,fold,stpmax,g(n),p(n),x(n),xold(n),
     &                 func,ALF,TOLX
      PARAMETER (ALF=1.d-4)
      EXTERNAL func
      INTEGER*4 i
      double precision a,alam,alam2,alamin,b,disc,f2,fold2,
     &                 rhs1,rhs2,slope,sum,temp,test,tmplam

      check=.false.
      sum=0.d0
      DO 11 i=1,n
          IF(dABS(p(i)).GT.1.d100)
     &      write(*,*) 'WARNING NEWT : overflow p(i) in lnsrch'
          sum=sum+p(i)*p(i)
11    CONTINUE
      sum=dSQRT(sum)

      IF(sum.GT.stpmax)THEN
        DO 12 i=1,n
          p(i)=p(i)*stpmax/sum
12      CONTINUE
      ENDIF

      slope=0.d0
      DO 13 i=1,n
          slope=slope+g(i)*p(i)
13    CONTINUE

      test=0.d0
      DO 14 i=1,n
        temp=dabs(p(i))/dmax1(dabs(xold(i)),1.d0)
        test=dmax1(test,temp)
14    CONTINUE
      alamin=TOLX/test
      alam=1.d0
1     CONTINUE
          DO 15 i=1,n
              x(i)=xold(i)+alam*p(i)
15        CONTINUE
          f=func(x)
          IF(alam.LT.alamin)THEN
              DO 16 i=1,n
                  x(i)=xold(i)
16            CONTINUE
              check=.true.
              RETURN
          ELSEIF(f.LE.fold+ALF*alam*slope)THEN
              RETURN
          ELSE
              IF(alam.EQ.1.d0)THEN
                  tmplam=-slope/(2.d0*(f-fold-slope))
              ELSE
                  rhs1=f-fold-alam*slope
                  rhs2=f2-fold2-alam2*slope
                  a=(rhs1/(alam*alam)-rhs2/(alam2*alam2))/
     &              (alam-alam2)
                  b=(-alam2*rhs1/(alam*alam)+alam*rhs2/
     &              (alam2*alam2))/(alam-alam2)
                  IF(dabs(a).lt.1.d-80)then 
                      tmplam=-slope/(2.d0*b)
                  ELSE
                    disc=b*b-3.d0*a*slope
                    IF(disc.LT.0.d0)
     &  write(*,*) ' WARNING NEWT: roundoff problem lnsrch',disc
c                    disc=dmax1(disc,0.d0)
                    tmplam=(-b+dSQRT(disc))/(3.d0*a)
                  ENDIF
                  IF(tmplam.GT..5d0*alam)tmplam=.5d0*alam
              ENDIF
          ENDIF
          alam2=alam
          f2=f
          fold2=fold
          alam=max(tmplam,.1d0*alam)
      GOTO 1
      END


*     newton-raphson subroutine according to Numerical Recipes, chapter 9
********************************
      SUBROUTINE newt(x,n,check,maxits,tolf,tolx,iterations)
********************************

      implicit double precision (a-h,o-z)
      implicit integer*4 (i-n)

      INTEGER*4 n,nn,NP,MAXITS
      LOGICAL check
      double precision x(n),fvec,TOLF,TOLMIN,TOLX,STPMX
      PARAMETER (NP=40,STPMX=1.d0)
      COMMON /newtv/fvec(NP),nn
      SAVE /newtv/
      INTEGER*4 i,its,j,indx(NP)
      double precision d,den,f,fold,stpmax,sum,temp,test,fjac(NP,NP),
     &     g(NP),p(NP),xold(NP),fmin

      EXTERNAL fmin

      tolmin= 1.d-2*tolf

      nn=n
      f=fmin(x)
      test=0.d0
      DO 11 i=1,n
          test=dmax1(test,dabs(fvec(i)))
11    CONTINUE
      IF(test.LT.0.01d0*TOLF)RETURN
      sum=0.d0
      DO 12 i=1,n
          sum=sum+x(i)*x(i)
12    CONTINUE
      stpmax=STPMX*dmax1(dSQRT(sum),dble(n))

      DO 21 its=1,MAXITS
          iterations=its
          CALL fdjac(n,x,fvec,np,fjac)
          DO 14 i=1,n
              sum=0.d0
              DO 13 j=1,n
                  sum=sum+fjac(j,i)*fvec(j)
13            CONTINUE
              g(i)=sum
14        CONTINUE
          DO 15 i=1,n
              xold(i)=x(i)
15        CONTINUE
          fold=f
          DO 16 i=1,n
              p(i)=-fvec(i)
              IF(dABS(p(i)).GT.1.d100) 
     &             write(*,*) ' WARNING NEWT: hello overflow'
16        CONTINUE
          CALL ludcmp(fjac,n,NP,indx,d)
          CALL lubksb(fjac,n,NP,indx,p)
          CALL lnsrch(n,xold,fold,g,p,x,f,stpmax,check,tolx,fmin)
          test=0.d0
          DO 17 i=1,n
            test=dmax1(test,dabs(fvec(i)))
17        CONTINUE
          IF(test.LT.TOLF)THEN
            check=.false.
            RETURN
          ENDIF
          IF(check)THEN
              test=0.d0
              den=dmax1(f,.5d0*n)
              DO 18 i=1,n
                  temp=dabs(g(i))*dmax1(dabs(x(i)),1.d0)/den
                  test=dmax1(test,temp)
18            CONTINUE
              IF(test.LT.TOLMIN)THEN
                  check=.true.
              ELSE
                  check=.false.
              ENDIF
              RETURN
          ENDIF
          test=0.d0
          DO 19 i=1,n
              temp=(dabs(x(i)-xold(i)))/dmax1(dabs(x(i)),1.d0)
              test=dmax1(test,temp)
19        CONTINUE
          IF (test.LT.TOLX) RETURN
21    CONTINUE
      PRINT*, ' MAXITS exceeded in newt'
      END


