c
c*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
c
      subroutine symfac(ihead,nzlist,link,iused)
c
c     this subroutine performs a symbolic factorisation of the matrix
c     the factorization is only carried to the second level
c     (i.e. only fill-ins coming from original entries of the matrix
c      are considered, all higher order fill-ins are ignored).
c     this subroutine is valid for 5-pt and 7-pt templates,
c     modifications need t be made for other templates 
c 
      include 'tbc.prm'
      include 'tbc.dim'

      integer nzlist(maxnja2), link (maxnja2+1), ihead(maxnn)
c
      do 30 i=1,nn
        idiag1=iadpiv(i)+1
        iend = ia(i+1) - 1
        do 20 j=idiag1,iend
          jnode=ja(j)
          do 10 k=j,iend
            knode=ja(k)
c
c assign the jnode-knode connection
c
            inext = ihead(jnode)
 1001       continue
c
c
            if(inext.eq.0)then
c
c ...this node not in list, add to list
c
              iused = iused+1
c
              if(iused.gt.maxnja)then
                write(*,*)' Dim maxnja exceeded : ', maxnja
                write(66,*)' Dim maxnja exceeded : ', maxnja
                stop
              endif
              if(ihead(jnode).eq.0)then
c
c ...no other elements in list, initiate list
c
                ihead(jnode) = iused
              else
c
c ...change old link pointer
c
                link(iold) = iused
              endif
c
              nzlist(iused) = knode
              link(iused) = 0
              go to 407
            elseif(knode.eq.nzlist(inext))then
c
c ...this neighbour already in list, break out of linked list search
c  
              go to 407
            else
c
c ...continue link search
c
              iold = inext
              inext = link(iold)
              go to 1001
            endif
  407       continue

   10     continue
   20   continue
   30 continue
c
      return
      end 
c
c  ...solver for tbc
c     uses ia, ja pointers
c

c***************************************************************************

      subroutine find(i,j,k)

c***************************************************************************
      include 'tbc.prm'
      include 'tbc.dim'
c----------------------------------------------------------------------
c     for node i, determine the "band" related to its adjacency to
c         node j.  if not adjacent, return 0 as the "band"
c----------------------------------------------------------------------
      k=0
      istart=ia(i)
      iend=ia(i+1)-1
      do 10 l=istart,iend
        nnode=ja(l)
c----------------------------------------------------------------------
c       exit the loop if at or past the required position
c----------------------------------------------------------------------
        if(nnode.ge.j)then
          if(nnode.eq.j) then
            k=l
            return
          endif
        endif
 10     continue
      return
      end
 
c***************************************************************************
 
      subroutine setup_iaja

c***************************************************************************
c
c    input:  
c             ndb   integer: dim of b(), ia() arrays
c             ndja  integer: dim of ja(), a() arrays
c
c   output:
c             ia()    integer:
c             ja()    integer
c
c     local variables:
c
c      ihead()               head ptr to linked list of column
c                            indicies
c      link()                link ptr for linked list
c      maxnja                max size of nonzeros in a()
c      maxnja2               max size of nonzeros in cb()
c      maxnn                 max number of nodes
c      nzlist()              list of column indices, pted
c                               to by link ptr, ihead()
c
      include 'tbc.prm'
      include 'tbc.dim'
c
      integer nzlist( maxnja2 ), link (maxnja2+1), ihead(maxnn)
      integer vector_to_sort(maxnb)
      dimension icon(8,4),icontp(6,4)
      data icon/2,1,2,1,1,2,3,4, 4,3,4,3,6,5,6,5, 5,6,7,8,8,7,8,7,
     +          1,2,3,4,5,6,7,8/
      data icontp/2,1,1,1,2,3, 3,3,2,5,4,4, 4,5,6,6,6,5, 1,2,3,4,5,6/
c
      do 401 i = 1,nn
        ihead(i) = 0
  401 continue
c
      if(kfdm.eq.0.or.klump.eq.0) then
        iused = 0
        do 422 iel = 1, ne
          do 403 inum = 1,nln
            id = in(inum,iel)
            do 407 ii = 1,nln
c
              idd = in(ii,iel)
c
              inext = ihead(id)
 1001         continue
c
              if(inext.eq.0)then
c
c ...this node not in list, add to list
c
                iused = iused+1
c
                if(iused.gt. maxnja)then
                  write(66,*)'Dim maxnja exceeded : ', maxnja
                  write(*,*)'Dim maxnja exceeded : ', maxnja
                  stop
                endif
                if(ihead(id).eq.0)then
c
c ...no other elements in list, initiate list
c
                  ihead(id) = iused
                else
c
c ...change old link pointer
c
                  link(iold) = iused
                endif
c
                nzlist(iused) = idd
                link(iused) = 0
                go to 407
              elseif(idd.eq.nzlist(inext))then
c
c ...this neighbour already in list, break out of linked list search
c  
                go to 407
              else
c
c ...continue link search
c
                iold = inext
                inext = link(iold)
                go to 1001
              endif
  407       continue
  403     continue
  422   continue

      elseif(kfdm.eq.1.or.klump.eq.1) then
        iused = 0
        do 522 iel = 1, ne
          do 503 inum = 1,nln
            id = in(inum,iel)
            do 507 ii = 1,4
              if(nln.eq.8) then
                jpos=icon(inum,ii)
              else
                jpos=icontp(inum,ii)
              end if
              idd = in(jpos,iel)
              inext = ihead(id)
 2001         continue
c
              if(inext.eq.0)then
c
c ...this node not in list, add to list
c
                iused = iused+1
c
                if(iused.gt. maxnja)then
                  write(*,*)'Dim maxnja exceeded : ', maxnja
                  write(66,*)'Dim maxnja exceeded : ', maxnja
                  stop
                endif
                if(ihead(id).eq.0)then
c
c ...no other elements in list, initiate list
c
                  ihead(id) = iused
                else
c
c ...change old link pointer
c
                  link(iold) = iused
                endif
c
                nzlist(iused) = idd
                link(iused) = 0
                go to 507
              elseif(idd.eq.nzlist(inext))then
c
c ...this neighbour already in list, break out of linked list search
c  
                go to 507
              else
c
c ...continue link search
c
                iold = inext
                inext = link(iold)
                go to 2001
              endif
  507       continue
  503     continue
  522   continue
      end if
c
c
      if( iused .gt. maxnja)then
         write(66,*)' Dim maxnja exceded: need ',iused
         write(*,*)' Dim maxnja exceded: need ',iused
         stop
      endif
c
c ...get ia, ja arrays from linked list
c
      ia(1) = 1
c
      icount = 0
      do 421 i = 1,nn
c
        inext = ihead(i)
  542   continue
        if(inext.ne.0) then
          icount = icount + 1
          ja( icount )  =  nzlist(inext)
          inext  =  link(inext)
          go to 542
        endif
        ia( i+1 ) = icount + 1
  421 continue
c
      if( ia(nn+1)-1 .gt. maxnja )then
         write(*,*)' Dim maxnja exceeded ','need: ', ia(nn+1)-1 
         write(66,*)' Dim maxnja exceeded ','need: ', ia(nn+1)-1 
         stop
      endif
c
c  ...sort the neigbours in increasing order
c     and set pointer for diagonal
c
      do 550 i=1,nn
        nsize=ia(i+1)-ia(i)
        istart=ia(i) 
        iend=ia(i+1)-1
        jcount=0
        do 540 j=istart,iend
          jcount=jcount+1
          vector_to_sort(jcount)=ja(j)
  540   continue
        call qcksrt(nsize,vector_to_sort)
        jcount=0
        do 545 j=istart,iend
          jcount=jcount+1
          ja(j)=vector_to_sort(jcount)
          if(ja(j).eq.i) iadpiv(i)=j
  545   continue
  550 continue
c
c perform symbolic factorization and expand the link list
c if second order factorization
c
      if(order2) then
        call symfac(ihead,nzlist,link,iused)
c
c compute ia2, ja2 arrays from 2nd order linked list
c
        ia2(1) = 1
c
        icount = 0
        do 481 i = 1,nn
c
          inext = ihead(i)
  478     continue
          if(inext.ne.0) then
            icount = icount + 1
            ja2( icount )  =  nzlist(inext)
            inext  =  link(inext)
            go to 478
          endif
          ia2( i+1 ) = icount + 1
  481   continue
c
        if( ia2(nn+1)-1 .gt. maxnja2 )then
           write(66,*)' Dim maxnja2 exceeded ', 'need: ', ia2(nn+1)-1
           write(*,*)' Dim maxnja2 exceeded ', 'need: ', ia2(nn+1)-1
           stop 
        endif
c
c  resort the neigbours in increasing order
c  and set pointer for diagonal
c
        do 650 i=1,nn
          nsize=ia2(i+1)-ia2(i)
          istart=ia2(i)
          iend=ia2(i+1)-1
          jcount=0
          do 640 j=istart,iend
            jcount=jcount+1
            vector_to_sort(jcount)=ja2(j)
  640     continue
          call qcksrt(nsize,vector_to_sort)
          jcount=0
          do 645 j=istart,iend
            jcount=jcount+1
            ja2(j)=vector_to_sort(jcount)
            if(ja2(j).eq.i) iadpiv2(i)=j
  645     continue
  650   continue

        else
          do 450 i=1,nn
            ia2(i) = ia(i)
            iadpiv2(i) = iadpiv(i)
  450     continue
          ia2(nn+1) = ia(nn+1)
          do 455 j=1,ia(nn+1)-1
            ja2(j) = ja(j)
  455     continue

        end if
c
       return
       end

c***************************************************************************
 
      subroutine qcksrt(n,arr)

c***************************************************************************
      include 'tbc.prm'
      parameter (m=7,nstack=50,fm=7875.d0,fa=211.d0,fc=1663.d0
     *    ,fmi=1.2698413d-4)
      integer*4 arr(maxnb),istack(nstack),a
      jstack=0
      l=1
      ir=n
      fx=0.d0
10    if(ir-l.lt.m)then
        do 13 j=l+1,ir
          a=arr(j)
          do 11 i=j-1,1,-1
            if(arr(i).le.a)go to 12
            arr(i+1)=arr(i)
11        continue
          i=0
12        arr(i+1)=a
13      continue
        if(jstack.eq.0)return
        ir=istack(jstack)
        l=istack(jstack-1)
        jstack=jstack-2
      else
        i=l
        j=ir
        fx=mod(fx*fa+fc,fm)
        iq=l+(ir-l+1)*idint((fx*fmi))
        a=arr(iq)
        arr(iq)=arr(l)
20      continue
21        if(j.gt.0)then
            if(a.lt.arr(j))then
              j=j-1
              go to 21
            endif
          endif
          if(j.le.i)then
            arr(i)=a
            go to 30
          endif
          arr(i)=arr(j)
          i=i+1
22        if(i.le.n)then
            if(a.gt.arr(i))then
              i=i+1
              go to 22
            endif
          endif
          if(j.le.i)then
            arr(j)=a
            i=j
            go to 30
          endif
          arr(j)=arr(i)
          j=j-1
        go to 20
30      jstack=jstack+2
        if(jstack.gt.nstack)pause 'nstack must be made larger.'
        if(ir-i.ge.i-l)then
          istack(jstack)=ir
          istack(jstack-1)=i+1
          ir=i-1
        else
          istack(jstack)=i-1
          istack(jstack-1)=l
          l=i+1
        endif
      endif
      go to 10
      end
c***************************************************************************

      subroutine iluc

c***************************************************************************
c
      include 'tbc.prm'
      include 'tbc.dim'
c
c     do not worry about adjusting pivots, assume diagonal dominance
c
c     initialise the cb matrix
c-----------------------------------------------------------------------
      if(.not.order2) then
        do 6 i=1,ia(nn)
           cb(i)=0.d0
   6    continue
      else
        call dzero(ia2(nn),cb(1),1)
      end if
c
c  ...work on entire matrix if finite element or 2nd order
c
      if(order2) then
        icheck=1
      else
        icheck=0
      end if
      if(.not.finite_diff.or.nln.eq.6.or.icheck.eq.1) then
        do 20 i=1,nn
          istart1 = ia2(i) - 1
          iend = ia2(i+1) - 1
          ipos = 1
          do 15 icount = ia(i),ia(i+1)-1
            id = ja(icount)
            istart = istart1 + ipos
            do 13 icount2 = istart,iend
              id2 = ja2(icount2)
              if(id.eq.id2) then
                cb(icount2) = r(icount)
                ipos = ipos + 1
                goto 333
              elseif(id.gt.id2) then
                ipos = ipos + 1
              end if
   13       continue
  333       continue
   15     continue
c-----------------------------------------------------------------------
c       number of "bands" in this row
c-----------------------------------------------------------------------
          istart=ia2(i)
          iend=ia2(i+1)-1
c-----------------------------------------------------------------------
c       position of the diagonal in this row
c-----------------------------------------------------------------------
          k=iadpiv2(i)
c-----------------------------------------------------------------------
c       lower triangular matrix
c-----------------------------------------------------------------------
          do 30 j=istart,(k-1)
            sum = cb(j)
            icur=ja2(j)
            do 40 l=istart,(j-1)
              nnode=ja2(l)
              sum=sum-cb(l)*duc(nnode,icur)
40          continue
            cb(j)=sum
30        continue
c-----------------------------------------------------------------------
c       diagonal
c-----------------------------------------------------------------------
          sum = cb(k)
          do 50 l=istart,(k-1)
            nnode=ja2(l)
            sum=sum-cb(l)*duc(nnode,i)
50        continue
          d=1.0d0/sum
          cb(k)=d
c-----------------------------------------------------------------------
c       upper triangular matrix, actually d*u so we have unit diagonal
c-----------------------------------------------------------------------
          do 60 j=(k+1),iend
            sum = cb(j)
            icur=ja2(j)
            do 70 l=istart,(k-1)
              nnode=ja2(l)
              sum=sum-cb(l)*duc(nnode,icur)
70          continue
            cb(j)=d*sum
60        continue
20      continue

      elseif(finite_diff.and.icheck.eq.0) then

        do 120 i=1,nn
c-----------------------------------------------------------------------
c       number of "bands" in this row
c-----------------------------------------------------------------------
          istart=ia2(i)
          iend=ia2(i+1)-1
c-----------------------------------------------------------------------
c       position of the diagonal in this row
c-----------------------------------------------------------------------
          k=iadpiv2(i)
c-----------------------------------------------------------------------
c       diagonal
c-----------------------------------------------------------------------
          sum=r(k)
          do 150 l=istart,(k-1)
            nnode=ja2(l)
            sum=sum-r(l)*ducfd(nnode,i)
150       continue
          cb(i)=1.0d0/sum
120     continue

      end if

c-----------------------------------------------------------------------
c     matrix b contains the incomplete lu of r
c-----------------------------------------------------------------------

      return
      end
 
c***************************************************************************

      double precision function duc(i,nnode)

c***************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'
c-----------------------------------------------------------------------
c     this function searches the i'th row of the upper diagonal matrix
c     already calculated for an adjacency to the node 'nnode'.  if found
c     the corresponding value is returned, else 0 is returned.
c
c     for a finite element grid
c-----------------------------------------------------------------------
      duc=0.d0
      istart=iadpiv2(i)
      iend=ia2(i+1)-1
      if(i.eq.nnode)then
       duc=1.d0
       return
      endif

      do 10 j=istart,iend
        if(nnode.eq.ja2(j))then
         duc=cb(j)
         return
        end if
10    continue

      return
      end

c***************************************************************************

      double precision function ducfd(i,nnode)

c***************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'
c-----------------------------------------------------------------------
c     this function searches the i'th row of the upper diagonal matrix
c     already calculated for an adjacency to the node 'nnode'.  if found
c     the corresponding value is returned, else 0 is returned.
c
c     for a finite difference grid
c-----------------------------------------------------------------------
      ducfd=0.d0
      istart=iadpiv2(i)
      iend=ia2(i+1)-1
      if(i.eq.nnode)then
       ducfd=1.d0
       return
      endif

      do 40 j=istart,iend
        if(nnode.eq.ja2(j))then
         ducfd=cb(i)*r(j)
         return
        end if
40    continue

      return
      end
 
c***************************************************************************

      subroutine orthomin(istop,xratio,dxnorm)

c***************************************************************************
 
c     istop = allowable number of iterations before termination
c     ercg  = convergence criteria
c
      include 'tbc.prm'
      include 'tbc.dim'
      logical info
c-----------------------------------------------------------------------
c     initialization
c-----------------------------------------------------------------------
      if(flow_solution) then
        resid_check=resid_err
        absol_check=absol_err
        relat_check=relat_err
        info=isolv_info
      else
        resid_check=resid_errc
        absol_check=absol_errc
        relat_check=relat_errc
        info=isolv_infoc
      end if
      if(info) write(66,2100)
 2100 format(//'Iter',11x,'xratio',11x,'dxnorm',
     &    11x,' rnorm',11x,'checkr',/,
     &  4('-'),4(11x,6('-')))
c
c  ...initialize the residual res
c
      if(flow_solution) then
        call matm2c(cres,r,cu,nn)
      else
        call matm2c(cres,r,cu,nn)
      end if

      call dsub(nn,gb,cres)
ccc      do 50 i=1,nn
ccc        cres(i)=gb(i)-cres(i)
ccc50    continue
c
c  ...compute the initial residual norm
c
      if(check_residual) then
        rnorm_init=snrm2c(nn,cres)
        rnorm_check=resid_check*rnorm_init
      end if
c
c  ...initialize the current number of orthogonalizations
c
      northcur=0
c-----------------------------------------------------------------------
c     do up to istop iterations
c-----------------------------------------------------------------------
      do 100 i100=1,istop
c        write(*,2950) i100,istop
c 2950   format('+',4x,'ORTHOMIN iteration loop : i100 = ',i6,' /',i6)
c-----------------------------------------------------------------------
c       calculate (lu)**(-1)*cres=v
c-----------------------------------------------------------------------
cccc        call scopyc(nn,cres,vrv)
            call dcopy(nn,cres,vrv)
        call lsolvc
        call usolvc
c-----------------------------------------------------------------------
c       copy v into cq to start calc of new cq
c-----------------------------------------------------------------------
cccc        call scopyc(nn,vrv,cq)
            call dcopy(nn,vrv,cq)
c-----------------------------------------------------------------------
c       calculate r times v
c-----------------------------------------------------------------------
        call matm2c(vrv,r,cq,nn)
c-----------------------------------------------------------------------
c       copy rv into rq to start calc of new rq
c-----------------------------------------------------------------------
ccccc        call scopyc(nn,vrv,rq)
             call dcopy(nn,vrv,rq)
c-----------------------------------------------------------------------
c       determine new q and rq
c-----------------------------------------------------------------------
        k=1
1020    if(k.gt.northcur) goto 1030
        a=-sdotkc(nn,k,rqi,vrv)/rqidot(k)
        call sxpykc(nn,a,k,qi,cq)
        call sxpykc(nn,a,k,rqi,rq)
        k=k+1
        go to 1020
1030    continue
c-----------------------------------------------------------------------
c       update the current no of orth and save q, rq, rqnorm
c-----------------------------------------------------------------------
cccc        rqnorm=sdotc(nn,rq,rq)
        rqnorm=ddot(nn,rq,rq)
        northcur=northcur+1
        if(northcur.gt.north) northcur=1
        call scpykc(nn,northcur,cq,qi)
        call scpykc(nn,northcur,rq,rqi)
        rqidot(northcur)=rqnorm
c-----------------------------------------------------------------------
c       determine updated vector and residual
c-----------------------------------------------------------------------
        w=sdotc(nn,cres,rq)/rqnorm

        if(flow_solution) then
          call sxpykc(nn,w,northcur,qi,cu)
        else
          call sxpykc(nn,w,northcur,qi,cu)
        end if
        opw=-w
        call sxpykc(nn,opw,northcur,rqi,cres)
c-----------------------------------------------------------------------
c       determine if we should stop iterating
c       both relative and absolute error are checked
c       if either is within their specified tolerance, stop
c-----------------------------------------------------------------------
        if(flow_solution) then
          xnorm=snrm2c(nn,cu)
        else
          xnorm=snrm2c(nn,cu)
        end if
        dxnorm=dabs(w)*snrm2c(nn,cq)
        xratio=dxnorm/xnorm
        if(check_residual) then
          rnorm=snrm2c(nn,cres)
          if(info) write(66,2110) i100,xratio,dxnorm,
     &                                  rnorm,rnorm_check
          if(rnorm.le.rnorm_check) goto 200
          if(xratio.le.relat_check) goto 200
          if(dxnorm.le.absol_check) goto 200
        else
          if(info) write(66,2110) i100,xratio,dxnorm
          if(info) write(*,2110) i100,xratio,dxnorm
          if(xratio.le.relat_check) goto 200
          if(dxnorm.le.absol_check) goto 200
        end if
  100 continue

 2110 format(i4,4(2x,d15.8))
      write(66,102) xratio,dxnorm
cws      write(*,102) xratio,dxnorm
 102  format (
     $     /'ORTHOMIN terminates -- maximum number of iterations done ',
     $     /, ' xratio = ',d15.8, ',    dxnorm = ',d15.8)
  200 istop=i100

      return
      end
 
c***************************************************************************

      subroutine lsolvc

c***************************************************************************
      include 'tbc.prm'
      include 'tbc.dim'
c-----------------------------------------------------------------------
c     solve vec2 = (l**-1)vec1 for the vector vec2
c     the array vrv must hold vec1 on input, and vrv holds vec2 on outpu
c     l is in b.
c-----------------------------------------------------------------------
      if(order2) then
        icheck = 1
      else
        icheck = 0
      end if
      if(.not.finite_diff.or.nln.eq.6.or.icheck.eq.1) then
        do 20 i = 1,nn
          sum=vrv(i)
          k=iadpiv2(i)
          istart=ia2(i)
          do 30 j=istart,(k-1)
            nnode=ja2(j)
            sum=sum-cb(j)*vrv(nnode)
30        continue
          vrv(i)=cb(k)*sum
 20     continue
      elseif(finite_diff.and.icheck.eq.0) then
        do 60 i = 1,nn
          sum=vrv(i)
          k=iadpiv2(i)
          istart=ia2(i)
          do 70 j=istart,(k-1)
            nnode=ja2(j)
            sum=sum-r(j)*vrv(nnode)
70        continue
          vrv(i)=cb(i)*sum
 60     continue
      end if
      return
      end
 
c***************************************************************************

      subroutine usolvc

c***************************************************************************
      include 'tbc.prm'
      include 'tbc.dim'
c-----------------------------------------------------------------------
c     solve vec2 = (u**-1)vec1 for the vector vec2
c     the array vrv must hold vec1 on input, and vrv holds vec2 on output
c     u is in b
c-----------------------------------------------------------------------
      if(order2) then
        icheck = 1
      else
        icheck = 0
      end if
      if(.not.finite_diff.or.nln.eq.6.or.icheck.eq.1) then
      do 20 i = nn,1,-1
        sum=vrv(i)
        k=iadpiv2(i)
        iend=ia2(i+1)-1
        do 30 j=(k+1),iend
          nnode=ja2(j)
          sum=sum-cb(j)*vrv(nnode)
30      continue
        vrv(i)=sum
 20     continue
      elseif(finite_diff.and.icheck.eq.0) then
      do 60 i = nn,1,-1
        sum=vrv(i)
        k=iadpiv2(i)
        iend=ia2(i+1)-1
        do 70 j=(k+1),iend
          nnode=ja2(j)
          sum=sum-cb(i)*r(j)*vrv(nnode)
70      continue
        vrv(i)=sum
 60     continue
      end if
      return
      end
 
c***************************************************************************

      subroutine matm2c(s1,r,p,nn)

c***************************************************************************
      include 'tbc.prm'
      common /connec/ in,ia,ja,iadpiv
      dimension in(maxnln,maxne),ia(maxnn+1),ja(maxnja),
     &          iadpiv(maxnn)
c
c     the array r is dimensioned in the common blocks
c
      dimension s1(maxnn),p(maxnn),r(maxnja)
c-----------------------------------------------------------------------
      do 30 i=1,nn
        sum=0.d0
        istart=ia(i)
        iend=ia(i+1)-1
        do 40 j=istart,iend
          nnode=ja(j)
          sum=sum+r(j)*p(nnode)
40        continue
        s1(i)=sum
  30    continue
      return
      end
 
c***************************************************************************

      double precision function sdotc(nn,r,b)

c***************************************************************************
      include 'tbc.prm'
c
      dimension r(maxnn), b(maxnn)
c-----------------------------------------------------------------------
c     this function obtains the scalar dot product of a and b
c     where nn is the vector length
c-----------------------------------------------------------------------
      sdotc = 0.d0
      do 1 l=1,nn
        sdotc = sdotc + r(l)*b(l)
 1    continue
      return
      end
 
c***************************************************************************

      double precision function sdotkc(nn,k,r,b)

c***************************************************************************
      include 'tbc.prm'
c
      dimension r(maxnn,north),b(maxnn)
c-----------------------------------------------------------------------
c     this function obtains the scalar dot product of a and b
c     where nn is the vector length
c-----------------------------------------------------------------------
      sdotkc = 0.d0
      do 1 l=1,nn
        sdotkc = sdotkc + r(l,k)*b(l)
 1    continue
      return
      end
 
c***************************************************************************

      double precision function snrm2c(nn,r)

c***************************************************************************
      include 'tbc.prm'
c
      dimension r(maxnn)
c-----------------------------------------------------------------------
c     this function computes the l2 norm of vector r where
c     nn is the vector length
c     -this has been changed to the max norm
c-----------------------------------------------------------------------
      snrm2c=0.0d0
      do 1 l=1,nn
        temp=dabs(r(l))
        if(temp.gt.snrm2c) snrm2c=temp
c      snrm2c = snrm2c + r(l)*r(l)
   1  continue
c     snrm2c = dsqrt(snrm2c)
      return
      end
 
c***************************************************************************

      subroutine sxpykc(n,sa,k,fx,fy)

c***************************************************************************
      include 'tbc.prm'
c
      dimension fx(maxnn,north),fy(maxnn)
c-----------------------------------------------------------------------
      if(n.gt.0)then
       do 100 i=1,n
         fy(i) = sa*fx(i,k) + fy(i)
100    continue
      endif
      return
      end
 
c***************************************************************************

      subroutine scopyc(n,fx,fy)

c***************************************************************************
      include 'tbc.prm'
c
      dimension fx(maxnn),fy(maxnn)
c-----------------------------------------------------------------------
      if(n.gt.0)then
       do 100 i=1,n
         fy(i) = fx(i)
100      continue
      endif
      return
      end
 
c***************************************************************************

      subroutine scpykc(n,k,fx,fy)

c***************************************************************************
      include 'tbc.prm'
c
      dimension fx(maxnn),fy(maxnn,north)
c-----------------------------------------------------------------------
      if(n.gt.0)then
       do 100 i=1,n
         fy(i,k) = fx(i)
100      continue
      endif
      return
      end
      

      subroutine dadd (n,sx,incx,sy,incy)
c--------------------------------------------------------------------
c
c a blas-like routine
c
c vector plus a vector sy = sy + sx
c (written to avoid the terrible burden of the multiplication
c by a constant in saxpy)
c uses unrolled loops for increments equal to one
c
c--------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      dimension sx(*),sy(*)
c
      if (n .le. 0) return
c
      if (incx .eq. 1 .and. incy .eq. 1) then
        m = mod(n,4)
        if (m .ne. 0) then
          do 10 i = 1,m
            sy(i) = sy(i) + sx(i)
   10     continue
        endif
        if (n .lt. 4) return
        do 20 i = m+1,n,4
          sy(i  ) = sy(i  ) + sx(i  )
          sy(i+1) = sy(i+1) + sx(i+1)
          sy(i+2) = sy(i+2) + sx(i+2)
          sy(i+3) = sy(i+3) + sx(i+3)
   20   continue
c
      else
c
        ix = 1
        iy = 1
        if (incx .lt. 0) ix = (-n+1)*incx + 1
        if (incy .lt. 0) iy = (-n+1)*incy + 1
        do 30 i = 1,n
          sy(iy) = sy(iy) + sx(ix)
          ix = ix + incx
          iy = iy + incy
   30   continue
c
      endif
c
      end
      subroutine dsub(n,sx,sy)
c--------------------------------------------------------------------
c
c a blas-like routine
c
c vector minus a vector sy = sx - sy
c (written to avoid the terrible burden of the multiplication
c by a constant in saxpy)
c uses unrolled loops for increments equal to one
c
c--------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      dimension sx(*),sy(*)
c
      if (n .le. 0) return
c
        m = mod(n,4)
        if (m .ne. 0) then
          do 10 i = 1,m
            sy(i) = sx(i) - sy(i)
   10     continue
        endif
        if (n .lt. 4) return
        do 20 i = m+1,n,4
          sy(i  ) = sx(i  ) - sy(i  )
          sy(i+1) = sx(i+1) - sy(i+1)
          sy(i+2) = sx(i+2) - sy(i+2)
          sy(i+3) = sx(i+3) - sy(i+3)
   20   continue
c
      end

      subroutine daxpy (n,sa,sx,incx,sy,incy)
c--------------------------------------------------------------------
c
c a blas routine
c
c constant times a vector plus a vector sy = sy + sa*sx
c uses unrolled loops for increments equal to one
c
c--------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      dimension sx(*),sy(*)
c
      if (n .le. 0 .or. sa .eq. 0.0) return
c
      if (incx .eq. 1 .and. incy .eq. 1) then
        m = mod(n,4)
        if (m .ne. 0) then
          do 10 i = 1,m
            sy(i) = sy(i) + sa*sx(i)
   10     continue
        endif
        if (n .lt. 4) return
        do 20 i = m+1,n,4
          sy(i  ) = sy(i  ) + sa*sx(i  )
          sy(i+1) = sy(i+1) + sa*sx(i+1)
          sy(i+2) = sy(i+2) + sa*sx(i+2)
          sy(i+3) = sy(i+3) + sa*sx(i+3)
   20   continue
c
      else
c
        ix = 1
        iy = 1
        if (incx .lt. 0) ix = (-n+1)*incx + 1
        if (incy .lt. 0) iy = (-n+1)*incy + 1
        do 30 i = 1,n
          sy(iy) = sy(iy) + sa*sx(ix)
          ix = ix + incx
          iy = iy + incy
   30   continue
c
      endif
c
      end

      subroutine dcopy (n,x,y)
c--------------------------------------------------------------------
c
c a blas routine
c
c copies a vector x to a vector y
c uses unrolled loops for increments equal to 1
c
c--------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      dimension x(*),y(*)
c
      if (n .le. 0) return
c
        m = mod(n,7)
        if (m .ne. 0) then
          do 10 i = 1,m
            y(i) = x(i)
   10     continue
        endif
        if (n .lt. 7) return
        do 20 i = m+1,n,7
          y(i  ) = x(i  )
          y(i+1) = x(i+1)
          y(i+2) = x(i+2)
          y(i+3) = x(i+3)
          y(i+4) = x(i+4)
          y(i+5) = x(i+5)
          y(i+6) = x(i+6)
   20   continue
c
      end
      subroutine icopy (nec,dummy,i,nnpe,maxnn)
c--------------------------------------------------------------------
c
c
c--------------------------------------------------------------------
      implicit integer*4 (a-h,o-z)
      dimension nec(maxnn,nnpe), dummy(4)
c
      do 10 j = 1, 4
 10   dummy(j) = nec(i,j)
      end

      function ddot (n,sx,sy)
c--------------------------------------------------------------------
c
c a blas routine
c
c forms the dot product of two vectors
c uses unrolled loops for increments equal to one.
c
c--------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      dimension sx(*),sy(*)
c
      stemp = 0.d0
      ddot = 0.d0
      if (n .le. 0) return
c
        m = mod(n,5)
        if (m .ne. 0) then
          do 10 i = 1,m
            stemp = stemp + sx(i)*sy(i)
   10     continue
        endif
        if (n .lt. 5) go to 40
        do 20 i = m+1,n,5
          stemp = stemp + sx(i)*sy(i) + sx(i+1)*sy(i+1) +
     1    sx(i+2)*sy(i+2) + sx(i+3)*sy(i+3) + sx(i+4)*sy(i+4)
   20   continue
c
   40 ddot = stemp
c
      end

      subroutine dscal (n,c,x,incx)
c--------------------------------------------------------------------
c
c a blas routine
c
c scale a vector by a constant c
c uses unrolled loops for increment equal to 1
c
c--------------------------------------------------------------------
      implicit double precision (a-h,o-z)
      dimension x(*)
c
      if (n .le. 0) return
c
      if (incx .eq. 1) then
        m = mod(n,5)
        if (m .ne. 0) then
          do 10 i = 1,m
            x(i) = c*x(i)
   10     continue
        endif
        if (n .lt. 5) return
        do 20 i = m+1,n,5
          x(i  ) = c*x(i  )
          x(i+1) = c*x(i+1)
          x(i+2) = c*x(i+2)
          x(i+3) = c*x(i+3)
          x(i+4) = c*x(i+4)
   20   continue
c
      else
c
        nincx = n*incx
        do 30 i = 1,nincx,incx
          x(i) = c*x(i)
   30   continue
c
      endif
c
      end

      subroutine dzero (n,x,incx)
c--------------------------------------------------------------------
c
c no comment
c
c--------------------------------------------------------------------
      double precision x(*)
c
      if (n .le. 0) return
c
      if (incx .eq. 1) then
        m = mod(n,5)
        if (m .ne. 0) then
          do 10 i = 1,m
            x(i) = 0.d0
   10     continue
        endif
        if (n .lt. 5) return
        do 20 i = m+1,n,5
          x(i  ) = 0.d0
          x(i+1) = 0.d0
          x(i+2) = 0.d0
          x(i+3) = 0.d0
          x(i+4) = 0.d0
   20   continue
c
      else
c
        nincx = n*incx
        do 30 i = 1,nincx,incx
          x(i) = 0.d0
   30   continue
c
      endif
c
      end
