c iaja pointers, lowercase conversion June 92
c
c Transmsp - transport, multiple species
c June 92
c reduced version (no fractures, fully saturated), feb 1993
c
c************************************************************************

      subroutine input_transport(prefix,lenprefix,name,lenname)

c************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'

      real*4 var1,var2,akk1,akk2,akk3
      logical fileinit,cauchy_bc,ex,k_biochem,napl_in_domain
      logical boundary_file
      character*100 prefix,name,fname
      character*80 grtitle
	character*60 surffile
      dimension nident(maxnn)
      common /control/ tolex, maxiter

     
   10 format(a80)
   20 format(a40)
   21 format(a60)

      do 4378 i=1,maxsp
         spname(i)=" NOT YET SET        "
         dblkd(i)=1.d0
         csat(i)=0.d0
         csatmax(i)=0.d0
 4378 continue

      write(66,6000)
 6000 format(///17x,40('*'),/,17x,
     &    '* Input data for the transport problem *',/,17x,40('*'))

c************************************************************************
c   Group 13: Transport simulation control parameters
c************************************************************************
 
c
c   Switches
c   --------
c   mass_balancec: true, perform mass balance
c                  false, no mass balance
c   xterms:        true, compute diffusive cross-terms explicitly
c                        for finite difference, no effect if FE
c                  false, ignore the cross terms for FD
c   cvolume:       true, use control volume approach for transport
c                        (valid for finite difference only)
c                  false, use standard FE or FD for transport
c   lchem:         =0, solve for a non-biodegradable tracer only
c                  =3, solve for 9 species involved in the nitrate
c                      system (Om, Oim, Nm, Nim, OCm, OCim, OCmat, Cnapl, X)
c                      as well as the non-biodegradable tracer
c                  =5, solve for the tracer, the nitrate system and
c                      the carbonate system (CAm, CTOTm, ALKm)
c
      write(*,*) ' Reading GROUP 13'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 13'
         stop
      endif
c      read(55,*) mass_balancec
c     sd mass_balancec must be true
      mass_balancec=.true.
      read(55,*) xterms
      read(55,*) cvolume
      read(55,*) maxiter, tolex
c

      write(66,13) 
   13 format (//39('*')/,'Transport Simulation Control Parameters',
     & /,39('*'))

c      if(mass_balancec) write(66,7285)
c      if(.not.mass_balancec) write(66,7287)
c 7285 format('Mass balance is computed')
c 7287 format('Mass balance is not computed')
      if(.not.cvolume) then
        write(66,6687)
      elseif(cvolume.and.finite_diff) then
        write(66,6685)
      elseif(cvolume.and..not.finite_diff) then
        write(66,6688)
        cvolume=.false.
      end if
 6685 format('Control volume approach is used')
 6687 format('No control volume approach used')
 6688 format('Finite element is used for transport',/,
     &  '  Control volume approach not implemented')
      if(.not.finite_diff) then
        xterms=.false.
      else
        if(xterms) write(66,7292)
        if(.not.xterms) write(66,7293)
 7292   format('Diffusive cross terms explicitly computed for FD')
 7293   format('Diffusive cross terms ignored for FD')
      end if

c************************************************************************
c     Group 14: Output control parameters for transport
c************************************************************************
c
c     krestarc: read concentrations saved from last simulation and
c               use as initial conditions
c               =0, don't read concentration from previous simulation
c               =1, read concentrations from a file (unit 16, binary)
c                   file prefix.cin
c
c     kwrithc:  write concentration from the last time step for further
c               use as initial conditions for a new simulation
c               =0, don't write the concentrations
c               =1, write the concentrations in a file (unit 51, binary)
c                   file prefixo.cen
c     
c     kpconc:  print times for nodal concentrations to unit 41 (binary)
c              =n, printout for every n-th time value
c              no effect if flow simulation only
c
c     *** for the kphead and kpconc flags, if time_step_control is used,
c     *** there will be output at the target time steps only if their value
c     *** is greater then 0.
c     
c
c     kpmasbc:  If mass balance is computed then:
c               it is outputted every kpmasbc'th time step
c               never outputted if kpmasb is equal to 0.
c
c               For time step control, the following apply
c               kpmasb = 0, no output
c               kpmasb > 0, output at target times
c               kpmasb < 0, output at all time values.
c
      write(*,*) ' Reading GROUP 14'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 14'
         stop
      endif
      read(55,*) krestarc,kwrithc,kpconc,kwritedat,kpmasbc
      write(66,6003) krestarc,kwrithc,kpconc,kwritedat,kpmasbc
 6003 format(//35('*'),/,'Transport Output Control Parameters',/,
     &     35('*'),/,'krestarc:',t20,i5,/,'kwrithc:',t20,i5,/,'kpconc:'
     $     ,t20,i5,/,'kwritedat:',t20,i5,/'kpmasbc:',t20,i5)
c
c  ...Open files
c
      if(krestarc.eq.1) then
        inquire(file=prefix(:lenprefix)//name(:lenname)//'.cin',
     &               exist=ex)
        if(.not.ex) then
          write(*,*) 'Restart file (.cin) for conc is missing'
          write(66,*) 'Restart file (.cin) for conc is missing'
          stop
        end if
        open(unit=16,file=prefix(:lenprefix)//name(:lenname)//'.cin',
     &   status='unknown',form='unformatted')
c     &   status='unknown')
        rewind(16)
      end if
      if(kwrithc.eq.1) then
        inquire(file=prefix(:lenprefix)//name(:lenname)//'o.cen',
     &          exist=ex)
        if(ex) then
          write(*,*) ' File for last time values (.cen) will',
     &     ' be overwritten'
          write(66,*) ' File for last time values (.cen) will',
     &     ' be overwritten'
        end if
        open(unit=51,file=prefix(:lenprefix)//name(:lenname)//'o.cen',
     &       status='unknown',form='unformatted')
c     &       status='unknown')
        rewind(51)
cwo     ****testfile****
cwo        open(unit=71,file=prefix(:lenprefix)//name(:lenname)//'c.asc',
cwo     &       status='unknown')
cwo        rewind(71)
      end if




c
c  ...If wells are present, open an output file for the
c     flux-averaged concentrations at the well(s)
c
      if(nwell.gt.0) then
c         open(unit=61,file=prefix(:lenprefix)//name(:lenname)//'o.wco',
c     &        status='unknown')
         open(unit=92,file=prefix(:lenprefix)//name(:lenname)//'o.wec',
     &        status='unknown')

c     rewind(61)
         rewind(92)

c        write(61,*)'Well      Species   Time           Concentration'
      end if

c************************************************************************
c   Group 15: Transport parameters for the porous media
c************************************************************************
c
c     Read properties for the zones previously defined in the flow part
c
      write(66,6300)
 6300 format(/41('*'),/,'Transport Parameters for the porous media',
     & /,41('*'))
      write(*,*) ' Reading GROUP 15'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 15'
         stop
      endif
ckd      read(55,*) kd_rand
c     kd for flow = retardation disabled (commented with ckd)
c  ...First read kd_rand (logical)
c            =false, kd's are read with the other transport properties
c            =true,  kd's come from a random generator
c
c     Then, properties are
c
c     al:       longitudinal dispersivity
c     at:       transverse dispersivity
c      The expression given by Burnett and Frind WRR (1987) is used
c      for the dispersivity tensor, allowing the input of a vertical
c      transverse dispersivity.
c      Note that if you set the vertical transverse dispersivity equal
c      to the horizontal transverse dispersivity, the above dispersion
c      tensor results in the usual tensor (eg. Bear, 1972).
c      for the dispersion tensor is used
c     atv:      vertical transverse dispersivity
c     dstar:    effective molecular diffusion coefficient
c               note that dstar is an effective diffusion
c               coefficient that does not have porosity embedded in it.
c               that is, the diffusive flux is:
c               qd = - (porosity)*(eff. diff. coeff.)*(conc. gradient)
c     pors:     saturated porosity
c     bdens:    soil bulk density
c
      do 200 i=1,nzones_prop
        read(55,*) al(i),at(i),atv(i)
        if(atv(i).le.0.0d0) atv(i)=at(i)
        read(55,*) dstar(i)
        read(55,*) bdens(i)
ckd        if(.not.kd_rand) read(55,*) dkd(i)
        write(66,6005) i
 6005   format(/,'Zone',i4)
        write(66,6010) al(i),at(i),atv(i),dstar(i),bdens(i)
ckd        if(.not.kd_rand) write(66,6017) dkd(i)
 6010   format(/,'Longitudinal dispersivity:',t45,e12.3/
     &  ,'Transverse dispersivity:',t45,e12.3/
     &  ,'Vertical transverse dispersivity:',t45,e12.3/
     &  ,'Diffusion coefficient:',t45,e12.3/
     &  ,'Soil bulk density:',t45,e12.3)
ckd 6017   format('Distribution coefficient:',t45,e12.3)
  200 continue

c     Note, if you entered the hydraulic conductivity in Group 5 by a
c     surferfile, the kd's, al ... and so on, must be specified by the user
c     for every element. Therefor it's assumed, if kd_rand is set to false
c     that the kd,al,at,... are constant for the whole domain.

      if((k_surfer).or.(k_rand)) then
         if(ne.gt.maxpznc) then
            write(66,*) 'Required value for maxpznc :',
     $           ne, ' but maxpznc = ',maxpznc
            write(66,*) ' Increase maxpznc and recompile'
            stop
         endif
         do 445 i=2,ne
            al(i)=al(1)
            at(i)=at(1)
            atv(i)=atv(1)
            dstar(i)=dstar(1)
            bdens(i)=bdens(1)
c     dkd(i)=dkd(1)
 445     continue
         nzones_prop=ne


      endif


ccwo    Einlesen von Zonen mit unterschiedlichem al, at und atv
c
c     First read the number of zones having uniform initial
c     conditions (but different from default).
c
c     For each zone
c       specify its extent with
c       xfrom,xto,yfrom,yto,zfrom,zto
c
c       specify the initial value
c
c    
      read(55,*) default_ic
          if(default_ic) write(66,6048)
          if(.not.default_ic) write(66,6049)
 6048     format('All nodes have default initial condition')
 6049     format('Default initial condition do not apply to all ',
     &             'nodes')
        if(.not.default_ic)then
c
c     if not all nodes have initial conditions, then
c     first read the number of zones having uniform initial
c     conditions (but different from default).
c     for each zone
c       specify its extent with
c       xfrom,xto,yfrom,yto,zfrom,zto
c
c       specify the initial value
c
c  ***note: ninit is recalculated
c
          read(55,*) nzones
          ninit=0
          write(66,8220)
 8220     format(/,'Nodes having initial conditions different from',
     &    ' the default',//,5('  node',
     &      1x,'   value'),/,5('  ----',1x,'   -----'))

          iflag=1
          do 125 i=1,nzones
            ilast=0
            read(55,*) xfrom_nod,xto_nod,yfrom_nod,yto_nod,
     &                 zfrom_nod,zto_nod
            call fnodes(ilast,iend,nident,maxnn,iflag,
     $        xfrom_nod,xto_nod,yfrom_nod,yto_nod,zfrom_nod,zto_nod)
            read(55,*) alzone, atzone, atvzone

            ninit=ninit+iend
c
c  ...check array size for nident()
c
            if(iend.gt.maxnn) then
              write(66,6635) iend, maxnn
              write(*,6635) iend, maxnn
 6635         format(//,80('*'),/,'ERROR when assigning initial ',
     &  'conditions',/,'The number of nodes having non-default initial'
     &  ,' conditions is ',i6,/,'the dimension of nident is maxnn='
     &  ,i6,/,'Recompile by increasing the value of maxnn')
              stop
            end if
            do 123 ii=1,iend
              al(nident(ii))=alzone
              at(nident(ii))=atzone
              atv(nident(ii))=atvzone
  123       continue
            write(66,1146) (nident(ii),alzone,ii=1,iend)
            write(66,1146) (nident(ii),atzone,ii=1,iend)
            write(66,1146) (nident(ii),atvzone,ii=1,iend)
 1146       format(5(i6,1x,f8.2))
  125     continue
          write(66,8226) ninit
 8226     format(/'Total number of nodes having different initial',
     &        ' conditions:',i6)

        endif
ccwo

ckd      if(kd_rand) then
c
c  ...Check if the maximum number of kd values is at least
c     equal to maxne. otherwise the program stops and
c     compilation is required
c
c        if(maxkdzn.lt.ne) then
c          write(66,6020) maxkdzn,ne
c 6020     format('**** ERROR *****',/,'Input from a random ',
c     +    'field generator is required',/,'but the maximum ',/,
c     +    'number of kd zones (maxkdzn) is',i7,' which is less',/,
c     +    'than the number of elements',i7,/,'a new compilation is ',
c     +    'required, *** Program stopped ***')
c          stop
c        end if
c
c  ...Random generator input
c
c     Read the file name for kd's
c
c        read(55,*) fname
c        write(66,*) 'Now opening file ',fname
c        open(unit=26,file=fname,status='old',form='unformatted')
c        rewind(26)
c
c  ...Read conversion factor for ks's.
c
c        read(55,*) convf
c        write(66,6025) fname,convf
c 6025   format(//'Random kd-s read from file ',a60,/,'Conversion ',
c     &  'factor for kd-s:',d12.5)
c
c  ...Random field generator input
c
c        read(26) kk1,kk2,kk3,akk1,akk2,akk3
c        iel=0
c        write(66,6030) kk1,kk2,kk3,akk1,akk2,akk3
c 6030   format(/,5x,'k1:',t15,i6,/,5x,'k2:',t15,i6,
c     &   /,5x,'k3:',t15,i6,/,5x,'ak1:',t11,f10.3,/,5x,
c     &   'ak2:',t11,f10.3,/,5x,'ak3:',t11,f10.3/)
c        write(66,6035)
c 6035   format(/'This program reads the second variable coming from',
c     &  ' the random generator',/,'and assumes that it is ln(dis',
c     &       'tribution coefficient)',/)
c        do 300 i=1,nz-1
c          do 290 j=1,ny-1
c            do 280 k=1,nx-1
c              iel=iel+1
c              read(26) var1,var2
c              dkd(iel)=convf*dexp(dble(var2))
c  280       continue
c  290     continue
c  300   continue
ckd      end if




c      read (55,*) adk
      read (55,*) (volume(i),i=1,3)
      volume(4)=volume(3)
ckd      write(66,1006) adk
c1006  format(/,' Adsorption coefficient cmat-cmob  [lmob/Mmat]  : ',
c     &     d10.4)

c     change adsorbtion coefficient to lmob/lmat
c      adk=adk*bdens(1)

      write(66,'(/,a)') ' Specific volumes of phases [-] :'
      write(66,1005) volume(1),volume(2),volume(3)
1005  format(' Specific volume of  Porewater              : ',d10.4,
     &     /,'                     Biophase               : ',d10.4,
     &     /,'                     Matrix                 : ',d10.4)

      read(55,*) napl_interaction
      if (napl_interaction) then
         write(66,*)
     $        'NAPL solubility depends on their relative concentration.'
      else 
         write(66,*) 'No NAPL interaction' 
      endif

c************************************************************************
c   Group 16: Initial condition data for transport
c************************************************************************

c
c  ...Assign initial conditions for transport for all species
c     except those in the biophase (their initial concentration
c     is computed from the concentration of the mobile part)
c
c     read default_ic: true, all nodes have default initial conditions
c                      false, there are nodes with initial conditions
c                      different from the default
c     cinit:    initial concentration within domain
c
c>>>>><<<<<
c**********************************************************
c  Special for Hunxe case
c  **********************
c
c  if krestar is 0, still have option to read initial conc.
c  from a specific file, for each species
c  READ: fileinit (logical)
c   if fileinit is true, read fname
c**********************************************************
c>>>>><<<<<
c
c     +++   napl_in_domain checks present of NAPLs ++++
c     +++   napl_interaction checks interaction of NAPLs solubility +++
      napl_in_domain=.false.
c      napl_interaction=.false.
      write(*,*) ' Reading GROUP 16'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 16'
         stop
      endif
      write(66,6038)
 6038 format(//31('*')/,'Initial conditions for transport',/,
     &         31('*'),/)
      if(krestarc.eq.0) then     ! dont read old conc from file
        read (55,*) nsp
        if (nsp.gt.maxsp) then
           write(66,*) ' Required amount of species : ', nsp,
     $          ' but only ', maxsp,' species available (maxsp)'
           write(66,*) ' Increase maxsp and recompile'
           stop
        endif
        istart=1
	  do 235 isp=1,nsp
          read (55,*) spname(isp)
          read(55,*) ioutspec(isp)
          read (55,*) Phase(isp),exspec(isp),exchc(isp),cmolfac(isp)
          if (phase(isp).eq.4) napl_in_domain=.true.
          if (iabs(phase(isp)).eq.3) then
             read(55,*) dblkd(isp)
          elseif (iabs(phase(isp)).eq.4) then
             read(55,*) csat(isp)
          endif
          read (55,*) clambda(isp)
          read(55,*) default_ic
          write(66,6040) isp,spname(isp)
 6040     format(/,'*** Species ',i3,': ',a20,' ***')

          if (phase(isp).lt.0) then
            write(66,FMT='(a,$)') ' Species is not reactive '
         else
            write(66,'(a,$)') ' Species is     reactive '
         endif
         if (iabs(phase(isp)).eq.1) then
            write(66,*)  'in mobile phase'
            cmolfac(isp)=1.d0
         else if (iabs(phase(isp)).eq.2) then
            write(66,*)  'in bio-phase'
            cmolfac(isp)=1.d0
         else if (iabs(phase(isp)).eq.3) then
            write(66,*)  'on matrix'
            write(66,*) ' The distribution coefficient is'
     $           ,dblkd(isp),' [M/M]'
            dblkd(isp)=dblkd(isp)*bdens(1)
            cmolfac(isp)=1.d0
         else if (iabs(phase(isp)).eq.4) then
            write(66,*)  'as NAPL'
            write(66,*) ' The maximum solubility is       ',csat(isp)
            write(66,*) ' OC contains ',cmolfac(isp),' C'
            cmolfac(isp)=1.d0/dmax1(cmolfac(isp),1.d0)
         else
            Write(*,*)  'Illegal phase index in group 16 species',isp
            Write(66,*) 'Illegal phase index in group 16 species',isp
            stop
         endif
         if ((exspec(isp).gt.0).and.(exspec(isp).le.nsp)) then
            write(66,'(2a,i3,3x,a20)') ' Species exchanges with ',
     &           'species nr. ',exspec(isp),spname(exspec(isp))
            write(66,'(a,3x,e15.4)') ' The exchange-coefficient is ',
     &           exchc(isp)
         else if (exspec(isp).eq.0) then
            write(66,'(a)') ' Species does not exchange.'
         else
            Write(*,*)  'Illegal phase index in group 16 species',isp
            Write(66,*) 'Illegal phase index in group 16 species',isp
            stop
         endif
          write(66,'(a,d12.3)') ' First order decay rate : ',
     &               clambda(isp)
          if(default_ic) write(66,6045)
          if(.not.default_ic) write(66,6046)
 6045     format('All nodes have default initial condition')
 6046     format('Default initial condition do not apply to all ',
     &             'nodes')
c
c     If initial concentrations are not read from a file (krestarc=0) then
c  ...read either uniform initial conditions (ninit=0)
c     or variable initial conditions (ninit > 0)
c
cc        if(krestarc.eq.0) then
          read(55,*) cinit
          write(66,6050) cinit
 6050     format('Initial concentration within domain:',d15.8)
          do 320 i=(isp-1)*nn+1,isp*nn
            cic(i)=cinit
  320     continue
cws Feb. 1999
          if(default_ic) istart = istart + nn
          if(.not.default_ic)then
c>>>>><
            read(55,*) fileinit
            if(fileinit) then
cws              read(55,*) fname
cws              write(66,*) 'Now opening file ',fname
cws              open(unit=80,file=fname,status='unknown',
cws     &             form='unformatted')
cws              rewind(80)
cws              read(80) trestar
cws              read(80) (cic(i),i=(isp-1)*nn+1,isp*nn)
cws              close(80)
cws              write(66,6072) fname,trestar
cws 6072         format(//,'Initial concentrations read from ',a60,/
cws     &                 ,'Initial time: ',d12.7,//)
c>><<
cws              comin=cic((isp-1)*nn+1)
cws              comax=cic((isp-1)*nn+1)
cws              do 2438 i=(isp-1)*nn+2,isp*nn
cws                if(cic(i).gt.comax) comax=cic(i)
cws                if(cic(i).lt.comin) comin=cic(i)
cws 2438         continue
cws              write(66,*) spname(isp),' cmin:',comin,' cmax:',comax
c>><<
cws   ************************************************************************
cws      December 1998
cws      New type of concentration data input
cws      Now TBC can immediately read ASCII grid files from SURFER
cws      read file name for species concentrations 
cws      concentrations have to be provided layerwise
c
              do 7479 iz=1,nz
                read(55,*) convf
                read(55,22) surffile
                write(66,*) 'Reading species',isp,' in layer',iz,
     &	                  ' from file',surffile
                write (66,7788) convf
 7788           format ('Conversion factor:   ',d16.9,/)
                lensurf=index(surffile,' ') - 1
                open(unit=25,file=prefix(:lenprefix)
     &               //surffile(:lensurf),
     &               status='old', recl=5000)
cws
                read(25,10) grtitle
                read (25,*) ix,iy
                if ((ix.ne.nx).or.(iy.ne.ny)) then
                   write(66,*) ' ERROR in file ',surffile
                   write(66,*) '  Number of nodes in file  X ',ix,' Y ',
     &                   iy,'  Number of nodes in TBC   X ',nx,' Y ',ny
                   write(*,*) ' WARNING number of nodes in data-file ,
     &                          surffile, is not consistent 
     &                          with model values values !'
                endif
                read(25,10) grtitle
                read(25,10) grtitle
                read (25,*) cmin,cmax
cws             read(25,*) trestar
                read(25,*) (cic(i),i= istart, istart+nndsl-1)
cws
                do 3465 i= istart, istart+nndsl-1
                  cic(i)=convf*cic(i)
 3465           continue
cws
                close(25)
                write(66,3025) cmax,cmin
cws
                istart=istart+nndsl
 7479         continue
 22           format(a40)
 3025         format('Maximum c-value: ',d15.9,' 
     &                minimum c-value: ',d15.9)
cws           December 1998
cws           End of new input type

             elseif(.not.fileinit) then
c><<<<<<
c
c             First read the number of zones having uniform initial
c             conditions (but different from default).
c
c             For each zone
c             specify its extent with
c             xfrom,xto,yfrom,yto,zfrom,zto
c
c             specify the initial value
c
c             ***note: ninit is recalculated   
c 
              read(55,*) nzones
              ninit=0
              write(66,6060)
 6060         format(/,'Nodes having initial conditions different',
     &                 ' from default',//,5('  node',
     &              1x,'   value'),/,5('  ----',1x,'   -----'))

              iflag=1
              do 330 i=1,nzones
                ilast=0
                read(55,*) xfrom_nod,xto_nod,yfrom_nod,yto_nod,
     &                     zfrom_nod,zto_nod
                call fnodes(ilast,iend,nident,maxnn,iflag,
     &                      xfrom_nod,xto_nod,yfrom_nod,yto_nod,
     &                      zfrom_nod,zto_nod)
                if(iend.gt.maxnn) then
                  write(66,6627) iend,maxnn
                  write(*,6627) iend,maxnn
 6627             format(//,80('*'),/,'ERROR when assigning ',
     &                   'initial conditions for transport',/,
     &                   'The number of initial condition nodes is ',
     &                   i8,/,'The dimension of nident is maxnn = ',
     &                   i8,/,'increase the value of maxnn and ',
     &                   'recompile')
                  stop
                end if
                read(55,*) czone

                ninit=ninit+iend
                do 325 ii=1,iend
                  cic((isp-1)*nn+nident(ii))=czone
  325           continue
                write(66,6065) (nident(ii),czone,ii=1,iend)
  330         continue
              write(66,6070) ninit
 6065         format(5(i6,1x,f8.2))
 6070         format(/'Total number of nodes having different ',
     &                'initial conditions:',i6)

c>><<<
            end if
c>><<<
          endif
 235    continue



       elseif(krestarc.eq.1) then 
c
c  .. . If restarting simulation, read initial conc for
c       ALL species from file 16
c     
        read(16) trestar
        read(16) nsp
        do 5476 i=1,nsp
           read(16) spname(i)
           read(16) ioutspec(i)
           read(16) phase(i),exspec(i),exchc(i),cmolfac(i)
          if (phase(i).eq.4) napl_in_domain=.true.
          if (iabs(phase(i)).eq.3) then
             read(16) dblkd(i)
          elseif (iabs(phase(i)).eq.4) then
             read(16) csat(i)
          endif
          read (16) clambda(i)
          read(16) (cic(j),j=(i-1)*nn+1,i*nn)
 5476   continue
c
c  ...Overwrite initial time read from unit 16
c        read(55,*) trestar
        write(66,6075) trestar
 6075   format(//,'Initial concentrations read from unit 16',/
     &         ,'  Initial time: ',d14.7,//)
      end if

      do 777 iijj=1,nsp
         csatmax(iijj)=csat(iijj) 
 777  continue

c************************************************************************
c     Group 17: First-type boundary conditions for transport
c************************************************************************
c
c  ...If multiple species are considered, then specify different
c     zones for fixed concentration and assume that all MOBILE
c     species have a fixed concentration for these zones
c
      write(*,*) ' Reading GROUP 17'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 17'
         stop
      endif
      write(66,6103)
 6103 format (//,43('*'),/,'First-type boundary conditions ',
     &  'for transport',/,43('*'))
c
c  ...Initialise flag for first-type nodes
c
      do 350 i=1,nn
        icc(i)=0
  350 continue

      nbc1tot=0
      read(55,*) dirichlet_bc
      if(.not.dirichlet_bc) write(66,6105)
 6105 format('No dirichlet nodes')
      if(dirichlet_bc) then
c
c  ...First read use_coord
c                =true, input each dirichlet node separatly
c                =false, input zone for dirichlet nodes
c                         specify zone by using coordinates
c                         xfrom,xto,yfrom,yto,zfrom,zto
c
        read(55,*) use_coord

c     ...read boundary_file
c     =false : input read from standard inputfile name.in
c     nfileid = 55
c     =true  : input read from special file name.dbc
c     nfileid = 99

        read(55,*) boundary_file
        if(.not.boundary_file) nfileid=55
        if(boundary_file) then 
           nfileid=99
           open(unit=99,file=prefix(:lenprefix)//name(:lenname)//'.1tt',
     &          status='unknown')
        endif




        if(.not.use_coord) then
c
c     If use_coord is false, then read
c        nbc1_zones= number of different concentration zones
c
c        for each zone, read
c          nbc1 = number of dirichlet nodes
c          iconbc1, if true, initial concentration is the fixed
c                      concentration, must specify time interval
c                   if false, must specify the following
c            nbc1_conc: number of concentration time intervals
c            for each time interval read
c              concentration,ton,toff
c              then read all the nodes having above first-type cond.
c              node_bc1(i)    = first-type node number
c
           read(nfileid,*) nbc1_zones
           if (nbc1_zones.gt.maxznbc1) then
              write(66,*) ' Required number of zones : ',nbc1_zones
     $             ,' Available number maxznbc1=', maxznbc1
              write(66,*) ' Increase maxznbc1 and recompile'
              stop
           endif
          do 370 i=1,nbc1_zones
            read(nfileid,*) iconbc1(i)
cws            write(66,*) 'iconbc1',iconbc1(i)
            if (.not.iconbc1(i)) then
              read(nfileid,*) nbc1_conc(i)
              do 357 isp=1,nsp
                do 360 iconc=1,nbc1_conc(i)
                  read(nfileid,*) conc_bc1(i,iconc,isp),
     &				ton_bc1(i,iconc,isp),toff_bc1(i,iconc,isp)
  360           continue
  357         continue
            else
              nbc1_conc(i)=1
              read(nfileid,*) ton_bc1(i,1,1),toff_bc1(i,1,1)
              do 363 isp=2,nsp
                ton_bc1(i,1,isp)=ton_bc1(i,1,1)
                toff_bc1(i,1,isp)=toff_bc1(i,1,1)
  363         continue
            end if
            read(nfileid,*) nbc1(i)
            read(nfileid,*) (node_bc1(inbc1),inbc1=nbc1tot+1,
     &                 nbc1tot+nbc1(i))
            do 365 inbc1=nbc1tot+1,nbc1tot+nbc1(i)
              icc(node_bc1(inbc1))=1
  365       continue
            nbc1tot=nbc1tot+nbc1(i)
  370     continue
        elseif(use_coord) then
c
c     If use_coord is true, then read
c     nzones: number of different zones
c     for each zone read:
c     -------------------
c      iconbc1, if true, initial concentration is the fixed
c                  concentration, must specify time interval
c               if false, must specify the following
c        nbc1_conc : number of different time interval
c        concentration, ton, toff

c      range of coordinates (x,y,z) having imposed head equal to value
c        (xfrom,xto,yfrom,yto,zfrom,zto)
c
           read(nfileid,*) nbc1_zones
           if (nbc1_zones.gt.maxznbc1) then
              write(66,*) ' Required number of zones : ',nbc1_zones
     $             ,' Available number maxznbc1=', maxznbc1
              write(66,*) ' Increase maxznbc1 and recompile'
              stop
           endif
          nbc1tot=0
          ilast=0
          do 390 i=1,nbc1_zones
c
c  ...Read zone limits check where dirichlet nodes are located
c   
            read(nfileid,*) iconbc1(i)
            if(.not.iconbc1(i)) then
              read(nfileid,*) nbc1_conc(i)

ccc        write(66,*) 'nbc1_conc(i) is: ',nbc1_conc(i)
              do 380 isp=1,nsp

                do 377 iconc=1,nbc1_conc(i)
                  read(nfileid,*) conc_bc1(i,iconc,isp),
     &                ton_bc1(i,iconc,isp),toff_bc1(i,iconc,isp)
  377           continue
  380         continue
              iflag=2
            else
              nbc1_conc(i)=1
              read(nfileid,*) ton_bc1(i,1,1),toff_bc1(i,1,1)
c              if(lchem.gt.0) then
              do 383 isp=2,nsp
                ton_bc1(i,1,isp)=ton_bc1(i,1,1)
                toff_bc1(i,1,isp)=toff_bc1(i,1,1)
  383         continue
c              end if
            end if

            read(nfileid,*) xfrom_nod,xto_nod,yfrom_nod,yto_nod,
     &                 zfrom_nod,zto_nod
            call fnodes(ilast,iend,nident,maxnn,iflag,
     $        xfrom_nod,xto_nod,yfrom_nod,yto_nod,zfrom_nod,zto_nod)
            if(iend.gt.maxnn) then
              write(66,6637) iend,maxnn
              write(*,6637) iend,maxnn
 6637         format(//,80('*'),/,'ERROR when assigning dirichlet ',
     &        'nodes for transport',/,'The number of dirichlet nodes ',
     &        'is ',i8,/,'The dimension of nident is maxnn = ',i8,
     &        /,'increase the value of maxnn and recompile')
              stop
            end if
            nbc1(i)=0
            do 385 nnode=ilast+1,iend
              node_found=nident(nnode)
              if(icc(node_found).le.0) then
                nbc1tot=nbc1tot+1
                nbc1(i)=nbc1(i) + 1
                node_bc1(nbc1tot)=node_found
                icc(node_found)=1
              end if
  385       continue
            ilast=iend
  390     continue
        end if
c
c  ...Echo back
c
        ncount=0
        do 410 i=1,nbc1_zones
           if(.not.iconbc1(i)) then
            write(66,6110) i,nbc1_conc(i)
            do 404 isp=1,nsp
c              if (iabs(phase(isp)).eq.1) then
              write(66,6109) spname(isp)
              do 400 iconc=1,nbc1_conc(i)
                write(66,6112) iconc,conc_bc1(i,iconc,isp),
     &          ton_bc1(i,iconc,isp),toff_bc1(i,iconc,isp)
  400         continue
c              endif
  404       continue
          else
            write(66,6113) i,ton_bc1(i,1,1),toff_bc1(i,1,1)
          end if
          write(66,6114) i,nbc1(i)
          write(66,6116) (node_bc1(inbc1),inbc1=ncount+1,
     &     ncount+nbc1(i))
          ncount=ncount+nbc1(i)
  410   continue
 6110   format(/,'  Dirichlet zone:',i4,/,2x,19('-'),
     &  /'  Number of different concentration intervals:',i8)
 6109   format(/,'**** Species: ',a20,' ****')
 6112   format('  Conc. interv',7x,'concentration',6x,
     &  'time-on',9x,'time-off',/,7x,i2,9x,3(1x,d15.8))
 6113   format(/,'  Dirichlet zone:',i4,/,2x,19('-'),/
     &  /'  The initial concentrations given for the nodes located',
     &  /,'  in this zone represent the fixed concentration from:',/,
     &  '  Time-on: ',d15.8,'  to time-off: ',d15.8)
 6114   format(/,'    Number of dirichlet nodes for zone(',i2,')=',i4,
     &  /,'    Nodes',/,4x,5('-'))
 6116   format(11(1x,i6))
          
        write(66,6120) nbc1tot
 6120   format(/,'  Total number of first-type nodes for',
     &   ' transport:',i6)
      end if
      close (99)
c************************************************************************
c     Group 18: Third-type boundary conditions for transport
c************************************************************************

c
c     For each element having a face with a third-type boundary,
c     read the element number, the face number, the normal Darcy influx
c     impinging on the face and the concentration. The convention for
c     numbering faces is given in the comment statements near the
c     beginning of the code. If an element has more than one face that
c     is of the third-type boundary condition, then repeat the element
c     number, face number, flux and concentration for each third-type face.
c
c     The boundary defaults to a second-type with zero normal gradient
c     when neither 1st or 3rd types are specified
c
      write(*,*) ' Reading GROUP 18'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 18'
         stop
      endif
      write(66,6128)
 6128 format(//44('*')/,'Third-type boundary conditions for ',
     &       'transport',/,44('*'))
c
c  ...Initialise flag for third-type nodes
c     (that are not first-type)
c
      do 430 i=1,nn
        type3(i)=.false.
  430 continue
      nbc3tot=0
      read(55,*) cauchy_bc
      if(.not.cauchy_bc) write(66,6135)
 6135 format('No third-type element faces ')
c
c  ...First read use_coord
c                =false, input each 2nd type element face separately
c                -true , input zone(s) for 2nd type element faces
c                        defining the extent of the zone with coordinates
c                    
      if(.not.cauchy_bc) then
        nbc3tot=0
       elseif(cauchy_bc) then
        if(nln.eq.6) then
          write(66,*) '*** WARNING ***'
          write(66,*) 'the program does not handle third-type'
          write(66,*) 'boundary conditions for prisms'
          write(66,*) 'Problems when flux is determined'
          write(66,*) 'program stopped'
          stop
        end if
c
c  ...First read kzone
c      =0 , input each 3rd type element face separatly
c      =1 , input zones for 3rd type element faces
c
        read(55,*) use_coord

cws   dec. 1998
c     ...read boundary_file
c     =false : input read from standard inputfile name.in
c     nfileid = 55
c     =true  : input read from special file name.3tt
c     nfileid = 99

        read(55,*) boundary_file
        if(.not.boundary_file) nfileid=55
        if(boundary_file) then 
           nfileid=99
           open(unit=99,file=prefix(:lenprefix)//name(:lenname)//'.3tt',
     &          status='unknown')
        endif
cws   Dec. 1998
cws
        if(.not.use_coord) then
          read(nfileid,*) nbc3_zones
cws   June 2001
cws   Possibility for input of species associated with 2nd type fluxes 
cws    in a element by element mode
	    read(nfileid,*) element_wise
cws   element_wise=false: input in zones 
cws   element_wise=true: input element by element
cws   June 2001
          if (nbc3_zones.gt.maxznbc3) then
             write(66,*) ' Required number of zones : ',nbc3_zones
     $            ,' Available number maxznbc1=', maxznbc3
             write(66,*) ' Increase maxznbc3 and recompile'
             stop
          endif
          nbc3tot=0
cws    June 2001
          if(element_wise) then
            do 454 i=1,nbc3_zones
cws           only one time interval is possible
              iconc=1
              nbc3_conc(i)=1
cws           number of elements in zone is always 1
              nbc3(i)=1
cws           always use specified fluxes from group 8
              giveflux(i)=.true.
cws           never use initial conditions from group 16
              iconbc3(i)=.false.
              read(nfileid,*) iel_bc3(i),iface_bc3(i),
     &                        (conc_bc3(i,iconc,isp),isp=1,nsp)
              do 455 isp=1,nsp
                ton_bc3(i,iconc,isp)=0.
                toff_bc3(i,iconc,isp)=1.e20
  455         continue
            nbc3tot=nbc3tot+1
  454       continue


cws         June 2001
cws         input in zones:
	     else
            do 450 i=1,nbc3_zones
              read(nfileid,*) giveflux(i)
cws           change Jan. 1999
cws              if(giveflux(i)) read(nfileid,*) fnormbc3(i)
              read(nfileid,*) iface_bc3(i)
              read(nfileid,*) iconbc3(i)
              if(.not.iconbc3(i)) then
                read(nfileid,*) nbc3_conc(i)
                do 442 isp=1,nsp
                  do 440 iconc=1,nbc3_conc(i)
                    read(nfileid,*) conc_bc3(i,iconc,isp),
     &               ton_bc3(i,iconc,isp),toff_bc3(i,iconc,isp)
  440             continue
  442           continue
               else
                nbc3_conc(i)=1
                read(nfileid,*) ton_bc3(i,1,1),toff_bc3(i,1,1)
c                if(lchem.gt.0) then
                  do 452 isp=2,nsp
                    ton_bc3(i,1,isp)=ton_bc3(i,1,1)
                    toff_bc3(i,1,isp)=toff_bc3(i,1,1)
  452             continue
c                end if
              end if
              read(nfileid,*) nbc3(i)
              read(nfileid,*) (iel_bc3(ibc3),ibc3=nbc3tot+1,
     &          nbc3tot+nbc3(i))
              nbc3tot=nbc3tot+nbc3(i)
  450       continue
cws      june 2001: endif for element_wise
          endif
        elseif(use_coord) then
          nbc3tot=0
          ncount=0
          ncountold=0
          read(nfileid,*) nbc3_zones
          if (nbc3_zones.gt.maxznbc3) then
             write(66,*) ' Required number of zones : ',nbc3_zones
     $            ,' Available number maxznbc1=', maxznbc3
             write(66,*) ' Increase maxznbc3 and recompile'
             write(*,*) ' Required number of zones : ',nbc3_zones
     $            ,' Available number maxznbc1=', maxznbc3
             write(*,*) ' Increase maxznbc3 and recompile'
             stop
          endif

          do 460 izone=1,nbc3_zones
            call fbc3(izone,ncount)
            nbc3tot=nbc3tot+ncount-ncountold
            ncountold=ncount
  460     continue
        end if
c
c  ...Flag third-type nodes
c
        ndummy=0
        do 470 i=1,nbc3_zones
          nface=iface_bc3(i)
          ncount=4
          if(nln.eq.6) then
            if(nface.eq.1.or.nface.eq.2) ncount=3
          end if
          do 468 j=1,nbc3(i)
            ndummy=ndummy+1
            ielem=iel_bc3(ndummy)
            do 466 ik=1,ncount
              node=in(iface(nface,ik,1),ielem)
              if(icc(node).eq.0) type3(node)=.true.
  466       continue
  468     continue
  470   continue
c
c  ...Echo back
c
        ncount=0
cws     june 2001
cws     modified output for elementwise input
        if(element_wise) then
          write(66,6160)
cws          if (iabs(phase(isp)).eq.1) then
            write(66,6161) (spname(isp),isp=1,nsp)
            do 480 i=1,nbc3_zones
            write(66,6162) iel_bc3(i),(conc_bc3(i,1,isp),isp=1,nsp)
  480       continue
cws          endif
         else
          do 481 i=1,nbc3_zones
            write(66,6140) i
            if(giveflux(i)) then
              write(66,6153)
             else
              write(66,6154)
            end if
            if(.not.iconbc3(i)) then
              do 477 isp=1,nsp
c                if (iabs(phase(isp)).eq.1) then
                  write(66,6109) spname(isp)
                  do 475 iconc=1,nbc3_conc(i)
                    write(66,6142) iconc,iface_bc3(i),
     &                conc_bc3(i,iconc,isp),ton_bc3(i,iconc,isp),
     &                toff_bc3(i,iconc,isp)
  475             continue
c                endif
  477         continue
            else
              write(66,6143) i,iface_bc3(i),
     &          ton_bc3(i,1,1),toff_bc3(i,1,1)
            end if
            write(66,6144) i,nbc3(i)
            write(66,6146) (iel_bc3(ibc3),ibc3=ncount+1,
     &        ncount+nbc3(i))
cws   Juni 2002
	    ncount = ncount + nbc3(i)
cws   Juni 2001
  481   continue
        endif
 6140   format(/,'Third-type zone:',i4,/,23('-'))
 6142   format('Interval',1x,'face',13x,
     &  'concentration',9x,
     &  'time-on',8x,'time-off',/,6x,i2,i5,10x,3(1x,d15.8)) 
 6143   format(/,'Interval ',i2,' face ',i2,/,
     &  '  The initial concentrations given for the nodes located',
     &  /,'  in this zone represent the 3rd-type concentration from:'
     & ,/,'  Time-on: ',d15.8,'  to time-off: ',d15.8)
 6144   format(/,'Number of third-type faces for zone(',i2,') :',i4,
     &  /,'Elements included in the zone',/,30('-'))
 6146   format(11(1x,i6))
cws Jan 1999  6153   format(' User-specified INCOMING fluid flux for the zone: ',
cws     &  d12.5)
 6153   format(' The incoming fluid flux for this zone is ',
     &   'the 2nd type boundary flux specified in group 8')
 6154   format(' The incoming fluid flux for this zone is ',
     &   'computed from the elemental Darcy fluxes')

        write(66,6148) nbc3tot
 6148   format(/,'Total number of third-type faces:',i6,/)
 6160   format(/,'Elementwise input ', 
     &           'of 3rd type boundary conditions for transport')
 6161   format(/,'  Element',/,'  number',4x,20a15)
 6162   format(1x,i6,20d15.4)
      endif
      close(99)

c************************************************************************
c   Group 19: Concentration at the injection wells
c************************************************************************

c
c   This group is for entering the concentration of the solute at the
c   injection wells.
c   Input data for concentration at injection wells
c   only if the concentration is different from zero
c
      write(66,6203)
 6203 format (32('*'),/,'Concentration at injection wells',/,32('*')/)
      write(*,*) ' Reading GROUP 19'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 19'
         stop
      endif
      read(55,*) injwell
      if(injwell) then
        do 1226 i=1,nwell
          do 1224 j=1,nsp
            ninjc(i,j)=0
 1224     continue
 1226   continue
        read(55,*) ninjwell
          if (ninjwell.gt.maxwell) then
             write(66,*) ' Required number of wells : ',ninjwell
     $            ,' Available number maxwell=', maxwell
             write(66,*) ' Increase maxwell and recompile'
             stop
          endif

        do 1240 i=1,ninjwell
          read(55,*) iwellid(i)
          iw=iwellid(i)
          if (iw.lt.0.or.iw.gt.nwell) then
             write(66,*) ' Well index out of range: ',iw
             stop
          endif
          if(flowrate(iw).lt.0.0d0) then
            write(*,*) '!!! ERROR !!! (see .out file)'
            write(66,*) '!!! ERROR !!!'
            write(66,*) ' Well ',iw,' for assigning injection',
     &       ' concentration is really a pumping well'
            stop
          end if
          write(66,*) 'WELL: ',iw

          do 10238 j=1,nsp
             ninjc(iw,j)=1
             cinjc(iw,j,1)=0.0
             toninjc(iw,j,k)=0.0
             toffinjc(iw,j,1)=1e10
             injswitch(iw,j)=.false.
10238     continue

          read(55,*) ninjspec
          do 10244 j=1,ninjspec
             read(55,*) ninjspnr
             read(55,*) ninjc(iw,ninjspnr)
             if (ninjc(iw,ninjspnr).gt.0) then
                do 10236 k=1,ninjc(iw,ninjspnr)
c                   read(55,*) cinjc(iw,ninjspnr,k),toninjc(iw,ninjspnr,k
c     $                  ),toffinjc(iw,ninjspnr,k),injswitch(iw,ninjspnr)
                   read(55,*) cinjc(iw,ninjspnr,k),toninjc(iw,ninjspnr,k
     $                  ),toffinjc(iw,ninjspnr,k)


10236           continue
             endif
10244     continue

          do 1238 j=1,nsp
            write(66,6329) j,spname(j)
c            read(55,*) ninjc(iw,j)
            if (ninjc(iw,j).gt.0) then
              write(66,6367)
              do 1236 k=1,ninjc(iw,j)
c                 injswitch(iw,j)=.false.
c                 read(55,*)cinjc(iw,j,k),toninjc(iw,j,k),toffinjc(iw,j,k
c     $                ),injswitch(iw,j)
c                 read(55,*)cinjc(iw,j,k),toninjc(iw,j,k),toffinjc(iw,j,k
c     $                )
                 write(66,6334) k,cinjc(iw,j,k),toninjc(iw,j,k),
     &                toffinjc(iw,j,k)
                if(injswitch(iw,j)) write(66,*)
     $               'Wellconcentration will be updated. '
 1236         continue
            endif
 1238     continue
 1240   continue
 6329   format('  SPECIES ',i2,1x,a20)
 6367   format('  Interval',8x,'Conc',6x,'Time-on',5x,'Time-off')
 6334   format(6x,i2,1x,3(1x,1pd12.5))
      else
        write(66,'(a)') 'No given concentrations at injection wells'
      end if



c************************************************************************
c     Group 20: ORTHOMIN solver and time data for transport
c************************************************************************

c
c  ...Read error parameter for ORTHOMIN iterative solution algorithm (eps)
c     resid_errc is the criterion for the residual error
c     relat_errc is the criterion for the relative error
c     absol_errc is the criterion for the absolute error
c     ORTHOMIN stops when either one is satisfied. if only want criterion
c     is to be controlling the iterative process, just set the other
c     two to very small values
c
c     Recommend using:
c        relat_errc = 1.e-4 to 1.e-6 (smaller the better, but
c                 smaller values take more execution time)
c
c     twc: time weighting
c
c  ...Note that same time step values as the one provided in flow are
c     used for transport
c     istep: =0 time values provided
c               if different from zero, generate the nts time values
c            =1 constant time step supplied, tmin and tmax
c                                time values are generated
c            =2 variable time step,  enter the following:
c                     tmin:  initial time value
c                     delta: initial time step;
c                     tinc:  time step multiplier
c               time values are then generated
c
c     If restarting from previous head values, the initial time
c     has been read in trestar.
c
      write(*,*) ' Reading GROUP 20'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 20'
         stop
      endif
      read(55,*) resid_errc,relat_errc,absol_errc
      read(55,*) isolv_infoc
      write(66,6080) resid_errc,relat_errc,absol_errc
 6080 format (//,33('*'),/'ORTHOMIN parameters for transport'/
     1,33('*'),//,'Residual error: ',d12.5/
     1 ,'Relative error: ',d12.5/
     1 ,'Absolute error: ',d12.5)

c
c  ...If steady-state flow is simulated, read the time specifications
c     for transient transport here.
c
      if(steady_state) then
        read(55,*) nts
c  ...Check dimensions
        if(nts.gt.maxnt) then
          write(66,*) 'Dimensioning ERROR'
          write(66,*) ' nts=',nts,' maxnt=',maxnt
          write(66,*) ' Increase maxnt and recompile'
          write(*,*) 'Dimensioning ERROR'
          write(*,*) ' nts=',nts,' maxnt=',maxnt
          write(*,*) ' Increase maxnt and recompile'
          stop
        end if
        read(55,*) istep
        if(istep.eq.0) then
          read(55,*) (target_time(i),i=1,nts)
          delta=target_time(1)
          if(krestar.eq.1) delta=target_time(1)-trestar
        else
          if(istep.eq.1) then
            read(55,*) tmin, delta
            tinc=1.0d0
            dtmax=delta
          elseif(istep.eq.2) then
            read(55,*) tmin, delta, tinc, dtmax
          end if
c
c  ...generate the time values if necessary (istep.ne.0)
c
          target_time(1)=tmin+delta
          if(krestar.eq.1) target_time(1)=trestar+delta
          deltan=delta
          do 340 i=1,nts-1
            deltan=deltan*tinc
            if(deltan.gt.dtmax) deltan=dtmax
            target_time(i+1)=target_time(i)+deltan
  340     continue
        end if
      end if
      read(55,*) twc,pectol,courtol
      if(time_step_control) then
        if(steady_state) then
          read(55,*) delta
          t(1)=delta
        end if
        read(55,*) control_conc
        read(55,*) dconc_allowed
        if(.not.control_head.and..not.control_conc) then
         write(66,*) 'ERROR for time step control'
         write(*,*) 'ERROR for time step control, see output file'
         write(66,*) 'Controls for head and concentration'
         write(66,*) 'are all false. At least one of them must be true'
         stop
        end if
      end if
      twmin=1.d0-twc
      twratioc=-1.0d0*twmin/twc
c
c  ...Write some info to unit 41.
c
      if(steady_state.and.kpconc.gt.0) then
        write(41) nts,kpconc,(target_time(i),i=1,nts)
c        write(81,*) nts,kpconc,(target_time(i),i=1,nts)
      end if
c
c  ...Echo back time values for transport
c
      if(steady_state) then
        write(66,6090)
 6090   format(//22('*')/,'Simulation time values',/,22('*'),/)
        write(66,6095) nts
 6095   format('Number of time steps:',i5,/)
csdsd        write(66,6096) (target_time(i),i=1,nts)
csdsd 6096   format(5(d12.6,2x))
        write(66,2546) target_time(1), target_time(nts),delta
 2546   format('First time step:', d12.6,/,
     &         'Last  time step:', d12.6,/,
     &         'Delta T        :', d16.6)
      end if
      write(66,2394) twc,pectol,courtol
 2394 format(/,'Time-weighting factor:',t40,f5.2,/,
     & 'Maximum peclet number for checking:',t40,f5.2,/,
     & 'Maximum courant number for checking:',t40,f5.2)
      if(time_step_control.and.control_conc) then
        write(66,6645) dconc_allowed
      end if
 6645 format(/'Time step control (above values are target times)',/,
     & 'Maximum desired change in concentration:',f10.5)
c
c ... Read upstream weighting option
c
      read(55,*) upstrvel
      if(upstrvel) then
        read(55,*) almax,betmax,gammax
        write(66,6340) almax,betmax,gammax
 6340   format(/'Upstream weighting of velocities',//,
     &  'almax (x-direction):',t25,f6.2,/
     &  'betmax (y-direction):',t25,f6.2,/
     &  'gammax (z-direction):',t25,f6.2)
      else
        read(55,10) grtitle
        almax=0.0d0
        betmax=0.0d0
        gammax=0.0d0
        write(66,6343)
 6343   format(/'No upstream weighting of velocities',/)
      end if

c************************************************************************
c   Group 21: Biochemical model data
c************************************************************************

      write(*,*) ' Reading GROUP 21'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 21'
         stop
      endif
      write(66,4356)
 4356 format(//,37('*'),/,' Parameters of biochemical reactions',/,
     &          37('*'),/)

      call nit0(delta)
c
c  ...Assign porosity factor depending on species
c
      do 260 isp=1,nsp
        ip=iabs(phase(isp))
        porfac(isp)=volume(ip)
260   continue

c************************************************************************
c   Group 22: Equilibrium Cehmistry
c************************************************************************


      call readchem(nn,krestarc)


c************************************************************************
c   Group 23: Kinetical chemistry
c************************************************************************

      write(*,*) ' Reading GROUP 23'
      read(55,10) grtitle
      if (grtitle(1:1).ne.'*') then
         write(*,*) 'Error reading group title of group 23'
         stop
      endif
      call readkinet

c
c  ...compute index-array for y() in dgear
c
      call comp_index

c************************************************************************
c   Group 24: Output of nodal fluid, mass fluxes and concentration
c************************************************************************
c
c  ...Specify nodes at which the fluid and solute fluxes and
c     concentration are outputted at every time step.
c
c       write(*,*) ' Reading GROUP 24'
c       read(55,10) grtitle
c       write(66,6265)
c 6265  format(//41('*')/,'Output of Nodal Fluxes and Concentrations',/,
c     &      41('*'),/)
c       read(55,*) outfc
c       if(.not.outfc) then
c          noutfc=0
c          write(66,*) ' No output of nodal fluxes and concentrations'
c       else
c          open(unit=62,file=prefix(:lenprefix)//name(:lenname)//'o.flu',
c     &         status='unknown')
c          rewind(62)
c          mass_balance=.true.
c          mass_balancec=.true.
c          read(55,*) noutfc
c          read(55,*) (ioutfc(i),i=1,noutfc)
c          write(66,6267) noutfc
c 6267     format('Number of nodes for output:',i6,/,'List of nodes:')
c          write(66,6269) (ioutfc(i),i=1,noutfc)
c 6269     format(10i7)
c       end if
       outfc = .false.
       noutfc = 0

c************************************************************************
c     End of data input for transport
c************************************************************************

c 
c  ...If mass balance is required flag the boundary nodes
c
      do 520 i=1,nn
        bound(i)=.false.
  520 continue

      if(nln.eq.8) then
c
c  ...Bottom of domain (i.e. first xy-level)
c
      do 525 i=1,nndsl
         bound(i)=.true.
  525 continue
c
c  ...Top of domain (i.e. last xy-level)
c
      istart=nndsl*(nz-1) + 1
      iend=nn
      do 530 i=istart,iend
        bound(i)=.true.
  530 continue
c
c  ...Left of domain (i.e. the vertical section at x(1))
c
      istart=1
      iend=nn-nx+1
      do 540 i=istart,iend,nx
        bound(i)=.true.
  540 continue
c
c  ...Right of domain (i.e. the vertical section at x(nx))
c
      istart=nx
      iend=nn
      do 545 i=istart,iend,nx
        bound(i)=.true.
  545 continue
c
c  ...Front of domain (i.e. the vertical section at y(1))
c
      do 555 i=1,nz
         istart=(i-1)*nndsl+1
         iend=istart+nx-1
         do 550 j=istart,iend
            bound(j)=.true.
 550     continue
 555  continue
c
c  ...Back of domain (i.e. the vertical section at y(ny))
c
      nndslb=nx*(ny-1)
      do 565 i=1,nz
        istart=(i-1)*nndsl+nndslb+1
        iend=istart+nx-1
        do 560 j=istart,iend
          bound(j)=.true.
  560   continue
  565 continue
      end if

      return
      end

c************************************************************************

      subroutine plastcon(ntloop)

c************************************************************************
c
c  ...Print concentrations for last time if required
c
c************************************************************************
      include 'tbc.prm'
      include 'tbc.dim'

      common /chemanz/ ncspec,nckomp,ncequa,nkspec
      integer*4        ncspec,nckomp,ncequa,nkspec

      common /chemextern/ rconst0,dh0,t0,chemc,compcomp,bspeccomp,
     &                    conversion,
     &                    areac,disspec,compchem,cname,kname
      double precision rconst0(maxcequa),dh0(maxcequa),t0(maxcequa),
     &                 chemc(maxnn*maxcspec),compcomp(maxckomp,maxsp),
     &                 bspeccomp(maxsp,maxcspec),conversion
      integer*4 areac(maxcequa,maxcspec),disspec(maxcequa)
      character*20  cname(maxcspec),kname(maxckomp)
      logical compchem

      do 7500 i=1,nn
        cc=ctemp(i)
        ctemp(i)=cu(i)
        cu(i)=cc
 7500 continue

      write(51) t(ntloop)
      write(51) nsp
      do 9078 i=1,nsp
         write(51) spname(i)
         write(51) ioutspec(i)
        write(51) phase(i),exspec(i),exchc(i),cmolfac(i)
        if (iabs(phase(i)).eq.3) then
           write(51) dblkd(i)
        elseif (iabs(phase(i)).eq.4) then
          write(51) csatmax(i)/conversion
        endif
        write (51) clambda(i)
        write(51) (cu(j),j=(i-1)*nn+1,i*nn)
9078  continue

      do 9079 i=1,ncspec
         write(51) (chemc(j),j=(i-1)*nn+1,i*nn)
 9079 continue

      do 7700 i=1,nn
        cc=cu(i)
        cu(i)=ctemp(i)
        ctemp(i)=cc
 7700 continue

      return
      end

c************************************************************************

      subroutine driver_trans(ntloop,prefix,lenprefix)

c************************************************************************
c
c  ...Call subroutines to solve for mobile and immobile transport
c     Check convergence of the iterative two-step solution method
c
c************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'

      dimension cexch(maxnn*maxsp),cweight(maxsp+maxcspec)
     $     ,aver_conc(maxsp)
      double precision help(maxnn*maxsp)
      logical mflag,output

      common /control/ tolex, maxiter
      character*100 prefix,fname

      common /chemanz/ ncspec,nckomp,ncequa,nkspec
      integer*4        ncspec,nckomp,ncequa,nkspec

      common /chemextern/ rconst0,dh0,t0,chemc,compcomp,bspeccomp,
     &                    conversion,
     &                    areac,disspec,compchem,cname,kname
      double precision rconst0(maxcequa),dh0(maxcequa),t0(maxcequa),
     &                 chemc(maxnn*maxcspec),compcomp(maxckomp,maxsp),
     &                 bspeccomp(maxsp,maxcspec),conversion
      integer*4 areac(maxcequa,maxcspec),disspec(maxcequa),kout(maxsp
     $     +maxcspec)

      character*20  cname(maxcspec),kname(maxckomp)
      logical compchem

      common /kinetchem/ rckin0,rckin,stoech,cxalt,dt,reack,
     &                   kinetspec,kkomp,idepend
      double precision rckin0(maxkspec,maxkreac),
     &                  rckin(maxkspec,maxkreac),dt,
     &     stoech(maxkspec,maxckomp),cxalt(maxkspec),
     6     reack(maxkspec,maxcspec,maxkreac)
      integer kinetspec(maxkspec),
     &        kkomp(maxkspec),idepend(maxkspec)

      common /logconstants/ dln10,dln1em60m1
      double precision dln10,dln1em60m1

 

      firstiter=.true.
      dsmall=1.0d-6
      nntemp = nn
      ttemp = t(ntloop)
      dttemp = delta
      write(66,6000) t(ntloop),delta
      write(*,6001) t(ntloop),delta
 6000 format(/,/,67('*'),/,' Transport simulation, Time: ',g12.6,
     & '   Time-Step: ',g12.6,/,67('*'))
 6001 format(' Transport simulation, Time: ',g12.6,
     & '   Time-Step: ',g12.6)

      do 60 i=1,maxsp*maxnn
         cexch(i)=0.0d0
         help(i)=0.0d0
         cu(i)=cic(i)
 60   continue

c
c  ... Solve the transport equation for the non-reactive mobile species (TRACER)
c
      do 111 isp=1,nsp
        if (phase(isp).eq.-1) then
          call solve_trans(ntloop,isp,cexch)
        endif
 111  continue

c
c  ... For immobile species, compute initial mass in system
c
      if((ntloop.eq.1).and.mass_balance) then
        write(65,9348) 0.d0
 9348   format(/,' Chemical Mass Balance TIME : ',g12.6,/,42('-'))

        mflag=.true.
        do 385 isp=1,nsp
          if (phase(isp).gt.1) then
            dmassi(isp)=0.0d0
            output=.true.
            call compmass(ntloop,isp,mflag,output)
            write(65,6637) spname(isp)
 6637       format('Initial mass for ',a20)
            write(65,6647) dmassi(isp)
 6647       format(' Total mass at time 0 in system ',t50,
     &           g15.8)

          endif
  385   continue
      end if

c
c  ... Start the iterative loop for reactive species
c
      if ((ngl.gt.0).or.compchem) then

c  ... reactive species present

         ikount=0

c  ... loop for iteration ikount
 155     continue

         ikount=ikount+1

c
c  ...Solve the transport equation for the mobile bio-reactive species
c     and compute cexch() and sctr (error)

         sccexa=0.0d0
         sctr=0.0d0
         
         do 100 isp=1,nsp
            if (phase(isp).eq.1) then
c
c  ...Compute the change in concentration caused by transport
c     of the mobile reactive species
c
               call solve_trans(ntloop,isp,cexch)
               do 110 i=(isp-1)*nn+1,isp*nn
                  sccexa=sccexa+dabs(cexch(i))
                  cexch(i) = cu(i)-cic(i)-cexch(i)
                  sctr = sctr + dabs(cexch(i))
 110           continue
            endif
 100     continue

c
c ... Convert concentrations in transport to [mol/l] and time to [d]
c
          do 8745 i=1,nn*nsp
            cexch(i)=cexch(i)*conversion
            cu(i)   =cu(i)*conversion             
c            if (cu(i).lt.0.0) cu(i)=1.d-40
            cic(i)=cic(i)*conversion
8745      continue


c
c  ...Solve the biological reactions for the reactive species
c
          if(ngl.gt.0)then
             call nit1(cexch,nntemp,ttemp,dttemp)

             firstiter=.false.
          endif

c
c  ...Solve the chemical equilibrium reactions for the reactive species
c
          if (compchem) then
             dt=delta
             call chemistry (nn,cu)
          endif

          do 3745 i=1,nn*nsp
             cexch(i)=cexch(i)/conversion
             cu(i)   =cu(i)/conversion
             cic(i)=cic(i)/conversion
 3745     continue

c  WS forget convergence problems
c
c  ...If convergence problems in the transport-chemistry iteration
c
c          if(igoto.ge.9) then
c            if(igoto.ge.istop) then
c              write(66,*) ' igoto is: ', igoto
c              write(66,*) ' Program stopped after ',ikount,
c     &                    ' iterations'
c              stop
c            end if
c            if(ikount.lt.maxiter) then
c              write(66,*) '### New estimate for CEXCH ###'
c              do 186 isp=1,nsp
c                if (phase(isp).eq.1) then
c                  do 185 i=(isp-1)*nn+1,isp*nn
c                    cexch(i)=help(i)*0.5d0
c                    help(i)=cexch(i)
c  185             continue
c                endif
c  186         continue
c            goto 155
c            elseif(ikount.ge.maxiter) then
c              write(66,*) '### CEXCH is set to ZERO ###'
c              do 187 i=1,nsp*nn
c                cexch(i)=0.0d0
c                help(i)=0.0d0
c  187         continue
c            goto 155
c            end if
c          end if
c
c     end of loop 155

c
c  ...Compute the change in concentration caused by the biological
c     reactions for the reactive mobile species (biological+chemicalTOT)
c
          erre=0.0d0
          sccex=0.0d0
          do 141 isp=1,nsp
             if (phase(isp).eq.1) then
                do 140 i=(isp-1)*nn+1,isp*nn
                   cexch(i) = cu(i)-cic(i)-cexch(i)
                   sccex = sccex + dabs(cexch(i))
                   erre  = erre  + dabs(cexch(i)-help(i))
 140            continue
             endif
 141      continue


c
c  ...Check convergence of the two-step iterative process
c
          if(erre.gt.tolex) then
             if(ikount.ge.maxiter) then
                write(66,6010) ikount, erre
                write(*,6010) ikount, erre
             else
                write(66,896) ikount,erre,sccexa,sctr,sccex
 896            format(/,'   Transport-chemistry iteration count: ',
     &               i4,', Error: ',d12.5, /,'   sccexa: ',d12.5,
     &               ', sctr: ',d12.5,', sccex: ',d12.5)
                do 189 i=1,nsp*nn
                   help(i)=cexch(i)
 189            continue
                goto 155
             end if
          else
             write(66,6005) ikount,erre
          end if

 6005     format(' Two-step procedure, convergence at iteration:'
     &         ,i3,', Error: ',d12.5,/)
 6010     format(' Two step procedure, no convergence after '
     &         ,i4,' iterations, Error: ',d12.5,/)

c endif ngl>0 or compchem
       endif


c
c  ...Output flux averaged concentration at the well(s)
c     for the mobile species

       if(nwell.gt.0) then

c     **** output of the flux averaged concentrations at the well(s)
c     for the mobile and selcted species to file 'prefixo.wco' ****

c          do 350 isp2=1,nsp
c             if (iabs(phase(isp2)).eq.1) then
c                istart2 = (isp2-1)*nn
c                     write(61,6100) t(ntloop),spname(isp2)
c 6100           format('Time: ',d12.5,' Species: ',a20)
c                ncount=0
c                gesflux=0
c                gesconc=0
c                do 325 i=1,nwell
c                   sumconc=0.0d0
c                   sumflux=0.0d0
c                   write(61,*) 'Well:',i,' Well nodes:',nn_well(i)
c                   do 300 j=1,nn_well(i)
c                      ncount=ncount+1
c                      node=jq(i,j)
c                      sumflux=sumflux + gbwellmb(ncount)
c                      sumconc=sumconc + gbwellmb(ncount)*cu(istart2+node
c     $                     )
c 300               continue
c                   if (sumflux.lt.0.0) gesflux=gesflux+sumflux
c                   if (sumflux.lt.0.0) gesconc=gesconc+sumconc
c                   fluxa_conc=sumconc/sumflux
c                   write(61,6120) i,fluxa_conc
c                   write(61,'(i5,5x,a10,2e15.6)') i,spname(isp2),
c     &                  t(ntloop),fluxa_conc
c                   
c                   write(61,*) i, spname(isp2), t(ntloop), fluxa_conc
c
c 6120              format(i5,2x,d15.8
c     $                  ,'  Well, Flux-averaged concentration')
c
c 325            continue
c
c                if (abs(gesflux).lt.1e-30) gesflux=1e-30 
c                gesconc=gesconc/gesflux
c                do 333 jwell=1,ninjwell
c                   if (injswitch(iwellid(jwell),isp2))
c     $                  cinjc(iwellid(jwell),isp2,1)=gesconc
c 333               continue
c
c                   
c             endif
c 350      continue


c     **** output of the flux averaged concentrations at the well(s)
c     for the mobile and selcted species to file 'prefixo.wec' ****

          ncount=0

          do 1300 i=1,nwell
             jjjmax=0

             do 1350 isp2=1,nsp
                if (iabs(phase(isp2)).eq.1.and.ioutspec(isp2).ne.0) then
                   jjjmax=jjjmax+1 
                   istart2 = (isp2-1)*nn
                   nncount=ncount
                   sumconc=0.0d0
                   sumflux=0.0d0
                   do 1400 j=1,nn_well(i)
                      nncount=nncount+1
                      node=jq(i,j)
                      sumflux=sumflux + gbwellmb(nncount)
                      sumconc=sumconc + gbwellmb(nncount)*cu(istart2
     $                     +node)
 1400              continue

                   aver_conc(jjjmax)=sumconc/sumflux

                endif 
 1350        continue

             write(92,'(i8,100(1x,e15.5))') i, t(ntloop),
     $            (aver_conc(jjj),jjj=1,jjjmax)

             
             ncount=ncount+nn_well(i)
             
 1300     continue

       end if
c
c  ...Output of concentrations in observation-wells
c
       if (obs_wells) then
          nxny=nx*ny
          do 494 i=1,nobsw
             sumdz=0.d0
             do 491 isp=1,nsp+ncspec
                cweight(isp)=0.d0
 491         continue
             
             do 493 j=1,nn_obsw(i)
                node=jobs(i,j)
                nodeup=node-nxny
                if (nodeup.lt.1) nodeup=node
                nodedown=node+nxny
                if (nodedown.gt.nn) nodedown=node
                dz=(z(nodedown)-z(nodeup))/2.d0
                sumdz=sumdz+dz
                
                do 492 isp=1,nsp
                   cweight(isp)=cweight(isp)+cu(node+(isp-1)*nn)*dz
 492            continue
                do 592 isp=1,ncspec
                   cweight(nsp+isp)=cweight(nsp+isp)+
     &                  chemc(node+(isp-1)*nn)*dz
 592            continue
                
                
 493         continue

             koutc=0             
             do 9999 k=1,nsp+ncspec
                if (ioutspec(k).ne.0) then
                   koutc=koutc+1
                   kout(koutc)=k
                endif
 9999        continue

             write(63,'(i8,100(1x,e15.5))') i,t(ntloop),
     &                  ((cweight(kout(kk))/sumdz),kk=1,koutc)

 494      continue
       endif

c
c  ...Compute mass balance if required
c
       output=.false.
       if(kpmasbc.gt.0) then
          temp2=dble(ntloop/kpmasbc)
          temp=dble(ntloop)/dble(kpmasbc)
          if (dabs(temp-temp2).lt.dsmall) output=.true.
       elseif (kpmasbc.lt.0) then
          output=.true.
       end if
       
       if(mass_balancec) then
c
c  ... Output chemical mass balance
c  ... Mass change
c
          if(output) write(65,9348) t(ntloop)

          mflag=.false.

          do 360 isp=1,nsp
c     ... compute mass of mobile species
             if (iabs(phase(isp)).eq.1) then
                call masbal_trans(time,ntloop,isp,cexch,output)
             else
c     ... compute mass of immobile species
                call compmass(ntloop,isp,mflag,output)
             endif
 360      continue
          
c     do 3948 isp=1,nsp
c     if (iabs(phase(isp)).eq.1) then
c     else
c     endif
c     do 9045 i=1,nsp
c     if (exspec(i).eq.isp) then
c     write(65,4560) spname(i),exchange
c     endif
c     9045      continue
c     5460    format(' Mass exchange from ',a15,' : ',g15.8)
c     3948    continue

       endif

c
c  ...Write results to unit 41 if required.
c
       do 400 isp=1,nsp
          if(kpconc.gt.0) then
             itemp=ntloop/kpconc
             temp2=dble(itemp)
             temp=dble(ntloop)/dble(kpconc)
             check=temp-temp2
          else
             check=dsmall*1.0d5
          end if
          istart=(isp-1)*nn + 1
          iend = isp*nn
          if(target_reached.or.(check.lt.dsmall)) then
             if(kpconc.gt.0) then
                write(41) t(ntloop),spname(isp)
                write(41) (cu(i),i=istart,iend)
c     if(echo_to_output) then
c              write(66,*) ' '
c              write(66,*) ' Nodal concentrations, ',spname(isp)
c              write(66,6635) (i,cu(istart-1+i),i=1,nn)
c            end if



             end if
          end if
 6635     format(4(4x,i5,3x,1p,d12.5,0p))
 400   continue


c
c write concentrations into file [time].coc
c dsds

       if(kwritedat.gt.0) then
          itemp=ntloop/kwritedat
          temp2=dble(itemp)
          temp=dble(ntloop)/dble(kwritedat)
          check=temp-temp2
          if(check.lt.dsmall) then
             call fltoas(ntloop,fname,lenfname)
             open(unit=64,file=prefix(:lenprefix)//
     &            fname(:lenfname),status='unknown')
             
             write(64,'(99(a15,1x))') ' Node          ',
     &                             ' X             ',
     &                             ' Y             ',
     &            ' Z             ',
     &            ' Hydraulic_Head ',
     &                             (spname(isp),isp=1,nsp),
     &                             (cname(isp),isp=1,ncspec),
     &                             ' Ionic_Strength'
             write(64,*) ' Time: ', t(ntloop)
csdsd
c     special fuer saeulenversuch, ausgabe injektionskonz.
c          do 3154 int=1,nbc3_conc(1)
c             timemin=ton_bc3(1,int,1)-dsmall
c             timeplus=toff_bc3(1,int,1)+dsmall
c             if(t(ntloop).gt.timemin.and.t(ntloop).lt.timeplus) then
c                write(64,1487) 0, 0., 0., 0., (conc_bc3(1,int,i),i=1,nsp
c     $               )
cc                goto 3156
c             end if
c 3154     continue
c 3156     continue

             do 1489 i=1,nn
                write(64,1487) i,x(i),y(i),z(i),ctemp(i),
     &               (cu((isp-1)*nn+i),isp=1,nsp),
     &               (chemc((isp-1)*nn+i),isp=1,ncspec+1)
 1489        continue
 1487        format (i8,1x,90(E15.5,1x))
             close(64)
             
          endif
       endif
c
c  ...Find maximum change if time step control
c     (Skip the first-type nodes)
c
        if(time_step_control.and.control_conc) then
          dconc_max=-1.d30
          do 450 isp=1,nsp
            istart=(isp-1)*nn + 1
c            istart2 = istart - 1
            iend = isp*nn
            icount=0
            do 440 i=istart,iend
              icount=icount+1
              if(icc(icount).eq.0) then
                difference=dabs(cu(i)-cic(i))
c                if(difference.gt.dconc_max) dconc_max=difference
                 dconc_max=dmax1(difference,dconc_max)
              end if
  440       continue
  450     continue
crt
c first time step also look for injection concentrations
c
          if(ntloop.eq.1) then
c look for injection concentration
            if(nwell.gt.0) then
              ncount=0
              do 323 i=1,nwell
                if(flowrate(i).gt.0.0d0) then
                  do 113 isp=1,nsp
                    do 112 iint=1,ninjc(i,isp)
                      timemin=toninjc(i,isp,iint)-dsmall
                      if(t(ntloop).gt.timemin) then
                        if(cinjc(i,isp,iint).gt.dconc_max) dconc_max=
     &                  cinjc(i,isp,iint)
                        goto 115
                      end if
 112                continue
 113              continue
 115              continue
                end if
 323          continue
            end if
          end if
        end if
c
c  ...Reassign values
c
      do 600 i=1,nsp*nn
        cic(i)=cu(i)
  600 continue

      return
      end

c************************************************************************

      subroutine solve_trans(ntloop,isp,cexch)

c************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'
      dimension cexch(maxnn*maxsp)
      common /control/ tolex, maxiter


      dsmall = 1.0d-6
      istart=(isp-1)*nn + 1
      iend = isp*nn
      istart2=istart-1
      ispcount=isp
csd      write(66,6000) spname(isp)
 6000 format(/,'***Solving transport for ',a20,' ***')
c
c  ...Initialize vector of unknowns
c
cc      if(firstiter) then
        do 100 i=istart,iend
          cu(i)=cic(i)
  100   continue
cc      end if
c
c  ...Assign Dirichlet condition (only if not iconbc1)
c     
        if(nbc1tot.gt.0) then
          ncount=1
          do 225 i=1,nbc1_zones
            if(.not.iconbc1(i)) then
              scontrl=0.d0
              do 210 int=1,nbc1_conc(i)
                timemin=ton_bc1(i,int,ispcount)-dsmall
                timeplus=toff_bc1(i,int,ispcount)+dsmall
                if(t(ntloop).gt.timemin.and.t(ntloop).lt.timeplus)
     &            then
                  scontrl=conc_bc1(i,int,ispcount)
                  goto 215
                end if
  210         continue
  215         continue
              do 220 j=1,nbc1(i)
                node=node_bc1(ncount)
                cu(istart2+node)=scontrl
ccc           cic(istart2+node)=scontrl
                ncount=ncount+1
  220         continue
            end if
  225     continue
        end if
c
c  ...Assemble global matrix and flux vector
c
      call assembly_trans(ntloop,isp,cexch)
c
c  ...Solve for the concentration
c     
c  ...Perform incomplete lu decomposition of the matrix
c     

      call iluc
c
c  ...Maximum iterations for ORTHOMIN algorithm
c     
      maxit=nn
c      maxit=min0(nn,900)
c
c  ...Solve the matrix equation 'r c = g'
c     
c
c  ...Switch the order of the unknowns in the cu vector such that
c     the present species is stored from cu(1) to cu(nn)
c
      if(isp.gt.1) then
        do 2500 i=1,nn
          cdum=cu(i)
          cu(i)=cu(istart2+i)
          cu(istart2+i)=cdum
 2500   continue
      end if

      call orthomin(maxit,resx,resr)
c
c  ...Restore the previous order for vector cu
c
      if(isp.gt.1) then
        do 2510 i=1,nn
          cdum=cu(i)
          cu(i)=cu(istart2+i)
          cu(istart2+i)=cdum
 2510   continue
      end if
c
csd      write(66,6010) maxit
ccc      write(*,6010) maxit
 6010 format ('Number of orthomin iterations',i5)

cc        cputime=dble(mclock())/100.0d0-cpu1
cc        write(66,6248) cputime
cc 6248   format(/'Cpu time for orthomin: ',d15.10,' seconds')
c
      return
      end

c************************************************************************

      subroutine assembly_trans(ntloop,isp,cexch)

c************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'
      dimension cexch(maxnn*maxsp)
      dsmall=1.0d-6
      istart2=(isp-1)*nn
      ispcount=isp
ccc      if(isp.gt.7) ispcount=isp-6

      call dzero(nn,gb(1),1)
      itemp=ia(nn+1)
      call dzero(itemp,r(1),1)
c
c  ...Initialize initial mass in system
c
      if(ntloop.eq.1) then
        dmassi(isp)=0.d0
        dmisorbed(isp)=0.d0
      end if
      mbal_flag=.false.
c
c  ...Global assembly (porous media)
c     
      call pm_assem_trans(ntloop,isp,cexch)
c
c  ...Third-type boundaries contribution to transport matrix
c     and right-hand side vector
c     
      if (nbc3tot.gt.0) then
        time=t(ntloop)
        call bc3(time,isp)
      end if
c
c  ...Solute extraction via pumping wells
c
crt      if(cvolume.and.nwell.gt.0) then
      if(nwell.gt.0) then
        ncount=0
        do 325 i=1,nwell
          if(flowrate(i).lt.0.0d0) then
            do 300 j=1,nn_well(i)
              ncount=ncount+1
              node=jq(i,j)
              r(iadpiv(node))=r(iadpiv(node)) - gbwellmb(ncount)
  300       continue
          else
crt
            scontrl=0.d0
            found=.false.
            do 110 int=1,ninjc(i,isp)
              timemin=toninjc(i,isp,int)-dsmall
              timeplus=toffinjc(i,isp,int)+dsmall
              if(t(ntloop).gt.timemin.and.
     &             t(ntloop).lt.timeplus) then
                scontrl=cinjc(i,isp,int)
                found=.true.
                goto 115
              end if
  110       continue
  115       continue
            if(found) then
              do 130 j=1,nn_well(i)
                ncount=ncount+1
                node=jq(i,j)
                gb(node)=gb(node)+gbwellmb(ncount)*scontrl
  130         continue
            else
              ncount=ncount+nn_well(i)
            end if
          end if
crt
 325    continue
      end if
c
c   ...If finite volume, must remove or add mass at first-type flow
c      nodes
c
      if(cvolume.and.ndc.gt.0) then
        do 505 i=1,ndc
          node=jm(i)
ccc          if((icc(node).eq.0).and..not.type3(node)) then
          if(icc(node).le.0) then
            if(fluxdch(i).lt.0.0d0) then
              r(iadpiv(node))=r(iadpiv(node))-fluxdch(i)
            end if
          end if
  505   continue
      end if
      if(cvolume.and.nbc2.gt.0) then
        do 507 i=1,ndc
          node=jbc2(i)
          if((icc(node).le.0).and..not.type3(node)) then
            if(fluxbc2(i).lt.0.0d0) then
              r(iadpiv(node))=r(iadpiv(node))-fluxbc2(i)
            end if
          end if
  507   continue
      end if
c
c  ...Take care of the dirichlet nodes
c     use large values to swamp out other effects
c     
      if(nbc1tot.gt.0) then
        ncount=1
        do 250 i=1,nbc1_zones
          scontrl=0.d0
          if(.not.iconbc1(i)) then
            do 210 int=1,nbc1_conc(i)
              timemin=ton_bc1(i,int,ispcount)-dsmall
              timeplus=toff_bc1(i,int,ispcount)+dsmall
              if(t(ntloop).gt.timemin.and.t(ntloop).lt.timeplus) then
                scontrl=conc_bc1(i,int,ispcount)
                goto 215
              end if
  210       continue
  215       continue
            do 220 j=1,nbc1(i)
              node=node_bc1(ncount)
              k=iadpiv(node)
              r(k)=1.0d15
              gb(node)=scontrl*1.0d15
c  ...Initial guess for solver
              cu(istart2+node)=scontrl
              ncount=ncount+1
  220       continue
          else
            timeplus=toff_bc1(i,1,1)+dsmall
            if(t(ntloop).lt.timeplus) then
              do 223 j=1,nbc1(i)
                node=node_bc1(ncount)
                k=iadpiv(node)
                r(k)=1.0d15
                gb(node)=cic(istart2+node)*1.0d15
                cu(istart2+node)=cic(istart2+node)
                ncount=ncount+1
  223         continue
            end if
          end if
  250   continue
      end if
      
      return
      end


c************************************************************************

      subroutine pm_assem_trans(ntloop,isp,cexch)

c************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'
      dimension cexch(maxnn*maxsp)
      dimension pecmax(3), ipecelem(3), npec(3),
     &          courmax(3),icourelem(3),ncour(3)
      dimension node(maxnln)
      logical ifac
c      common /control/ tolex, maxiter, nsptot, nspmobn3, nspmobn3r,
c     +                 nspn3tot, nspmobtot
       common /control/ tolex, maxiter


      istart=(isp-1)*nn +1
      istart2=istart-1

c      if(isp.gt.4) then
c        istartcex=( isp - (nspn3tot+1-nspmobn3r) )*nn
c      else
c        istartcex=istart2-nn
c      end if

      istartcex=(isp-1)*nn

      xinvnln=1.0d0/dble(nln)
      do 7580 i=1,3
        pecmax(i)=0.0d0
        ipecelem(i)=0
        npec(i)=0
        ncour(i)=0
 7580 continue
c
c  ...Loop over hexahedral (brick) or prism elements
c     
      do 200 l=1,ne
cws        if(iprop(l).eq.0) go to 200
cws     leave out inactive elements
       if(.not.inactelem(l)) then
        imat=iprop(l)
        do 40 i=1,nln
          node(i)=in(i,l)
  40    continue

        if(kd_rand) then
          imatkd=l
        elseif(.not.kd_rand) then
          imatkd=imat
        end if
c
c  ...Elemental retardation factor
c     
        porsol=por(imat)
ckd        retard=1.0d0+bdens(imat)*dkd(imatkd)/porsol
        retard=1.0d0
        retard1=retard-1.0d0
        porsor=porsol*retard1

        factor=porsol*retard
        factor2=factor*clambda(isp)
c
c  ...Elemental degree of saturation * effective diffusion coefficient
c     
        satdst=porsol*dstar(imat)
c
c  ...Element lengths in x-y-z directions
c     
        if(nln.eq.8) then
          call elemdim(l,dx,dy,dz)
        end if
c
c  ...Elemental dispersion coefficients
c     
        qx2=vx(l)*vx(l)
        qy2=vy(l)*vy(l)
        qz2=vz(l)*vz(l)
        qq=dsqrt(qx2+qy2+qz2)
        if(qq.gt.1.d-25) then
          adiff=al(imat)-at(imat)
          adiff2=al(imat)-atv(imat)
cc          dxx=at(imat)*qq + adiff*qx2/qq + satdst
cc          dxy=adiff*vx(l)*vy(l)/qq
cc          dxz=adiff*vx(l)*vz(l)/qq
cc          dyy=at(imat)*qq + adiff*qy2/qq + satdst
cc          dyz=adiff*vy(l)*vz(l)/qq
cc          dzz=at(imat)*qq + adiff*qz2/qq + satdst
          qqx=qx2/qq  
          qqy=qy2/qq  
          qqz=qz2/qq  
          dxx=al(imat)*qqx + at(imat)*qqy + atv(imat)*qqz + satdst
          dyy=at(imat)*qqx + al(imat)*qqy + atv(imat)*qqz + satdst
          dzz=atv(imat)*qqx + atv(imat)*qqy + al(imat)*qqz + satdst
          dxy=adiff*vx(l)*vy(l)/qq
          dxz=adiff2*vx(l)*vz(l)/qq
          dyz=adiff2*vy(l)*vz(l)/qq
        else
          dxx=satdst
          dyy=satdst
          dzz=satdst
          dxy=0.0d0
          dxz=0.0d0
          dyz=0.0d0
        endif
c
c  ...Element volume
c     
        if(nln.eq.8) then
          elv=dx*dy*dz
c
c  ...Precompute some quantities used in assembly
c     
          elvfac=elv*factor
          termxx=dy*dz*0.5d0/dx
          termyy=dx*dz*0.5d0/dy
          termzz=dx*dy*0.5d0/dz
          aa1=dxx*termxx
          aa2=dyy*termyy
          aa3=dzz*termzz
          aa4=dxy*dz*0.5d0
          aa5=dxz*dy*0.5d0
          aa6=dyz*dx*0.5d0
          if(.not.cvolume) then
            aa7=vx(l)*dy*dz*0.25d0
            aa8=vy(l)*dx*dz*0.25d0
            aa9=vz(l)*dx*dy*0.25d0
          else
            aa21=dkxx(imat)*termxx
            aa22=dkyy(imat)*termyy
            aa23=dkzz(imat)*termzz
          end if
          aa10=elvfac*0.125d0/delta
          aa11=elv*factor2*0.125d0

      elseif(nln.eq.6) then
c
c   ...Precompute some quantities used in assembly
c  
        call coefpr_trans(l,delt)
        el14=dlac(node(1),node(4))
        el25=dlac(node(2),node(5))
        el36=dlac(node(3),node(6))
        dx=dmax1( dabs( x(node(1))-x(node(2)) ),
     +            dabs( x(node(1))-x(node(3)) ),
     +            dabs( x(node(2))-x(node(3)) ) )
        dy=dmax1( dabs( y(node(1))-y(node(2)) ),
     +            dabs( y(node(1))-y(node(3)) ),
     +            dabs( y(node(2))-y(node(3)) ) )
        dz=(el14+el25+el36)/3.0d0
        elv=dz*delt
        elvfac=elv*factor
        aa1=dxx*elv*0.5d0
        aa2=dyy*elv*0.5d0
        aa3=2.0d0*dzz*delt/(3.d0*dz)
        aa4=dxy*elv*0.25d0
        aa5=dxz*delt*0.5d0
        aa6=dyz*delt*0.5d0
        aa7=vx(l)*elv*0.5d0
        aa8=vy(l)*elv*0.5d0
        aa9=vz(l)*delt/3.d0
        aa10=elvfac/(6.0d0*delta)
        aa11=elv*factor2/(6.0d0)
        aa21=dkxx(imat)*elv*0.5d0
        aa22=dkyy(imat)*elv*0.5d0
        aa23=2.0d0*dkzz(imat)*delt/(3.d0*dz)
      end if
c
c  ...Check peclet and courant numbers
c     ONLY for the first time step)
c
      if(.not.mbal_flag) then
        if(ntloop.eq.1) then
        pecletx=dabs(vx(l)*dx/dxx)
        peclety=dabs(vy(l)*dy/dyy)
        pecletz=dabs(vz(l)*dz/dzz)
        if(pecletx.gt.pecmax(1)) then
          pecmax(1)=pecletx
          ipecelem(1)=l
        end if
        if(peclety.gt.pecmax(2)) then
          pecmax(2)=peclety
          ipecelem(2)=l
        end if
        if(pecletz.gt.pecmax(3)) then
          pecmax(3)=pecletz
          ipecelem(3)=l
        end if
        if(pecletx.gt.pectol) npec(1)=npec(1)+1
        if(peclety.gt.pectol) npec(2)=npec(2)+1
        if(pecletz.gt.pectol) npec(3)=npec(3)+1

        courantx=dabs((vx(l)/por(imat))*delta/dx)
        couranty=dabs((vy(l)/por(imat))*delta/dy)
        courantz=dabs((vz(l)/por(imat))*delta/dz)
        if(courantx.gt.courmax(1)) then
          courmax(1)=courantx
          icourelem(1)=l
        end if
        if(couranty.gt.courmax(2)) then
          courmax(2)=couranty
          icourelem(2)=l
        end if
        if(courantz.gt.courmax(3)) then
          courmax(3)=courantz
          icourelem(3)=l
        end if
        if(courantx.gt.courtol) ncour(1)=ncour(1)+1
        if(couranty.gt.courtol) ncour(2)=ncour(2)+1
        if(courantz.gt.courtol) ncour(3)=ncour(3)+1
       end if
c
c  ...Upstream weighting factors (if not control volume)
c
        ifac=.false.
        if(.not.cvolume.and.upstrvel) then
          call upsfac(vx(l),vy(l),vz(l),almax,betmax,gammax,
     &                  facx,facy,facz,qx2,qy2,qz2)
          ifac=.true.
          checkf=dabs(facx+facy+facz)
          if(checkf.lt.1.0d-2) ifac=.false.
        end if
c
c  ...Get average concentration over element to compute mass at
c     beginning of time step (for first time step only)
c
        if(ntloop.eq.1) then
          cavg=0.0d0
          do 4360 i=1,nln
            cavg=cavg+cic(istart2+node(i))
 4360     continue
          cavg=cavg*xinvnln

          dmassi(isp) = dmassi(isp) + cavg*(elv*porsol)
          dmisorbed(isp) = dmisorbed(isp) + cavg*(elv*porsor)
        end if
c
c  ...Global transport matrix assembly
c
        if(cvolume) then
          call cvol(aa1,aa2,aa3,aa4,aa5,aa6,aa10,aa11,aa21,
     &            aa22,aa23,istart2,node)
        else

        do 815 i=1,nln
          n1=node(i)
          do 810 jj=1,nlnj
            j=jloop(i,jj)
            n2=node(j)
            call find(n1,n2,iband)
            if(iband.eq.0) goto 810
            term= twc*(aa1*edxx(i,j)+aa2*edyy(i,j)+aa3*edzz(i,j)+
     &         aa4*edxy(i,j) + aa5*edxz(i,j) + aa6*edyz(i,j) +
     &         aa7*evx(i,j)  + aa8*evy(i,j)  + aa9*evz(i,j)  +
     &         aa11*eb(i,j) )
           if(ifac) then
             term=term+ aa7*facx*evxu(i,j)  + aa8*facy*evyu(i,j)
     &              + aa9*facz*evz(i,j)
           end if
           termc = aa10*eb(i,j)

           r(iband) = r(iband)+term+termc
           term2=term*twratioc
           gb(n1) = gb(n1) + (term2+termc)*cic(istart2+n2)
  810    continue
  815  continue

      end if
c
c  ...Add EXPLICIT contribution from diffusive cross-terms for FD
c
      if (xterms) then
        do 550 i=1,nln
          n1=node(i)
          do 540 j=1,nlnj-1
            ixy=iconxy(i,j)
            ixz=iconxz(i,j)
            iyz=iconyz(i,j)
            gb(n1) = gb(n1) -
     &       aa4*edxy(i,ixy)*cic(istart2+node(ixy)) -
     &       aa5*edxz(i,ixz)*cic(istart2+node(ixz)) -
     &       aa6*edyz(i,iyz)*cic(istart2+node(iyz))
  540     continue
c   ...Diagonal contribution
          gb(n1) = gb(n1) - (aa4*edxy(i,i) + aa5*edxz(i,i) +
     &      aa6*edyz(i,i))*cic(istart2+n1)
  550   continue
      end if
c
c  ...Add chemical contribution for reactive species
c
csdsd        if(isp.gt.1) then
          do 225 i=1,nln
            n1=node(i)
            gb(n1) = gb(n1) + aa10*cexch(istartcex+n1)
  225     continue
csdsd        end if

      else
c
c  ...Mass balance
c
c  ...Get average concentration for element
c
c
        cavg=0.d0
        cavg2=0.d0
        do 150 i=1,nln
          cavg=cavg+cu(istart2+node(i))
  150   continue
        cavg=cavg*xinvnln
csdsd        if(isp.gt.1) then
          do 155 i=1,nln
            cavg2 = cavg2 + cexch(istartcex+node(i))
  155     continue
          cavg2=cavg2*xinvnln
csdsd        end if
c
c  ...Compute mass stored for this element and add to total mass
c
        dmstorepm=dmstorepm+cavg*(elv*porsol)
        dmdecay=dmdecay+cavg*(elv*porsol)*clambda(isp)
        dmexchange=dmexchange+cavg2*(elv*porsol)
        dmsorbed=dmsorbed + cavg*(elv*porsor)
        dmdecays=dmdecays + cavg*(elv*porsor*clambda(isp))
c
c  ...Reassemble transport matrix for first-type nodes
c     
        if(cvolume) then
          call cvol(aa1,aa2,aa3,aa4,aa5,aa6,aa10,aa11,aa21,
     &            aa22,aa23,istart2,node)
        else

        do 435 i=1,nln
          n1=node(i)
          if(icc(n1).eq.1) then
          do 430 jj=1,nlnj
            j=jloop(i,jj)
            n2=node(j)
            call find(n1,n2,iband)
            if(iband.eq.0) goto 430
            term= twc*(aa1*edxx(i,j)+aa2*edyy(i,j)+aa3*edzz(i,j)+
     &         aa4*edxy(i,j) + aa5*edxz(i,j) + aa6*edyz(i,j) +
     &         aa7*evx(i,j)  + aa8*evy(i,j)  + aa9*evz(i,j)  +
     &         aa11*eb(i,j) )

            if(ifac) then
              term=term+ aa7*facx*evxu(i,jj) + aa8*facy*evyu(i,jj)
     &              + aa9*facz*evz(i,jj)
            end if
            termc = aa10*eb(i,j)
            term2=term*twratioc
            gb(n1)=gb(n1)+(term+termc)*cu(istart2+n2)-
     &             (term2+termc)*cic(istart2+n2)
  430     continue
         end if
  435   continue

      end if
c
c  ...Add EXPLICIT contribution from diffusive cross-terms for FD
c
      if(xterms) then
        do 580 i=1,nln
          n1=node(i)
          if(icc(n1).eq.1) then
            do 570 j=1,nlnj-1
              ixy=iconxy(i,j)
              ixz=iconxz(i,j)
              iyz=iconyz(i,j)
              gb(n1) = gb(n1) +
     &         aa4*edxy(i,ixy)*cic(istart2+node(ixy)) +
     &         aa5*edxz(i,ixz)*cic(istart2+node(ixz)) +
     &         aa6*edyz(i,iyz)*cic(istart2+node(iyz))
  570       continue
            gb(n1) = gb(n1) + (aa4*edxy(i,i) + aa5*edxz(i,i) +
     &        aa6*edyz(i,i))*cic(istart2+n1)
          end if
  580   continue
      end if
c
c  ...Add chemical contribution
c
csdsd        if(isp.gt.1) then
          do 321 i=1,nln
            n1=node(i)
            if(icc(n1).eq.1) then
              gb(n1) = gb(n1) - aa10*cexch(istartcex+n1)
            end if
  321     continue
csdsd        end if

      end if
c
c  ...End loop over elements
cws  endif from inactive elements
      endif
c     
  200 continue
c
c  ...Write out peclet and courant info
c 
        if((.not.mbal_flag).and.firstiter.and.(ntloop.eq.1)) then
            write(66,6505) pectol
 6505       format(/,'Maximum allowed Peclet number: ',F14.3,/,
     &      'Peclet number:',t20,'Dimension',
     &      '   maximum','    element')

            do 7581 i=1,3
              write(66,6507) i,pecmax(i),ipecelem(i)
 7581       continue
 6507       format(19x,i5,f14.3,i11)

            do 7582 i=1,3
              if(npec(i).gt.0) write(66,6509) npec(i),i
 7582       continue
 6509       format(/'**** WARNING ****',/,i6,' element(s) exceed(s)',
     &     ' the prescribed maximum peclet in dimension ',i1)

            write(66,7505) courtol
 7505       format(/,'Maximum allowed Courant number: ',f14.3,/,
     &      'Courant number:',t20,'Dimension',
     &      '   maximum','    element')

            do 8581 i=1,3
              write(66,6507) i,courmax(i),icourelem(i)
 8581       continue

            do 8582 i=1,3
              if(ncour(i).gt.0) write(66,6519) ncour(i),i
 8582       continue
 6519       format(/'**** WARNING ****',/,i6,' element(s) exceed(s)',
     &      ' the prescribed maximum courant in dimension ',i1)
          endif

c     
c     correction for inactive nodes!
c     


          do i = 1,nn
             k=iadpiv(i)
             if (r(k) .EQ. 0.d0) then
                r(k) = 1.d30
                if (icc(i).ne.1) icc(i)=-1
             endif
          end do
             
      return
      end

c************************************************************************

      subroutine compmass(ntloop,isp,mflag,output)

c************************************************************************
c calculate mass balance for immobile species
c
      include 'tbc.prm'
      include 'tbc.dim'
c      common /control/ tolex, maxiter, nsptot, nspmobn3, nspmobn3r,
c     +                 nspn3tot, nspmobtot
      common /control/ tolex, maxiter

      common /mba/ sdmchange
      double precision sdmchange(maxsp)
      save /mba/

      logical mflag,output
c      character*6 species(13)
c      data species/'Tracer','N3m','Om','OCm','Bact','OCmat',
c     & 'Cnapl','N3im','Oim','OCim','Ca','TIC','ALK'/


      dsmall=1.0d-6
      cmassold=0.0d0
      cmassnow=0.0d0
      istart=(isp-1)*nn +1
      istart2=istart-1
      xinvnln=1.0d0/dble(nln)
c
c  ...Loop over hexahedral (brick) or prism elements
c     
      do 200 l=1,ne
cws   leave out inactive elements 
cws        if(iprop(l).eq.0) go to 200
         if(.not.inactelem(l)) then

c
c  ...Saturated porosity
c     
           porsp=porfac(isp)
c
c  ... calc. element volume elv
c     
           if(nln.eq.8) then
              call elemdim(l,dx,dy,dz)
              elv=dx*dy*dz
            elseif(nln.eq.6) then
c
c   ...Precompute some quantities used in assembly
c  
              call coefpr_trans(l,delt)
              el14=dlac(in(1,l),in(4,l))
              el25=dlac(in(2,l),in(5,l))
              el36=dlac(in(3,l),in(6,l))
              dx=dmax1( dabs( x(in(1,l))-x(in(2,l)) ),
     +              dabs( x(in(1,l))-x(in(3,l)) ),
     +              dabs( x(in(2,l))-x(in(3,l)) ) )
              dy=dmax1( dabs( y(in(1,l))-y(in(2,l)) ),
     +              dabs( y(in(1,l))-y(in(3,l)) ),
     +              dabs( y(in(2,l))-y(in(3,l)) ) )
              dz=(el14+el25+el36)/3.0d0
              elv=dz*delt
           end if
c
c  ...Get average concentration over element to compute mass at
c     beginning of time step (for first time step only)
c
           if(mflag) then
              cavg=0.0d0
              do 4360 i=1,nln
                 cavg=cavg+cic(istart2+in(i,l))
 4360         continue
              cavg=cavg*xinvnln
 
              dmassi(isp) = dmassi(isp) + cavg*(elv*porsp)
              if(cavg*elv*porfac(isp).gt.0.0d0) ncheck=ncheck+1

            else
c
c  ...Get average concentration for element
c     normal timestep
c
              cavg=0.d0
              cavg2=0.d0
              do 150 i=1,nln
                 cavg=cavg+cu(istart2+in(i,l))
                 cavg2=cavg2+cic(istart2+in(i,l))
  150         continue
              cavg=cavg*xinvnln
              cavg2=cavg2*xinvnln
c
c  ...Compute mass stored for this element and add to total mass
c
              cmassnow=cmassnow+cavg*(elv*porsp)
              cmassold=cmassold+cavg2*(elv*porsp)
           end if
cws     endif from inactive elements:
         endif
  200      continue

      if(mflag) then
        sdmchange(isp)=0.d0
      else
        dmchange=cmassnow-cmassold
        sdmchange(isp)=sdmchange(isp)+dmchange
        if(output) then
          write(66,6630) spname(isp)
          write(66,6635) cmassnow,cmassold,dmchange,sdmchange(isp)

          write(65,6631) spname(isp)
          write(65,4711) dmchange,sdmchange(isp)
 4711     format('   Total mass change',t50,g15.8,t70,g15.8)
        end if
        dmassi(isp)=cmassnow
      end if
 6630 format(/,'Mass change for ',a20,/,30('-'))
 6631 format('Mass change for ',a20)
 6635 format('  Total mass in system : ',t50,d12.4,/,
     &       '  Mass at previous time : ',t50,d12.4,/,
     &       '  Change in mass over time step : ',t50,d12.4,/,
     &       '  Total change in mass (all steps) : ',t50,d12.4)

      return
      end

c***************************************************************************

      subroutine fbc3(izone,ncount)

c***************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'

      smallpos=1.0d-6
      smallneg=-1.0d-6  

      found=.true.

      nbc3(izone)=0
      i=izone
      read(55,*) giveflux(i)
cws Jan. 1999     if(giveflux(i)) read(55,*) fnormbc3(i)
      read(55,*) iface_bc3(i)
      num_plane=iface_bc3(i)
      read(55,*) iconbc3(i)
      if(.not.iconbc3(i)) then
        read(55,*) nbc3_conc(i)
        do 1980 isp=1,nsp
          do 1950 iconc=1,nbc3_conc(i)
            read(55,*) conc_bc3(i,iconc,isp),ton_bc3(i,iconc,isp),
     &     toff_bc3(i,iconc,isp)
 1950     continue
 1980   continue
      else
        nbc3_conc(i)=1
        read(55,*) ton_bc3(i,1,1),toff_bc3(i,1,1)
c        if(lchem.gt.0) then
          do 1990 isp=2,nsp
            ton_bc3(i,1,isp)=ton_bc3(i,1,1)
            toff_bc3(i,1,isp)=toff_bc3(i,1,1)
 1990     continue
c        end if
      end if
      read(55,*) xfrom_el,xto_el,yfrom_el,yto_el,zfrom_el,zto_el
c
c  ...Locate the z-level
c     It is assumed that the grid is regular in the z-direction
c     but can be irregular in the xy-plane (e.g. if nln=6)
c
      zz1=zfrom_el-smallpos
      zz2=zfrom_el+smallpos
      indez1=0
      do 2000 iz=1,nz
        if(zi(iz).ge.zz1.and.zi(iz).le.zz2) then
          indez1=iz
          goto 2001 
        end if
 2000 continue
 2001 continue
      if(indez1.eq.0) found=.false.

      zz1=zto_el-smallpos
      zz2=zto_el+smallpos
      indez2=0
      do 2005 iz=1,nz
        if(zi(iz).ge.zz1.and.zi(iz).le.zz2) then
          indez2=iz
          goto 2006
        end if 
 2005 continue
 2006 continue
      if(indez2.eq.0) found=.false.

      if(.not.found) then
        write(66,3000) indez1,indez2
        write(*,3000) indez1,indez2
        stop
      end if
 3000 format(/,'**** ERROR ****',/,
     &  'Range of elements not found',
     &  /'z-index1=',i4,' z-index2=',i4)

      idum=indez1
      if(indez1.gt.indez2) then
        indez1=indez2
        indez2=idum
      end if

      if(indez1.eq.indez2) then
        if(indez2.eq.1) indez2=2
        if(indez1.eq.nz) indez1=nz-1
      end if
c
c  ...If nln=8, it is assumed that the grid is regular in
c     all directions
c
c  ...Loop over elements in the z-range found
c
      if(nln.eq.8) then
        incidencex1=iface(num_plane,1,1)
        incidencex2=iface(num_plane,2,1)
        incidencey1=iface(num_plane,1,1)
        incidencey2=iface(num_plane,4,1)
        if(num_plane.eq.2.or.num_plane.eq.4) then
          incidencey2=iface(num_plane,2,1)
        end if
        do 3050 iz=indez1,indez2-1
          ielem1=(iz-1)*nesl+1
          ielem2=iz*nesl
          do 3030 iel=ielem1,ielem2
            found=.true. 
            x1=x(in(incidencex1,iel))
            x2=x(in(incidencex2,iel))
            y1=y(in(incidencey1,iel))
            y2=y(in(incidencey2,iel))

            check=x1-xfrom_el
            if(check.lt.smallneg) found=.false.

            check=x2-xto_el
            if(check.gt.smallpos) found=.false.

            check=y1-yfrom_el
            if(check.lt.smallneg) found=.false.

            check=y2-yto_el
            if(check.gt.smallpos) found=.false.

            if(found) then
               ncount=ncount+1
               if (ncount.gt.maxnbc3) then
                  write(66,*) 'Dimensioning ERROR'
                  write(66,*) ' maxnbc3 =',maxnbc3,' is too small' 
                  write(66,*) ' Increase maxnbc3 and recompile'
                  write(*,*) 'Dimensioning ERROR'
                  write(*,*) ' maxnbc3 =',maxnbc3,' is too small' 
                  write(*,*) ' Increase maxnbc3 and recompile'
                  stop
               endif   
              iel_bc3(ncount)=iel
              nbc3(izone)=nbc3(izone)+1
            end if
 3030     continue
 3050   continue
      elseif(nln.eq.6) then
        write(66,4000) 
 4000   format('*** WARNING ***',/,'Trying to define 3rd-type',
     &  ' boundary conditions using coordinates',/,'while you are',
     &  ' using triangular prism elements, code needs to be changed',
     &  ' for that',/,'Program stopped')
        stop
      end if

      return
      end

c***************************************************************************

      subroutine bc3(time,isp)

c***************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'

      dsmall=1.0d-6
      istart2=(isp-1)*nn
      ispcount=isp
c      if(isp.gt.7) ispcount=isp-6

      ncount_bc3=1
      termcor=1.0d0
      if(cvolume) termcor=0.0d0
      do 1233 k=1,nbc3_zones
        if(.not.iconbc3(k)) then
          scontrl=0.0d0
          do 3154 int=1,nbc3_conc(k)
            timemin=ton_bc3(k,int,ispcount)-dsmall
            timeplus=toff_bc3(k,int,ispcount)+dsmall
            if(time.gt.timemin.and.time.lt.timeplus) then
              scontrl=conc_bc3(k,int,ispcount)
              goto 3156
            end if
 3154     continue
 3156     continue
        else
          timeplus=toff_bc3(k,1,1)+dsmall
          if(time.lt.timeplus) then
            scontrl=1.0d0
          else
            scontrl=0.0d0
          end if
        end if
        nface=iface_bc3(k)
        do 3174 ielem=1,nbc3(k)
          l=iel_bc3(ncount_bc3)
          ncount_bc3=ncount_bc3+1
          ncount=4
c
c  ...Find the face area
c
          if(nln.eq.8) then
           if(kgrid.eq.1)then
            if(nface.eq.1.or.nface.eq.3) then
c...  x- and z-lengths of front or back faces
             el1=x(in(6,l))-x(in(5,l))
             el2=z(in(5,l))-z(in(1,l))
            elseif(nface.eq.2.or.nface.eq.4) then
c...  z- and y-lengths of right or left faces
             el1=z(in(6,l))-z(in(2,l))
             el2=y(in(3,l))-y(in(2,l))
            elseif(nface.eq.5.or.nface.eq.6) then
c...  x- and y-lenghts of top or bottom faces
             el1=y(in(3,l))-y(in(2,l))
             el2=x(in(2,l))-x(in(1,l))
            endif
           elseif(kgrid.eq.0) then
            if(nface.eq.1)then
             el12=dlac(in(1,l),in(2,l))
             el56=dlac(in(5,l),in(6,l))
             el1=0.5d0*(el12+el56)
             el15=dlac(in(1,l),in(5,l))
             el26=dlac(in(2,l),in(6,l))
             el2=0.5d0*(el15+el26)
            elseif(nface.eq.3)then
             el34=dlac(in(3,l),in(4,l))
             el78=dlac(in(7,l),in(8,l))
             el1=0.5d0*(el34+el78)
             el37=dlac(in(3,l),in(7,l))
             el48=dlac(in(4,l),in(8,l))
             el2=0.5d0*(el37+el48)
            elseif(nface.eq.2)then
             el26=dlac(in(2,l),in(6,l))
             el37=dlac(in(3,l),in(7,l))
             el1=0.5d0*(el26+el37)
             el23=dlac(in(2,l),in(3,l))
             el67=dlac(in(6,l),in(7,l))
             el2=0.5d0*(el23+el67)
            elseif(nface.eq.4)then
             el15=dlac(in(1,l),in(5,l))
             el48=dlac(in(4,l),in(8,l))
             el1=0.5d0*(el15+el48)
             el14=dlac(in(1,l),in(4,l))
             el58=dlac(in(5,l),in(8,l))
             el2=0.5d0*(el14+el58)
            elseif(nface.eq.5)then
             el23=dlac(in(2,l),in(3,l))
             el14=dlac(in(1,l),in(4,l))
             el1=0.5d0*(el14+el23)
             el12=dlac(in(1,l),in(2,l))
             el34=dlac(in(3,l),in(4,l))
             el2=0.5d0*(el12+el34)
            elseif(nface.eq.6)then
             el58=dlac(in(5,l),in(8,l))
             el67=dlac(in(6,l),in(7,l))
             el1=0.5d0*(el58+el67)
             el56=dlac(in(5,l),in(6,l))
             el78=dlac(in(7,l),in(8,l))
             el2=0.5d0*(el56+el78)
            endif
           endif
           area=el1*el2*0.25d0
          elseif(nln.eq.6) then
            if(nface.eq.1.or.nface.eq.2) then
              delt=(x(in(2,l))*y(in(3,l))-
     &             x(in(3,l))*y(in(2,l)))/2.0d0
              area=delt/3.0d0
              ncount=3
            elseif(nface.eq.3)then
              el1=dlac(in(1,l),in(2,l))
              el2=dlac(in(1,l),in(4,l))
            elseif(nface.eq.4)then
              el1=dlac(in(1,l),in(3,l))
              el2=dlac(in(1,l),in(4,l))
            elseif(nface.eq.5)then
              el1=dlac(in(2,l),in(3,l))
              el2=dlac(in(2,l),in(5,l))
            end if
            area=el1*el2*0.25d0
          end if
c
c  ...Get flux normal to face
c     If flux is outward from domain, set it to zero
cws       Jan. 1999: Change to assign 2nd type fluxes
cws       for 3rd type conditions in transport
cws_old version:       if(giveflux(k)) vnorm=dabs(fnormbc3(k))
          if(giveflux(k)) then
			vnorm=(flux_n(l))
              if(flux_n(l).lt.0.0d0) vnorm=0.0d0
cws          write(66,*) l, flux_n(l), vnorm
cws       end of change Jan. 1999
           else
            if(nln.eq.8) then
              if(nface.eq.1.or.nface.eq.3) then
                vnorm=dabs(vy(l))
                if(nface.eq.1) then
                  if(vy(l).lt.0.0d0) vnorm=0.0d0
                elseif(nface.eq.3) then
                  if(vy(l).gt.0.0d0) vnorm=0.0d0
                end if
              elseif(nface.eq.2.or.nface.eq.4) then
                vnorm=dabs(vx(l))
                if(nface.eq.2) then
                  if(vx(l).gt.0.0d0) vnorm=0.0d0
                elseif(nface.eq.4) then
                  if(vx(l).lt.0.0d0) vnorm=0.0d0
                end if
              elseif(nface.eq.5.or.nface.eq.6) then
                vnorm=dabs(vz(l))
                if(nface.eq.5) then
                  if(vz(l).lt.0.0d0) vnorm=0.0d0
                elseif(nface.eq.6) then
                  if(vz(l).gt.0.0d0) vnorm=0.0d0
                end if
              endif
            endif
          endif
cws
          if(.not.mbal_flag) then
            term=area*vnorm
            term2=term*termcor
            do 221 ii=1,ncount
              n1=in(iface(nface,ii,1),l)
c          skip node if it is first-type
              if(icc(n1).eq.1) goto 221
              do 222 jj=1,ncount
                n2=in(iface(nface,jj,1),l)
                call find(n1,n2,iband)
                if(iband.eq.0) goto 222
                r(iband)=r(iband) + term2*ec(ii,jj)
  222         continue
              if(.not.iconbc3(k)) then
                gb(n1)=gb(n1) + scontrl*term
                cu(istart2+n1)=scontrl
              else
                gb(n1)=gb(n1) + scontrl*cic(istart2+n1)*term
                cu(istart2+n1)=scontrl*cic(istart2+n1)
              end if
  221       continue
          else
            term=area*vnorm
cws            write(66,*)'term', term
            do 241 ii=1,ncount
              n1=in(iface(nface,ii,1),l)
c  ...Skip node if it is first-type
              if(icc(n1).eq.0) then
                if(.not.iconbc3(k)) then
                  gb(n1)=gb(n1) + scontrl*term
                else
                  gb(n1)=gb(n1) + scontrl*cic(istart2+n1)*term
                end if
              end if
  241       continue
          end if
 3174   continue
 1233 continue

      return
      end

c************************************************************************

      subroutine check_size_trans

c************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'

c      common /control/ tolex, maxiter, nsptot, nspmobn3, nspmobn3r,
c     +                 nspn3tot, nspmobtot
       common /control/ tolex, maxiter


      logical pass
      pass=.true.
c
      if(nsp.gt.maxsp) then
        write(66,1) maxsp,nsp
        write(*,1) maxsp,nsp
    1    format(/10x,'Dimensioning error: maxsp = ',i7,
     +          /10x,'                    nsp   = ',i7)
        pass=.false.
      end if
c
c      if((nspmobtot-1).gt.maxspm) then
c        write(66,21) maxspm,(nspmobtot-1)
c   21    format(/10x,'Dimensioning error: maxspm = ',i7,
c     +          /10x,'             (nspmobtot-1) = ',i7)
c        pass=.false.
c      end if
c
      if(nn.gt.maxnnc) then 
        write(66,2) maxnnc,nn
        write(*,2) maxnnc,nn
    2    format(/10x,'Dimensioning error: maxnnc = ',i7,
     +          /10x,'                        nn = ',i7)
        pass=.false.
      end if
c
      if(ne.gt.maxnec) then 
        write(66,3) maxnec,ne
        write(*,3) maxnec,ne
    3   format(/10x,'Dimensioning error: maxnec = ',i7,
     +         /10x,'                        ne = ',i7)
        pass=.false.
      end if
c
      if(nzones_prop.gt.maxpznc) then
        write(66,4) maxpznc,nzones_prop
        write(*,4) maxpznc,nzones_prop
    4   format(/10x,'Dimensioning error: max_pznc = ',i7,
     +         /10x,'                 nzones_prop = ',i7)
        pass=.false.
      end if
c
        if(nbc1tot.gt.maxnbc1) then
          write(66,5) maxnbc1,nbc1tot
          write(*,5) maxnbc1,nbc1tot
    5     format(/10x,'Dimensioning error: maxnbc1 = ',i7,
     +         /10x,'                      nbc1tot = ',i7)
          pass=.false.
        end if
c
        if(nbc1_zones.gt.maxznbc1) then
          write(66,6) maxznbc1,nbc1_zones
          write(*,6) maxznbc1,nbc1_zones
    6     format(/10x,'Dimensioning error: maxznbc1 = ',i7,
     +           /10x,'                  nbc1_zones = ',i7)
          pass=.false.
        end if
c
        do 300 i=1,nbc1_zones
          if(nbc1_conc(i).gt.maxcobc1) then
            write(66,7) maxcobc1,i,nbc1_conc(i)
            write(*,7) maxcobc1,i,nbc1_conc(i)
    7       format(/10x,'Dimensioning error: maxcobc1 = ',i7,
     +         /10x,'             nbc1_conc(',i3,') = ',i7)
            pass=.false.
          end if
  300   continue
c
        if(nbc3tot.gt.maxnbc3) then
          write(66,8) maxnbc3,nbc3tot
          write(*,8) maxnbc3,nbc3tot
    8     format(/10x,'Dimensioning error: maxnbc3 = ',i7,
     +         /10x,'                      nbc3tot = ',i7)
          pass=.false.
        end if
c
        if(nbc3_zones.gt.maxznbc3) then
          write(66,9) maxznbc3,nbc3_zones
          write(*,9) maxznbc3,nbc3_zones
    9     format(/10x,'Dimensioning error: maxznbc3 = ',i7,
     +         /10x,'                     nbc3_zones = ',i7)
          pass=.false.
        end if
c
        do 310 i=1,nbc3_zones
          if(nbc3_conc(i).gt.maxcobc3) then
            write(66,10) maxcobc3,i,nbc3_conc(i)
            write(*,10) maxcobc3,i,nbc3_conc(i)
   10       format(/10x,'Dimensioning error: maxcobc3 = ',i7,
     +         /10x,'             nbc3_conc(',i3,') = ',i7)
            pass=.false.
          end if
  310   continue
c
c
c      if(noutfc.gt.maxoutfc) then
c        write(66,16) maxoutfc,noutfc
c        write(*,16) maxoutfc,noutfc
c   16   format(/10x,'Dimensioning error:   maxoutfc = ',i7,
c     +         /10x,'                        noutfc = ',i7)
c        pass=.false.
c      end if
c
      if(.not.pass) stop
      return
      end

c************************************************************************

      subroutine coeffd_trans

c************************************************************************

c
c     Initialize the local coefficient matrices
c     for a finite difference mesh
c
      include 'tbc.prm'
      include 'tbc.dim'
c
      double precision cmii(4,4),eevx(4,4),eevy(4,4),eevxu(4,4),
     &        eevyu(4,4)

      data cmii/1.d0,0.d0,0.d0,0.d0,0.d0,1.d0,0.d0,0.d0,0.d0,
     &   0.d0,1.d0,0.d0,0.d0,0.d0,0.d0,1.d0/
      data eevx/-.5d0,-.5d0,0.d0,0.d0,.5d0,.5d0,0.d0,0.d0,
     &   0.d0,0.d0,.5d0,.5d0,0.d0,0.d0,-.5d0,-.5d0/
      data eevy/-.5d0,0.d0,0.d0,-.5d0,0.d0,-.5d0,-.5d0,0.d0,
     &   0.d0,.5d0,.5d0,0.d0,.5d0,0.d0,0.d0,.5d0/
      data eevxu/.5d0,-.5d0,0.d0,0.d0,-.5d0,.5d0,0.d0,0.d0,
     &   0.d0,0.d0,.5d0,-.5d0,0.d0,0.d0,-.5d0,.5d0/
      data eevyu/.5d0,0.d0,0.d0,-.5d0,0.d0,.5d0,-.5d0,0.d0,
     &   0.d0,-.5d0,.5d0,0.d0,-.5d0,0.d0,0.d0,.5d0/
c
c  ...Expand the elemental influence coefficient matrices
c
      do 50 i=1,4
        i2 = i+4
        do 40 j=1,4
          j2 = j+4
c
          evx(i,j) = eevx(i,j)
          evx(i,j2) = 0.0d0
          evx(i2,j) = 0.0d0
          evx(i2,j2) = evx(i,j)
c
          evy(i,j) = eevy(i,j)
          evy(i,j2) = 0.0d0
          evy(i2,j) = 0.0d0
          evy(i2,j2) = evy(i,j)
c
          evz(i,j) = -cmii(i,j)*half
          evz(i,j2) = cmii(i,j)*half
          evz(i2,j) = evz(i,j)
          evz(i2,j2) = evz(i,j2)
c
          evxu(i,j) = eevxu(i,j)
          evxu(i,j2) = 0.0d0
          evxu(i2,j) = 0.0d0
          evxu(i2,j2) = evxu(i,j)
c
          evyu(i,j) = eevyu(i,j)
          evyu(i,j2) = 0.0d0
          evyu(i2,j) = 0.0d0
          evyu(i2,j2) = evyu(i,j)
c
   40   continue
   50 continue

      return
      end

c************************************************************************

      subroutine coeffe_trans

c************************************************************************

c     Initialize the local coefficient matrices
c     for a finite element mesh
c
c     The node numbering is the following
c
c          4-------3     8-------7
c          |       |     |       |
c          |bottom |     | top   |
c          1-------2     5-------6
c
c
      include 'tbc.prm'
      include 'tbc.dim'
c
      double precision cmit(4,4),eevx(4,4),eevy(4,4),eevxu(4,4),
     &     eevyu(4,4)
c
      data cmit/4.d0,2.d0,1.d0,2.d0,2.d0,4.d0,2.d0,1.d0,1.d0,
     &  2.d0,4.d0,2.d0,2.d0,1.d0,2.d0,4.d0/
      data eevx/-2.d0,-2.d0,-1.d0,-1.d0,2.d0,2.d0,1.d0,1.d0,
     &  1.d0,1.d0,2.d0,2.d0,-1.d0,-1.d0,-2.d0,-2.d0/
      data eevy/-2.d0,-1.d0,-1.d0,-2.d0,-1.d0,-2.d0,-2.d0,-1.d0,
     &  1.d0,2.d0,2.d0,1.d0,2.d0,1.d0,1.d0,2.d0/
      data eevxu/2.d0,-2.d0,-1.d0,1.d0,-2.d0,2.d0,1.d0,-1.d0,
     &  -1.d0,1.d0,2.d0,-2.d0,1.d0,-1.d0,-2.d0,2.d0/
      data eevyu/2.d0,1.d0,-1.d0,-2.d0,1.d0,2.d0,-2.d0,-1.d0,
     &  -1.d0,-2.d0,2.d0,1.d0,-2.d0,-1.d0,1.d0,2.d0/

c
c  ...Adjust the 4*4 matrices according to dec. 86 & feb. 87 papers.
c
      do 5 i=1,4
        do 4 j=1,4
          cmit(i,j) = cmit(i,j)/9.d0
          eevx(i,j) = eevx(i,j)/6.d0
          eevy(i,j) = eevy(i,j)/6.d0
          eevxu(i,j) = eevxu(i,j)/6.d0
          eevyu(i,j) = eevyu(i,j)/6.d0
    4   continue
    5 continue
c
c  ...Expand the elemental influence coefficient matrices
c
      do 50 i=1,4
        i2 = i+4
        do 40 j=1,4
          j2 = j+4
c
          evx(i,j) = 2.d0*third*eevx(i,j)
          evx(i,j2) = eevx(i,j)*third
          evx(i2,j) = evx(i,j2)
          evx(i2,j2) = evx(i,j)
c
          evy(i,j) = 2.d0*third*eevy(i,j)
          evy(i,j2) = eevy(i,j)*third
          evy(i2,j) = evy(i,j2)
          evy(i2,j2) = evy(i,j)
c
          evz(i,j) = -cmit(i,j)*half
          evz(i,j2) = cmit(i,j)*half
          evz(i2,j) = evz(i,j)
          evz(i2,j2) = evz(i,j2)
c
          evxu(i,j) = 2.d0*third*eevxu(i,j)
          evxu(i,j2) = eevxu(i,j)*third
          evxu(i2,j) = evxu(i,j2)
          evxu(i2,j2) = evxu(i,j)
c
          evyu(i,j) = 2.d0*third*eevyu(i,j)
          evyu(i,j2) = eevyu(i,j)*third
          evyu(i2,j) = evyu(i,j2)
          evyu(i2,j2) = evyu(i,j)
c
   40   continue
   50 continue

      return
      end

c************************************************************************

      subroutine coefpr_trans(l,delt)

c************************************************************************

c
c  ...Computes the influence coefficient matrix for prism elements
c
      include 'tbc.prm'
      include 'tbc.dim'
c
      double precision cmip(4,4),cmilump(4,4),aax(4,4),aay(4,4),
     *  aaxy(4,4),aayz(4,4),aazx(4,4),eevx(4,4),eevy(4,4),
     *  aayzh(4,4),aazxh(4,4),
     *  b(3),g(3),delt,delt2
      double precision x2,x3,y2,y3

      data cmip/.5d0, .25d0, .25d0, 0.d0, .25d0, .5d0, .25d0, 0.d0,
     &         .25d0, .25d0, .5d0, 0.0d0, 0.0d0, 0.d0, 0.d0, 0.d0/
      data cmilump/1.0d0, 0.0d0, 0.0d0, 0.0d0, 0.d0, 1.d0, 0.d0, 0.d0, 
     &          0.0d0, 0.0d0, 1.0d0, 0.0d0, 0.0d0, 0.d0, 0.d0, 0.d0/

      nln2=nln/2
      x2=x(in(2,l))-x(in(1,l))
      x3=x(in(3,l))-x(in(1,l))
      y2=y(in(2,l))-y(in(1,l))
      y3=y(in(3,l))-y(in(1,l))
      delt=(x2*y3-x3*y2)*0.5d0
      delt2=1.0d0/(2.0d0*delt)
      b(1)=(y2-y3)*delt2
      b(2)=y3*delt2
      b(3)=-y2*delt2
      g(1)=(x3-x2)*delt2
      g(2)=-x3*delt2
      g(3)=x2*delt2
c
      do 40 i=1,nln2
        do 39 j=1,nln2
          aax(i,j)=b(i)*b(j)
          aay(i,j)=g(i)*g(j)
          eevx(i,j)=b(j)
          eevy(i,j)=g(j)
          aaxy(i,j)=b(i)*g(j) + b(j)*g(i)
          aayz(i,j)=g(i) + g(j)
          aayzh(i,j)=g(i) - g(j)
          aazx(i,j)=b(i) + b(j)
          aazxh(i,j)=b(i)-b(j)
   39   continue
   40 continue
          
c
c  ...Adjust the 3*3 matrices according to dec. 86 & feb. 87 papers.
c
      do 44 i=1,nln2
        do 43 j=1,nln2
          aayz(i,j) = -aayz(i,j)/3.d0
          aazx(i,j) = -aazx(i,j)/3.d0
          aayzh(i,j) = aayzh(i,j)/3.d0
          aazxh(i,j) = aazxh(i,j)/3.d0
          eevx(i,j) = eevx(i,j)/3.d0
          eevy(i,j) = eevy(i,j)/3.d0   
   43   continue
   44 continue
c
c  ...Expand the elemental influence coefficient matrices
c
      if(klump.eq.0) then
        do 50 i=1,nln2
          i2 = i+nln2
          do 45 j=1,nln2
            j2 = j+nln2
c
            edxx(i,j) = (2.d0/3.d0)*aax(i,j)
            edxx(i,j2) = aax(i,j)/3.d0
            edxx(i2,j) = edxx(i,j2)
            edxx(i2,j2) = edxx(i,j)
c
            edyy(i,j) = (2.d0/3.d0)*aay(i,j)
            edyy(i,j2) = aay(i,j)/3.d0
            edyy(i2,j) = edyy(i,j2)
            edyy(i2,j2) = edyy(i,j)
c
            edzz(i,j) = cmip(i,j)/2.d0
            edzz(i,j2) = -cmip(i,j)/2.d0
            edzz(i2,j) = edzz(i,j2)
            edzz(i2,j2) = edzz(i,j)

c
            edxy(i,j) = (2.d0/3.d0)*aaxy(i,j)
            edxy(i,j2) = aaxy(i,j)/3.d0
            edxy(i2,j) = aaxy(j,i)/3.d0
            edxy(i2,j2) = edxy(i,j)    
c
            edyz(i,j) = aayz(i,j)/2.d0
            edyz(i,j2) = aayzh(i,j)/2.d0
            edyz(i2,j) = aayzh(j,i)/2.d0
            edyz(i2,j2) = -edyz(i,j)
c
            edxz(i,j) = aazx(i,j)/2.d0
            edxz(i,j2) = aazxh(i,j)/2.d0
            edxz(i2,j) = aazxh(j,i)/2.d0
            edxz(i2,j2) = -aazx(j,i)/2.d0
c
            evx(i,j) = (2.d0/3.d0)*eevx(i,j)
            evx(i,j2) = eevx(i,j)/3.d0
            evx(i2,j) = evx(i,j2)
            evx(i2,j2) = evx(i,j)
c
            evy(i,j) = (2.d0/3.d0)*eevy(i,j)
            evy(i,j2) = eevy(i,j)/3.d0
            evy(i2,j) = evy(i,j2)
            evy(i2,j2) = evy(i,j)
c
            evz(i,j) = -cmip(i,j)/2.d0
            evz(i,j2) = cmip(i,j)/2.d0
            evz(i2,j) = evz(i,j)
            evz(i2,j2) = evz(i,j2)
c
            eb(i,j) = (2.d0/3.d0)*cmip(i,j)
            eb(i,j2) = cmip(i,j)/3.d0
            eb(i2,j) = eb(i,j2)
            eb(i2,j2) = eb(i,j)
c
   45     continue
   50   continue

      else

        do 150 i=1,nln2
          i2 = i+nln2
          do 145 j=1,nln2
            j2 = j+nln2
c
            edxx(i,j) = aax(i,j)
            edxx(i,j2) = 0.0d0
            edxx(i2,j) = edxx(i,j2)
            edxx(i2,j2) = edxx(i,j)
c
            edyy(i,j) = aay(i,j)
            edyy(i,j2) = 0.0d0
            edyy(i2,j) = edyy(i,j2)
            edyy(i2,j2) = edyy(i,j)
c
            edzz(i,j) = cmip(i,j)/2.d0
            edzz(i,j2) = -cmilump(i,j)/2.d0
            edzz(i2,j) = edzz(i,j2)
            edzz(i2,j2) = edzz(i,j)

c
            edxy(i,j) = aaxy(i,j)
            edxy(i,j2) = 0.0d0
            edxy(i2,j) = 0.0d0
            edxy(i2,j2) = edxy(i,j)    
c
            edyz(i,j) = 0.0d0
            edyz(i,j2) = 0.0d0
            edyz(i2,j) = 0.0d0
            edyz(i2,j2) = 0.0d0
c
            edxz(i,j) = 0.0d0
            edxz(i,j2) = 0.0d0
            edxz(i2,j) = 0.0d0
            edxz(i2,j2) = 0.0d0
c
            evx(i,j) = eevx(i,j)
            evx(i,j2) = 0.0d0
            evx(i2,j) = evx(i,j2)
            evx(i2,j2) = evx(i,j)
c
            evy(i,j) = eevy(i,j)
            evy(i,j2) = 0.0d0
            evy(i2,j) = evy(i,j2)
            evy(i2,j2) = evy(i,j)
c
            evz(i,j) = -cmip(i,j)/2.d0
            evz(i,j2) = cmilump(i,j)/2.d0
            evz(i2,j) = -evz(i,j2)
            evz(i2,j2) = -evz(i,j)
c
            eb(i,j) = (2.d0/3.d0)*cmip(i,j)
            eb(i,j2) = cmilump(i,j)/3.d0
            eb(i2,j) = eb(i,j2)
            eb(i2,j2) = eb(i,j)
c
  145     continue
  150   continue

      end if
c
      do 60 i=1,nln2
        do 59 j=1,nln2
          ec(i,j)=cmip(i,j)
   59   continue
   60 continue
      return
      end

c***************************************************************************

      subroutine masbal_trans(time,ntloop,isp,cexch,output)

c***************************************************************************
c compute mass balance for mobile species
c
      include 'tbc.prm'
      include 'tbc.dim'

      integer ntloop
      logical output
c
c  ...Declare some internal variables
c    
      common /sums/ scleft,scright,scback,scfront,sctop,scbot,
     &       scnotbq,scflndc,scflndcm,scflbc2,scflbc2m,scflss,
     &       scflssm,scflbc1,scflbc1m,scflbc3,scflbc3m,stotin,
     &       stotout,sstorage,sdmexchange
      double precision scleft(maxsp),scright(maxsp),scback(maxsp),
     &    scfront(maxsp),sctop(maxsp),scbot(maxsp),scnotbq(maxsp),
     &    scflndc(maxsp),scflndcm(maxsp),scflbc2(maxsp),scflbc2m(maxsp),
     &    scflss(maxsp),scflssm(maxsp),scflbc1(maxsp),scflbc1m(maxsp),
     &    scflbc3(maxsp),scflbc3m(maxsp),stotin(maxsp),stotout(maxsp),
     &    sstorage(maxsp),sdmexchange(maxsp)
c      save /sums/

      double precision dmstoret
      dimension cexch(maxnn*maxsp)
c***************************************************************************

c
c  ...Initialize some variables
c
      if (ntloop.le.1) then
        scleft(isp)=0.d0
        scright(isp)=0.d0
        scback(isp)=0.d0
        scfront(isp)=0.d0
        sctop(isp)=0.d0
        scbot(isp)=0.d0
        scnotbq(isp)=0.d0
        scflndc(isp)=0.d0
        scflndcm(isp)=0.0d0
        scflbc2(isp)=0.0d0
        scflbc2m(isp)=0.0d0
        scflss(isp)=0.0d0
        scflssm(isp)=0.0d0
        scflbc1(isp)=0.0d0
        scflbc1m(isp)=0.0d0
        scflbc3(isp)=0.0d0
        scflbc3m(isp)=0.0d0
      endif

      dsmall = 1.0d-6
      dmstoret=0.0d0
      dmstorepm=0.0d0
      dmexchange=0.0d0
      dmsorbed=0.0d0
      dmdecay=0.0d0
      dmdecays=0.0d0
      cnotbq=0.0d0
      cbound=0.0d0
      cnet=0.0d0
      cflbc1=0.0d0
      cflbc2=0.0d0
      cflbc3=0.0d0
      cflndc=0.0d0
      cflss=0.0d0
      cflbc1m=0.0d0
      cflbc2m=0.0d0
      cflbc3m=0.0d0
      cflndcm=0.0d0
      cflssm=0.0d0
      istart=(isp-1)*nn +1
      istart2=istart-1
      do 10 i=1,nn
        gb(i)=0.0d0
  10  continue 

      mbal_flag=.true.
c
c  ...Get flux at fixed concentration nodes
c
      call pm_assem_trans(ntloop,isp,cexch)
c
c  ...Get flux at third-type nodes
c
      if(nbc3tot.gt.0) then
        time=t(ntloop)
        call bc3(time,isp)
      end if
c
c  ...Multiply flux by time interval
c
      do 400 i=1,nn
         gb(i)=gb(i)*delta
         if(icc(i).eq.0) then
            if(gb(i).gt.0.0d0) cflbc3=cflbc3+gb(i)
            if(gb(i).lt.0.0d0) cflbc3m=cflbc3m+gb(i)
         else
            if(gb(i).gt.0.0d0) cflbc1=cflbc1+gb(i)
            if(gb(i).lt.0.0d0) cflbc1m=cflbc1m+gb(i)
         endif
  400 continue
c
c  ...Compute advective flux at nodes that are 1st-type for flow
c     and either 1st-type or zero dispersive flux for transport 
c
c>><< Do it for finite element, otherwise finite diff
c     is like control volume and source/sinks are already computed
c
      if(.not.cvolume.and.ndc.gt.0) then
        do 500 i=1,ndc
          node=jm(i)
          node2 = node + istart2
crt          if(.not.type3(node).or.(icc(node).eq.1)) then
            termc=fluxdch(i)*cu(node2)*delta
            gb(node)=gb(node)+termc
            if(termc.gt.0.0d0) cflndc=cflndc+termc
            if(termc.lt.0.0d0) cflndcm=cflndcm+termc
crt          end if
  500   continue
      elseif(cvolume.and.ndc.gt.0) then
        do 505 i=1,ndc
          node=jm(i)
          node2 = node + istart2
ccc          if((icc(node).eq.0).and..not.type3(node)) then
          if((icc(node).eq.0).and.fluxdch(i).lt.0.0d0) then
            termc=fluxdch(i)*cu(node2)*delta
            gb(node)=gb(node)+termc
            if(termc.gt.0.0d0) cflndc=cflndc+termc
            if(termc.lt.0.0d0) cflndcm=cflndcm+termc
          end if
  505   continue
      end if
c
c  ...Compute advective flux at nodes that are non-zero 2nd-type for
c     flow and 1st-type for transport
c
      if(nbc2.gt.0.and.cvolume) then
        do 600 i=1,nbc2
          node=jbc2(i)
          node2 = node + istart2
          if(.not.type3(node).and.(icc(node).ne.1).and.
     &      fluxbc2(i).lt.0.0d0) then
            term=fluxbc2(i)*cu(node2)*delta
cws     Begin November 2002
cws            if(fluxbc2(i).lt.0.d0)term=0.d0
cws     End November 2002
            gb(node)=gb(node)+term
            if(term.gt.0.0d0) cflbc2=cflbc2+termc
            if(term.lt.0.0d0) cflbc2m=cflbc2m+termc
          end if 
  600   continue
      elseif(nbc2.gt.0.and..not.cvolume) then
        do 605 i=1,nbc2
          node=jbc2(i)
          node2 = node + istart2
          if(.not.type3(node)) then
            term=fluxbc2(i)*cu(node2)*delta
cws     Begin November 2002
cws            if(fluxbc2(i).lt.0.d0)term=0.d0
cws     End November 2002
            gb(node)=gb(node)+term
            if(term.gt.0.0d0) cflbc2=cflbc2+termc
            if(term.lt.0.0d0) cflbc2m=cflbc2m+termc
          end if
  605   continue
      end if
c
c  ...Compute advective flux at nodes that are internal
c     sources/sinks for flow
c
      if(nwell.gt.0) then
        ncount=0
        do 800 i=1,nwell
          if(flowrate(i).lt.0.0d0) then               ! crt
            do 795 j=1,nn_well(i)
              node=jq(i,j)     
              node2 = node + istart2
              ncount=ncount+1
cc            if(.not.type3(node)) then
              termc=gbwellmb(ncount)*cu(node2)*delta
c change for injection wells with prescribed concentrations
              if(icc(node).eq.0) gb(node)=gb(node)+termc
              cnotbq=cnotbq+termc
              if(termc.gt.0.0d0) cflss=cflss+termc
              if(termc.lt.0.0d0) cflssm=cflssm+termc
cc            end if
  795       continue 
          else
            scontrl=0.d0
            found=.false.
            do 110 int=1,ninjc(i,isp)
              timemin=toninjc(i,isp,int)-dsmall
              timeplus=toffinjc(i,isp,int)+dsmall
              if(t(ntloop).gt.timemin.and.
     &          t(ntloop).lt.timeplus) then
                scontrl=cinjc(i,isp,int)
                found=.true.
                goto 115
              end if
  110       continue
  115       continue
            if(found) then
              do 130 j=1,nn_well(i)
                ncount=ncount+1
                node=jq(i,j)
                termc=gbwellmb(ncount)*scontrl*delta
                gb(node)=gb(node)+termc
                cflss=cflss+termc
                cnotbq=cnotbq+termc
  130         continue
            else
              ncount=ncount+nn_well(i)
            end if
          end if                                      ! crt
  800   continue 
      end if
 6647 format(i5,d14.6,d19.6,d14.6)
c
c  ...Output solute flux and concentration and specified nodes
c
c      if(outfc) then
c        write(62,*) ' Solute flux and concentration'
c        write(62,*) ' Time:',t(ntloop)
c        do 2460 i=1,noutfc
c          node=ioutfc(i)
c          node2 = node + istart2
c          write(62,6820) node,gb(node)/delta,cu(node2)
c 2460   continue
c      end if
c 6820 format(i7,2(2x,e12.5))
c
c  ...Determine flux crossing the different boundaries
c
c  not done--   store solute flux at boundary nodes in existing vector cres()
c     (vector cres() is used in the solver)
c     This is done only if the grid is regular i.e. nln=8
c
        if(nln.eq.8) then
c
c  ...Add up total mass flux at interior nodes and on boundaries
c
          do 900 i=1,nn
            if(bound(i)) then
              cbound=cbound+gb(i)
            end if
            cnet=cnet+gb(i)
  900     continue
c
c  ...Bottom of domain (i.e. first xy-level)
c
          cbot=0.0d0
          do 1000 i=1,nndsl
            cbot=cbot+gb(i)
 1000     continue
c
c  ...Top of domain (i.e. last xy-level)
c
          ctop=0.d0
          istart=nndsl*(nz-1) + 1
          iend=nn
          do 3232 i=istart,iend
            ctop=ctop+gb(i)
 3232     continue
c
c  ...Left of domain (i.e. the vertical section at x(1))
c
          cleft=0.0d0
          istart=1
          iend=nn-nx+1
          do 3234 i=istart,iend,nx
            cleft=cleft+gb(i)
 3234     continue
c
c  ...Right of domain (i.e. the vertical section at x(nx))
c
          cright=0.0d0
          istart=nx
          iend=nn
          do 3236 i=istart,iend,nx
            cright=cright+gb(i)
 3236     continue
c
c  ...Front of domain (i.e. the vertical section at y(1))
c
          cfront=0.0d0
          do 3242 i=1,nz
            istart=(i-1)*nndsl+1
            iend=istart+nx-1
            do 3238 j=istart,iend
              cfront=cfront+gb(j)
 3238       continue
 3242     continue
c
c  ...Back of domain (i.e. the vertical section at y(ny))
c
          cback=0.0d0
          nndslb=nx*(ny-1)
          do 3246 i=1,nz
            istart=(i-1)*nndsl+nndslb+1
            iend=istart+nx-1
            do 3244 j=istart,iend
              cback=cback+gb(j)
 3244       continue
 3246     continue

          scleft(isp)=scleft(isp)+cleft
          scright(isp)=scright(isp)+cright
          scback(isp)=scback(isp)+cback
          scfront(isp)=scfront(isp)+cfront
          sctop(isp)=sctop(isp)+ctop
          scbot(isp)=scbot(isp)+cbot
          scnotbq(isp)=scnotbq(isp)+cnotbq

          scflndc(isp)=scflndc(isp)+cflndc
          scflndcm(isp)=scflndcm(isp)+cflndcm
          scflbc2(isp)=scflbc2(isp)+cflbc2
          scflbc2m(isp)=scflbc2m(isp)+cflbc2m
          scflss(isp)=scflss(isp)+cflss
          scflssm(isp)=scflssm(isp)+cflssm
          scflbc1(isp)=scflbc1(isp)+cflbc1
          scflbc1m(isp)=scflbc1m(isp)+cflbc1m
          scflbc3(isp)=scflbc3(isp)+cflbc3
          scflbc3m(isp)=scflbc3m(isp)+cflbc3m

c
c  ...Write computed mass changes at boundaries (if required)
c
          if(output) then
               write(66,6005) spname(isp),cleft,scleft(isp),
     &            cright,scright(isp),cback,scback(isp),
     &            cfront,scfront(isp),ctop,sctop(isp),
     &            cbot,scbot(isp),cnotbq,scnotbq(isp),cnet
               write(66,6050)
     &                  cflndc,cflndcm,scflndc(isp),scflndcm(isp),
     &                  cflbc2,cflbc2m,scflbc2(isp),scflbc2m(isp),
     &                  cflss,cflssm,scflss(isp),scflssm(isp),
     &                  cflbc1,cflbc1m,scflbc1(isp),scflbc1m(isp),
     &                  cflbc3,cflbc3m,scflbc3(isp),scflbc3m(isp)
          end if

 6050   format(/,'Nodal mass changes',t35,'IN',t49,'OUT',
     &           t75,'SUM IN',t89,'SUM OUT',/,
     &   'Fixed head nodes',t30,2(d12.4),t70,2(d12.4),/,
     &   'Fixed h-flux nodes',t30,2(d12.4),t70,2(d12.4),/,
     &   'Source-sink nodes',t30,2(d12.4),t70,2(d12.4),/,
     &   'Fixed conc nodes',t30,2(d12.4),t70,2(d12.4),/,
     &   'Third-type nodes',t30,2(d12.4),t70,2(d12.4))
 6005   format(/,'Mass Balance for ',a20,/,30('-'),/,
     &  'Cumulative nodal mass changes',t50,'in time step',
     &   t70,'sum',/,
     &  '  Nodes on left boundary:',t50,d12.4,t70,d12.4,/,
     &  '  Nodes on right boundary:',t50,d12.4,t70,d12.4,/,
     &  '  Nodes on back boundary:',t50,d12.4,t70,d12.4,/,
     &  '  Nodes on front boundary:',t50,d12.4,t70,d12.4,/,
     &  '  Nodes on top boundary:',t50,d12.4,t70,d12.4,/,
     &  '  Nodes on bottom boundary:',t50,d12.4,t70,d12.4,/,
     &  '  Nodes at internal sources/sinks:',t50,d12.4,t70,d12.4,/,
     &  'Mass addition/removal at all nodes:',t50,d12.4)

      elseif(nln.eq.6) then
        cnet=0.0d0
        do 1200 i=1,nn
          cnet=cnet+gb(i)
 1200   continue
        if(output) write(66,6010) spname(isp),cnet
 6010   format(/,20x,'Mass Balance, ',a20,/,20x,20('-'),/,
     &  'Cumulative nodal mass changes',/,
     &  'Mass addition/removal at all nodes:',t50,g15.8)
      end if
c
c  ...Compute total mass stored in domain
c
      dmstoret=dmstorepm+dmstoref+dmsorbed
c
c  ...Sum up stored and decayed mass
c
      dmdecay=dmdecay*delta
      dmdecays=dmdecays*delta
      sstorei=dmassi(isp)+dmisorbed(isp)
      sstore=dmstoret+dmdecay+dmdecays-dmexchange-dmassi(isp)-
     &   dmisorbed(isp)
      errmass=cnet-sstore

      if(output) then
        write(66,6015) dmstorepm,dmsorbed,dmstoret,dmdecay,
     &         dmdecays,dmexchange,sstorei,sstore
        write(66,6030) errmass
      end if
 6015 format(/'Summary of mass stored in domain',/,
     & '  Mass in solution in porous media elements:',t50,d12.4,/,
     & '  Mass sorbed in domain:',t50,d12.4,/,
     & '  Total mass stored in domain:',t50,d12.4,/,
     & '  Total mass lost by decay:',t50,d12.4,/,
     & '  Total sorbed mass lost by decay:',t50,d12.4,/,
     & '  Mass exchanged or degraded via chemical step:',t50,d12.4,/,
     & '  Mass stored in domain prior to time step:',t50,d12.4,/,
     & 'Net change in mass storage for time step',t50,d12.4,/)

 6030 format('Error (mass added/removed - net change):',t45,d12.4)
c
c  ...Reset values for next time step
c
        dmassi(isp)=dmstorepm
        dmisorbed(isp)=dmsorbed
c
c  ...Arbitrarily make all mass sorbed to be in porous media, this
c     wont affect calculations

        sdmexchange(isp)=sdmexchange(isp)+dmexchange
        totin= cflndc+ cflbc2+ cflss+ cflbc1+ cflbc3
        stotin(isp)=stotin(isp)+totin
        totout=cflndcm+cflbc2m+cflssm+cflbc1m+cflbc3m
        stotout(isp)=stotout(isp)+totout
        storage=dmstoret-sstorei
        sstorage(isp)=sstorage(isp)+storage

        if (output) then
          write(65,6630) spname(isp)
 6630     format('Mass change for ',a20)
          write(65,4568) totin,stotin(isp),totout,stotout(isp),
     &         storage,sstorage(isp),dmexchange,sdmexchange(isp)
 4568     format('   Total mass input of species by transport',
     &         t50,g15.8,t70,g15.8,/,
     &         '   Total mass output of species by transport',
     &         t50,g15.8,t70,g15.8,/,
     &         '   Change of storage in phase',
     &         t50,g15.8,t70,g15.8,/,
     &         '   Total chemical mass change',
     &         t50,g15.8,t70,g15.8)
        endif

      return
      end

c***************************************************************************

      subroutine upsfac(velx,vely,velz,almax,betmax,gammax,
     &                  facx,facy,facz,qx2,qy2,qz2)

c***************************************************************************
 
      double precision velx,vely,velz,vrelx,vrely,vrelz,qx2,qy2,qz2
      double precision almax,betmax,gammax,facx,facy,facz
      double precision sum,dir,qsqr

      sum=almax+betmax+gammax 
      if(dabs(sum).gt.1.0d-3) then
        qsqr=qx2+qy2+qz2
        if(qsqr.lt.1.0d-5) qsqr=1.0d0
        vrelx=velx/qsqr
        dir=1.0d0
        if(vrelx.lt.0.0d0) dir=-1.0d0
        facx=almax*dir
        if(dabs(vrelx).lt.1.0d-5) facx=0.0d0
        
        vrely=vely/qsqr
        dir=1.0d0
        if(vrely.lt.0.0d0) dir=-1.0d0
        facy=betmax*dir
        if(dabs(vrely).lt.1.0d-5) facy=0.0d0

        vrelz=velz/qsqr
        facz=gammax
        if(dabs(vrelz).lt.1.0d-5) facz=0.0d0
      end if
      return
      end

c***************************************************************************
 
      subroutine cvol(aa1,aa2,aa3,aa4,aa5,aa6,aa10,aa11,
     & aa21,aa22,aa23,istart2,node)

c***************************************************************************
c
c  ...Compute the elemental matrices and assemble the global matrix
c
c***************************************************************************

      include 'tbc.prm'
      include 'tbc.dim'

      dimension aa(maxnln,maxnln),gg(maxnln),pot(maxnln)
      dimension oldc(maxnln),tdis(3),tvel(3),ib(3)
      dimension nbrx(8),nbry(8),nbrz(8),node(maxnln)

      data nbrx / 2,1,4,3,6,5,8,7 /
      data nbry / 4,3,2,1,8,7,6,5 /
      data nbrz / 5,6,7,8,1,2,3,4 /
c
c  ...Initialize arrays and vectors
c
      do 10 j=1,nln
        do 5 i=1,nln
          aa(i,j)=0.0d0
    5   continue
        gg(j)=0.0d0
        pot(j)=ctemp(node(j))
        oldc(j)=cic(istart2+node(j))
   10 continue
c
c  ...Form elemental matrix
c  ...Lump the storage term
c
      if(.not.finite_diff) then
        do 30 i=1,nln
          do 20 j=i+1,nln
            term = twc*( aa1*edxx(i,j)+aa2*edyy(i,j)+
     &             aa3*edzz(i,j) + aa4*edxy(i,j) + aa5*edxz(i,j) +
     &             aa6*edyz(i,j) )
            termv = twc*( (aa21*edxx(i,j)+aa22*edyy(i,j)+
     &             aa23*edzz(i,j) ) * (pot(j)-pot(i)) )
            if(.not.upstrvel) then
cc              term = term + termv*0.5d0
              gg(i) = gg(i) + term*twratioc*(oldc(j)-oldc(i)) +
     &                termv*0.5d0*(oldc(j)+oldc(i))
              gg(j) = gg(j) - term*twratioc*(oldc(j)-oldc(i)) -
     &                termv*0.5d0*(oldc(j)+oldc(i))
              aa(i,j) = term + termv*0.5d0
              aa(j,i) = term - termv*0.5d0
              aa(i,i) = aa(i,i) - term + termv*0.5d0
              aa(j,j) = aa(j,j) - term - termv*0.5d0
            else
              if(termv.gt.0) then
                aa(i,i) = aa(i,i) - term + termv
                aa(i,j) = term
                aa(j,j) = aa(j,j) - term
                aa(j,i) = term - termv
                gg(i) = gg(i) + term*twratioc*(oldc(j)-oldc(i))
     &                  + termv*twratioc*oldc(i)
                gg(j) = gg(j) - term*twratioc*(oldc(j)-oldc(i))
     &                  - termv*twratioc*oldc(i)
              else
                aa(i,i) = aa(i,i) - term
                aa(i,j) = term + termv
                aa(j,j) = aa(j,j) - term - termv
                aa(j,i) = term
                gg(i) = gg(i) + term*twratioc*(oldc(j)-oldc(i))
     &                  + termv*twratioc*oldc(j)
                gg(j) = gg(j) - term*twratioc*(oldc(j)-oldc(i))
     &                  - termv*twratioc*oldc(j)
              end if
            end if

   20     continue
          aa(i,i)=aa(i,i)+aa10+aa11
          gg(i)=gg(i)+ aa10*oldc(i)
   30   continue

      else

        do 40 i=1,nln
          ix=nbrx(i)
          iy=nbry(i)
          iz=nbrz(i)
          tdis(1)=twc*aa1*edxx(i,ix)
          tdis(2)=twc*aa2*edyy(i,iy)
          tdis(3)=twc*aa3*edzz(i,iz)
          tvel(1)=twc*aa21*edxx(i,ix)*(pot(ix)-pot(i))
          tvel(2)=twc*aa22*edyy(i,iy)*(pot(iy)-pot(i))
          tvel(3)=twc*aa23*edzz(i,iz)*(pot(iz)-pot(i))
          if(.not.upstrvel) then
            aa(i,ix) = tdis(1)+tvel(1)*0.5d0
            aa(i,iy) = tdis(2)+tvel(2)*0.5d0
            aa(i,iz) = tdis(3)+tvel(3)*0.5d0
            adiag =  - tdis(1) + tvel(1)*0.5d0
     &        - tdis(2) + tvel(2)*0.5d0 - tdis(3) + tvel(3)*0.5d0
            gg(i) = aa10*oldc(i) + twratioc*
     &        ( aa(i,ix)*oldc(ix) + aa(i,iy)*oldc(iy)
     &       + aa(i,iz)*oldc(iz) + adiag*oldc(i) )
            aa(i,i) = adiag + aa10 + aa11
          else
            ib(1)=ix
            ib(2)=iy
            ib(3)=iz
            do 35 j=1,3
              if(tvel(j).gt.0) then
                aa(i,ib(j)) = tdis(j)
                aa(i,i) = aa(i,i) - tdis(j) + tvel(j)
                gg(i) = gg(i) + tdis(j)*twratioc*(oldc(ib(j))-oldc(i))
     &                  + tvel(j)*twratioc*oldc(i)
              else
                aa(i,ib(j)) = tdis(j) + tvel(j)
                aa(i,i) = aa(i,i) - tdis(j)
                gg(i) = gg(i) + tdis(j)*twratioc*(oldc(ib(j))-oldc(i))
     &           + tvel(j)*twratioc*oldc(ib(j))
              end if
  35        continue
            aa(i,i) = aa(i,i) + aa10 + aa11
            gg(i) = gg(i) +aa10*oldc(i)
          end if
   40   continue
      end if
c
c  ...Global flow matrix assembly
c
      if(.not.mbal_flag) then
        do 200 i=1,nln
          n1=node(i)
          do 100 j=1,nlnj
            jj=jloop(i,j)
            n2=node(jj)
            call find(n1,n2,iband)
cc            if(iband.ne.0) then
              r(iband) = r(iband)+aa(i,jj)
cc            end if
  100     continue
          gb(n1)= gb(n1) + gg(i)
  200   continue
      elseif(mbal_flag) then
        do 500 i=1,nln
          n1=node(i)
          if(icc(n1).eq.1) then
            sumleft=0.0d0
            do 400 j=1,nlnj
              jj=jloop(i,j)
              n2=node(jj)
              call find(n1,n2,iband)
c              if(iband.ne.0) then
                sumleft = sumleft+aa(i,jj)*cu(istart2+n2)
c              end if
  400       continue
            gb(n1)=gb(n1) + sumleft -gg(i)
          end if
  500   continue
      end if

      return 
      end

c*****************************************************************************
c
C CONVERSION OF a POSITIVE integer-NUMBER TO A*12 CHARACTER STRING
c
c*****************************************************************************
c
      subroutine FLTOAS(ZAHL,fname,lenfname)

      INTEGER*4 STELLEN,zahl,lenfname
      real*4 rzahl,number
      character*60 fname

      if ((zahl.gt.99999999).or.(zahl.lt.0)) stop
      if (zahl.eq.0) then
        fname(1:6)='0o.dat'
        lenfname=6
      else
        STELLEN=INT(ALOG10(float(ZAHL)))+1
        rzahl=float(zahl)/10.**stellen

        DO 121 I=1,stellen
          number=rZAHL*10.000001
          fname(I:I)=CHAR(int(number)+48)
          rzahl=number-float(int(number))
 121    CONTINUE

        fname(stellen+1:stellen+5)='o.dat'
        lenfname=stellen+5
      endif
      return
      END
















